/*\
|*| --------------------------------------------------------------------------
|*|     S3 generic I/O code
|*| --------------------------------------------------------------------------
|*|
|*|	Copyright (C) 1995 by Steffen Seeger, [seeger@physik.tu-chemnitz.de]
|*|
|*|	This program is free software; you can redistribute it and/or modify
|*|	it under the terms of the GNU General Public License as published by
|*|	the Free Software Foundation; either version 2, or (at your option)
|*|	any later version.
|*|
|*|	This program is distributed in the hope that it will be useful,
|*|	but WITHOUT ANY WARRANTY; without even the implied warranty of
|*|	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|*|	GNU General Public License for more details.
|*|
|*|	You should have received a copy of the GNU General Public License
|*|	along with this program; see the file COPYING.  If not, write to
|*|	the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
|*|
|*| ---------------------------------------------------------------------------
\*/

#ifndef _s3_io_h
#define _s3_io_h

extern unsigned short INS1r;	/* color/mono mode depended IO ports */
extern unsigned short CRTI, CRTD;
extern unsigned short ATCR;
extern unsigned short FCTRLw;

/*\
|*|	CRT register operations
\*/

static inline void outbCRT(unsigned char value, unsigned char crt_reg)
 {
   outb(crt_reg, CRTI); outb(value, CRTD);
   #ifdef DEBUG_IO
     TRACE(printk("CRT_%.2x <- %.2x\n", crt_reg, value));
   #endif
 }

static inline unsigned char inbCRT(unsigned char crt_reg)
 { unsigned char foo;
   outb(crt_reg, CRTI); foo = inb(CRTD);
   #ifdef DEBUG_IO
     TRACE(printk("CRT_%.2x -> %.2x\n", crt_reg, foo));
   #endif
   return foo;
 }

/*\
|*|	DAC register operations
|*|
|*|     NOTE:	The register numbers are rearranged to allow for simple
|*|		arithmetics to select the I/O ports to access. (on a x64)
|*|
|*|     Translation scheme: (RS[0:3] (bin), new register number (hex))
|*|
|*|		(0010,0), (0011,1), (0000,2), (0001,3),
|*|		(0110.4), (0111,5), (0100,6), (0101,7),
|*|		(1010,8), (1011,9), (1000,A), (1001,B),
|*|		(1110,C), (1111;D), (1100,E), (1101;F)
\*/


static inline void outbDAC(unsigned char value, unsigned char dac_reg)
 {
   outbCRT((inbCRT(CRT_DACCONTROL) & ~0x03) | (dac_reg >> 2), CRT_DACCONTROL);
   outb(value, DAC_BASE + (dac_reg & 0x03));
   #ifdef DEBUG_IO
     TRACE(printk("DAC_%.1x <- %.2x\n", dac_reg, value)); 
   #endif
 }

static inline unsigned char inbDAC(unsigned char dac_reg)
 { unsigned char foo;
   outbCRT((inbCRT(CRT_DACCONTROL) & ~0x03) | (dac_reg >> 2), CRT_DACCONTROL); 
   foo = inb(DAC_BASE + (dac_reg & 0x03));
   #ifdef DEBUG_IO
     TRACE(printk("DAC_%.1x -> %.2x\n",dac_reg, foo));
   #endif
   return foo;
 }

#endif /* _s3_io_h */
