/* 

   Copyright (C) 1995 Andreas Beck - becka@hp.rz.uni-duesseldorf.de

   If you do any modifications, I would like you to send diffs to me
   to allow for collecting a more and more complete set of drivers and
   to improve existing ones.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

extern char OpenFont[8192];

int _setmode(struct ggi_Timing *tm);
int setmode(void);
int getmode(void);
int keepmode(void);
int getdeffont(void);
int setdeffont(void);
int setdispstart(void);
int getdispstart(void);
int _getsetfont_hw(char *buffer,int mode);
int getstatesize(void);
int savestate(void);
int _restorestate(struct ggi_StateInfo *State);
int restorestate(void);
int bgmode(int onoff);
int getvt(void);

/* The following code has been rewritten from scratch using the Linux
 * kernel (asm/pgtable.h in particular) as a model. It makes the use 
 * of the code from somebody else that used to be here unnecessary.
 *
 * You MUST call invalidate after using these functions, else really strange 
 * effects will show up !
 */
	
static inline void fast_remap_page_range(struct task_struct *tsk,unsigned long addr, unsigned long dest,unsigned long size, pgprot_t prot)
{ pte_t pte_entry = pte_mkold(mk_pte(dest, prot));
  pte_t *ptr;
  unsigned long next_pmd;

  size+=addr;
  next_pmd=addr&PMD_MASK;
  
  while(addr<size)
  { ptr=pte_offset(pmd_offset(pgd_offset(tsk,addr),addr),addr);
    next_pmd+=PMD_SIZE;
    if (next_pmd>size) next_pmd=size;
    while(addr<next_pmd)
    { *ptr++=pte_entry;			/* Set page-table to current entry */
      pte_val(pte_entry)+=PAGE_SIZE;	/* Increase address to map */
      addr+=PAGE_SIZE;
    }
  }
}
static inline void fast_unmap_page_range(struct task_struct *tsk,unsigned long addr, unsigned long size)
{ pte_t *ptr;
  unsigned long next_pmd;
  
  size+=addr;
  next_pmd=addr&PMD_MASK;
  
  while(addr<size)
  { ptr=pte_offset(pmd_offset(pgd_offset(tsk,addr),addr),addr);
    next_pmd+=PMD_SIZE;
    if (next_pmd>size) next_pmd=size;
    while(addr<next_pmd)
    { pte_clear(ptr++);addr+=PAGE_SIZE; }
  }
}

