/**
  *  Include file for General Graphics Interface module
  **/

/* Maximum number of consoles that can be under GGI-control 
   simultaneously - this will increase module size quite a bit */
#define MAX_CONS_NUM 8
#define DEV_NUM_SETUP CurrState=file->private_data
#define VM_DEV_NUM_SETUP CurrState=(struct ggi_StateInfo *)area->vm_offset

#ifdef DEBUG
void dump_tm(struct ggi_Timing *tm,char *label,int x);
#else
#define dump_tm(a,b,c)
#endif

void   kgi_GetMonitorParameters(struct ggi_MonParams * MP);
int    kgi_CheckMonitorTiming  (struct ggi_Timing * MT,int olderr);
int    kgi_MonitorIoctl(struct inode *inode, struct file *file, \
        unsigned int cmd, unsigned long arg);
int    kgi_MonitorInit(void);

struct ggi_Range *kgi_GetClockParameters(void);
int    kgi_CheckClockTiming(struct ggi_Timing * MT,int olderr);
int    kgi_SetClockTiming  (struct ggi_Timing * MT);
int    kgi_ClockIoctl(struct inode *inode, struct file *file, \
        unsigned int cmd, unsigned long arg);

void   kgi_GetChipsetParameters(struct ggi_ChipParams *);
int    kgi_CheckChipsetTiming(struct   ggi_Timing * MT,int olderr);
int    kgi_SetChipsetTiming  (struct   ggi_Timing * MT);
int    kgi_ChipsetIoctl(struct inode *inode, struct file *file, \
        unsigned int cmd, unsigned long arg);

int    kgi_RamdacIoctl(struct inode *inode, struct file *file, \
        unsigned int cmd, unsigned long arg);
int    kgi_CheckRamdacTiming(struct   ggi_Timing * MT,int olderr);
int    kgi_SetRamdacTiming  (struct   ggi_Timing * MT);
int    kgi_RamdacInit(void);

int kgi_Ioctl(struct inode *inode, struct file *file, \
        unsigned int cmd, unsigned long arg);
int kgi_Mmap(struct inode * inode, struct file * file, struct vm_area_struct * vma);

struct ggi_ChipParams ChipPar;

struct ggi_Coord    { int x,y  ; };

struct ggi_StateInfo 
	{ struct ggi_Timing_req	ModeNow;
	  int		      	bgmode,available,vt_num;
	  struct ggi_Drawinfo	*drawinfo;	/* Pointer to user-space drawinfo */
	  struct ggi_Coord	dispstart;
	  struct ggi_Palentry	palette[256];
	} StateNow[MAX_CONS_NUM];

struct ggi_StateInfo OpenState,*CurrState;

extern char parameters[256];	/* parameter transfer buffer */

