/*\
|*| --------------------------------------------------------------------------
|*|     GGI general definitons, structures, etc.
|*| --------------------------------------------------------------------------
|*|
|*|	Copyright (C) 1995 by Andreas Beck [becka@hp.rz.uni-duesseldorf.de]
|*|
|*|	This program is free software; you can redistribute it and/or modify
|*|	it under the terms of the GNU General Public License as published by
|*|	the Free Software Foundation; either version 2, or (at your option)
|*|	any later version.
|*|
|*|	This program is distributed in the hope that it will be useful,
|*|	but WITHOUT ANY WARRANTY; without even the implied warranty of
|*|	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|*|	GNU General Public License for more details.
|*|
|*|	You should have received a copy of the GNU General Public License
|*|	along with this program; see the file COPYING.  If not, write to
|*|	the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
|*|
|*| ---------------------------------------------------------------------------
\*/


#include <linux/fs.h>	/* Needed for some prototypes - so we include it */
#define VERSION "0.1.3"

/**
  *  Include file for General Graphics Interface
  **/

#define TRUE 1
#define FALSE 0 

struct GGI_Range { int min,max; };

enum GGI_Disptype {	BW    = 0,
			EGA_8 = 8,
			EGA_16=16,
			VGA   =24,
			T_MONO= 1 };
/* The MONO suffix means grayscale monitor - or (|) it to the rest ... */

/* Some monitors require composite sync signals thus we should support the video output wave
   form according to the RS-343A spec. */

enum GGI_Synctype {	SYNC_NORMAL     = 0,
			SYNC_ON_RED     = 1, 	/* these can be ORed together */
			SYNC_ON_GREEN   = 2,
			SYNC_ON_BLUE    = 4,
			BLANK_PEDESTRAL = 8,
			POWER_SAVE	=16};
			
struct GGI_MonParams 
 {
	struct GGI_Range  pfreq;	/* Pixel Frequency (Bandwidth)*/
	struct GGI_Range  hfreq;	/* Horizontal Frequency range */
	struct GGI_Range  vfreq;	/* Vertical   Frequency range */
	int		  xmaxdots,
			  ymaxdots;	/* Maximum resolution (mask size) */
	int		  xsize,
			  ysize;	/* picture size in mm */
	char		  manufact[64],	/* manufacturer */
			  model[64];	/* model */
	enum GGI_Disptype disptype;	/* type of display */
	enum GGI_Synctype synctype;	/* type of syncing */
 };


enum GGI_Graphtype { 	GT_TEXT		=  1,
		 	GT_1BIT		=  2,
		 	GT_4BIT_PLANES	=  4,
		 	GT_8BIT		=  8,
		 	GT_15BIT	= 16,
		 	GT_16BIT	= 32,
		 	GT_24BIT	= 64,
		 	GT_32BIT	=128	/* S3 RGB# format */ };

/*\
|*|     I (StS) would reserve 6 bits for each driver component (monitor, clock,
|*|     chipset, ramdac) and 8 bits for "general" flags.
\*/
enum GGI_Flags {	FL_INTERLACE	=  1,
			FL_DOUBLESCAN	=  2 };	/* What more ? */

struct GGI_ChipParams {
	int			ramsize;	/* Installed (useable) RAM size */
	int			xmaxdots,	/* Maximum resolution */
				ymaxdots;	/* (register limits)  */
	struct GGI_Range	clock;		/* DCLC range */
	char			manufact[64],	/* manufacturer */
				model[64];	/* model */
	enum GGI_Graphtype	graphtypes;	/* supported modes (ored together) */
	};


enum GGI_DacFlags { DAC_8BIT    = 1,
                    DAC_2XCLOCK = 2,
                    DAC_GAMMA   = 4
                  };

struct GGI_DacParams
 {
        char                    manufact[64]; /* manufacturer */
        char                    model[64];    /* model */
        enum   GGI_DacFlags     flags;        /* special device capabilities */
        struct GGI_Range        clock[10];    /* DCLK ranges      */
 };

enum GGI_DacRangeIndex { 
	DAC_MUX_1	= 0,	/* DCLK range if  1:1 multiplex */
	DAC_MUX_2	= 1,	/* DCLK range if  2:1 multiplex */ 
	DAC_MUX_4	= 2,	/* DCLK range if  4:1 multiplex */
	DAC_MUX_8	= 3,	/* DCLK range if  8:1 multiplex */
	DAC_MUX_16   	= 4,	/* DCLK range if 16:1 multiplex */
	DAC_MUX_32	= 5,	/* DCLK range if 32:1 multiplex */
	DAC_MUX_DOUBLE	= 8,	/* DCLK limit if internal clock doubling */
	DAC_MUX_NORMAL  = 9	/* DCLK limit if in normal mode */
};

struct GGI_Timing_req {
	/* This is requested by the user and
	   changed as necessary by the driver */
	int	xvisible,		/* visible window size */
		yvisible;
	int	xvirtual,		/* virtual resolution,  */
		yvirtual;		/* i.e. scrolling range */
	enum	GGI_Graphtype 	graphtype;
	int	xtextgrid,
		ytextgrid;		/* font size for text mode */
};


struct GGI_Timing {
	struct GGI_Timing_req tr;

	/* These will be auto-calculated by the various drivers */
	int	clock;			/* Pixel (or Dot) clock in Hz */
	int	clockdiv;		/* clock/2^clockdiv = Load (or Video clock) */
	int	xwidth,
		xsyncstart,
		xsyncend,
		xend;			/* like in XFree */
	int	ywidth,
		ysyncstart,
		ysyncend,
		yend;			/* like in XFree */
	int	xsyncpol,		/* X sync polarity */
		ysyncpol;		/* Y  "      "     */
	int 	ymagnify;		/* CRTC-9 bits 0-4  (+1) */
	enum	GGI_Flags	flags;	/* special things like INTERLACE,DOUBLE_SCAN */
	};

enum tc_err {	TC_OK=0,TC_NEWTRY,
		TC_LOWERED_CLOCK,TC_LOWEST_CLOCK,
		TC_X_TOO_SMALL  ,TC_Y_TOO_SMALL ,
		TC_X_TOO_BIG    ,TC_Y_TOO_BIG   ,
		TC_LAST_RESORT };

struct GGI_Palentry {unsigned char r,g,b;};

struct GGI_Drawcontext { int color;
			 int drawmode; };

