/***
 *** VGA chip programming functions for SVGATextMode
 *** Written by Koen Gadeyne (kmg@barco.be)
 ***
 *** version : 0.2
 ***/

#ifndef _VGA_PRG_H
#define _VGA_PRG_H

typedef unsigned char byte;

/*
 * Supported Register Sets
 */
 
#define RT_INDEX         1
#define RT_MEMMAP        2

#define NUM_REGSETS      5
enum t_regset            { REGSET_CRTC = 0 , REGSET_SEQ = 1 , REGSET_ATRCTL = 2, REGSET_GRCTL = 3, REGSET_MISC = 4 };
#define REGSET_STRINGS   { "CRTC" , "SEQ" , "ATRCTL" , "GRCTL", "MISC" }
#define REGSET_TYPE      { RT_INDEX, RT_INDEX, RT_INDEX, RT_INDEX, RT_MEMMAP }


/*
 * Cirrus Logic specific stuff
 */

#define CIRRUS_MIN_CLOCK 5.0
#define CIRRUS_MAX_CLOCK 85.0
#define CIRRUS_CLOCK_REF (14.318*2)   /* or 28.322 ??? */
#define CIRRUS_REF_KHZ (int)(CIRRUS_CLOCK_REF*1000)


/*
 * Clock selection error codes (MUST be negative !!!)
 */

#define CLKSEL_OUT_OF_BOUNDS    -4
#define CLKSEL_DONOTHING        -3
#define CLKSEL_ILLEGAL_NUM      -2
#define CLKSEL_NULLCLOCK        -1

/*
 * clock stuff
 */

#define MAX_CLOCKS              32   /* I suppose there are no chipsets with > 32 clocks out there */

#define MIN_CLOCK               0.0
#define MAX_CLOCK               500.0


/*
 * Some important VGA registers
 */

#define SEQ_INDEX	0x3C4
#define SEQ_DATA	SEQ_INDEX+1
#define CRTC_INDEX	0x3D4
#define CRTC_DATA	CRTC_INDEX+1
#define VGA_MISC_R	0x3CC
#define VGA_MISC_W	0x3C2
#define GR_CTL_INDEX	0x3CE
#define GR_CTL_DATA	GR_CTL_INDEX+1
#define ATR_CTL_INDEX	0x3C0
#define ATR_CTL_DATA_W	ATR_CTL_INDEX
#define ATR_CTL_DATA_R	ATR_CTL_INDEX+1
#define CGA_STATUS	0x3DA
#define ATR_CTL_INDEX_DATA_SWITCH  CGA_STATUS

#define Outb_SEQ(index, data)   ( outb ((index), SEQ_INDEX) , outb ((data), SEQ_DATA) )
#define Inb_SEQ(index)          ( outb ((index), SEQ_INDEX) , inb (SEQ_DATA) )

#define Outb_CRTC(index, data)  ( outb ((index), CRTC_INDEX) , outb ((data), CRTC_DATA) )
#define Inb_CRTC(index)         ( outb ((index), CRTC_INDEX) , inb (CRTC_DATA) )
 
#define Outb_GR_CTL(index, data) ( outb ((index), GR_CTL_INDEX) , outb ((data), GR_CTL_DATA) )
#define Inb_GR_CTL(index)        ( outb ((index), GR_CTL_INDEX) , inb (GR_CTL_DATA) )
 
void Outbit_SEQ (int index, int bitno, int data);

 void Outbit_CRTC (int index, int bitno, int data);

 void Outb_ATR_CTL (int index, int data);

 int Inb_ATR_CTL (int index);

 void Outbit_ATR_CTL (int index, int bitno, int data);

 void Outb_VGA_mem(int register_set, int data);

 int inb_VGA_mem(int register_set);

 void Outb_VGA_indexed(int register_set, int reg_index, int data);

 int inb_VGA_indexed(int register_set, int reg_index);

#define SET_CLOCKBITS_0_1(no)   ( outb(( inb(VGA_MISC_R) & 0xf3) | (((no) << 2) & 0x0C) , VGA_MISC_W) ) /* bits 0 and 1 of clock no */
#define SET_PIXELPAN(no)        ( Outb_ATR_CTL(0x13, (Inb_ATR_CTL(0x13) & 0xf0) | ((no) & 0x0f)) )

#define SCREEN_OFF	( Outbit_SEQ(0x1, 5, 1) ) /* for maximimum DRAM bandwidth to CPU (DAC does not read) */
#define SCREEN_ON	( Outbit_SEQ(0x1, 5, 0) )
#define WAIT_VERT_BLK	( while(inb(0x3c2) & 0x80) )
#define SYNCRESET_SEQ	( Outbit_SEQ(0, 1, 0) ) /* to avoid memory corruption when changing clocks */
#define ENDRESET_SEQ	( Outbit_SEQ(0, 1, 1) )

/*****************************************************************************************************************************/

 void unlock_CRTC(void);

 void set_VERT_TOTAL (int vt);

 void set_MAX_SCANLINE (int msl);

 void set_VRETRACE (int start, int end);

 void set_VDISPL_END (int vde);

 void set_VBLANK (int start, int end);

 void set_CURSOR (int start, int end);

 void set_HOR_TOTAL (int htot);

 void set_HOR_DISPL_END (int hend);

 void set_HSYNC (int start, int end);

 void set_HBLANK (int start, int end);

 void set_SYNC_POLARITY(int hpol, int vpol);

 void set_LOG_SCREEN_WIDTH(int width);

 void set_textmode(void);

 void set_graphmode(void);

 int set_charwidth(int width);

 void Outb_ATTR (int index, int data);

 int inb_ATTR (int index);

#endif