/* 
   Monitor-driver generic functions

   Copyright (C) 1995 Andreas Beck - becka@hp.rz.uni-duesseldorf.de

   If you do any modifications, I would like you to send diffs to me
   to allow for collecting a more and more complete set of drivers and
   to improve existing ones.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <linux/config.h>
#include <linux/module.h>
#include <linux/version.h>
#include <linux/kernel.h>
#include <linux/errno.h>
#include <linux/sched.h>
#include <linux/mm.h>
#include <linux/fs.h>
#include <linux/malloc.h>
#include <linux/fcntl.h>
#include <linux/vt.h>
#include <sys/ioctl.h>
#include <asm/io.h>
#include <asm/pgtable.h>
#include "../include/graphdev.h"
#include "../include/kgi-module.h"
#include "monitor_generic.h"

/* List of possible timings */
struct ggi_Timing TMlist[MAXPREFMODES];
int TMnum=0;

extern struct ggi_MonParams MonPar;

int mon_getinfo(void)
{ int i;
  if ((i=verify_area(VERIFY_WRITE, *(void **) parameters, sizeof(struct ggi_MonParams))))
    return(i);
  memcpy_tofs  (*(void **) parameters,&MonPar , sizeof(struct ggi_MonParams));
  return(0);
}

int mon_setinfo(void)
{ int i;
  if ((i=verify_area(VERIFY_READ, *(void **) parameters, sizeof(struct ggi_MonParams))))
    return(i);
  memcpy_fromfs  (&MonPar,*(void **) parameters, sizeof(struct ggi_MonParams));
  return(0);
}

int mon_setprefmode(void)
{ int i;
  if (TMnum >= MAXPREFMODES) return(-ENOSPC);	/* Table is full */
  if ((i=verify_area(VERIFY_READ, *(void **) parameters, sizeof(struct ggi_Timing))))
    return(i);
  memcpy_fromfs  (&TMlist[TMnum++],*(void **) parameters, sizeof(struct ggi_Timing));
  dump_tm(&TMlist[TMnum-1],"setpref",TMnum);
  return(0);
}

int mon_getprefmode(void)
{ int i,num;
  num=*(int *)parameters;
  if (num<0 || num>=TMnum) return(-EIO);	/* No such entry */
  if ((i=verify_area(VERIFY_WRITE, *((void **)parameters+1), sizeof(struct ggi_Timing_req))))
    return(i);
  memcpy_tofs  (*((void **)parameters+1),&TMlist[num].tr, sizeof(struct ggi_Timing_req));
  return(0);
}

int mon_vesa_pwr(void)
{ int i;
  if (!MonPar.VESA_pwr) return(-EIO);
  i=*(int *)parameters;
  return(vesa_pwrsave(i));
}