/*\
|*| ---------------------------------------------------------------------------
|*|	monitor driver for Sony CPD-1730 (and other modern multisync's ???)
|*| ---------------------------------------------------------------------------
|*|	NOTE:	THIS IS AN UNTESTED ALPHA VERSION, USE AT YOUR OWN RISK  !!!
|*| ---------------------------------------------------------------------------
|*|
|*|	Copyright (C) 1995 Steffen Seeger, [seeger@physik.tu-chemnitz.de]
|*|
|*|	This program is free software; you can redistribute it and/or modify
|*|	it under the terms of the GNU General Public License as published by
|*|	the Free Software Foundation; either version 2, or (at your option)
|*|	any later version.
|*|
|*|	This program is distributed in the hope that it will be useful,
|*|	but WITHOUT ANY WARRANTY; without even the implied warranty of
|*|	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|*|	GNU General Public License for more details.
|*|
|*|	You should have received a copy of the GNU General Public License
|*|	along with this program; see the file COPYING.  If not, write to
|*|	the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
|*|
|*| ---------------------------------------------------------------------------
\*/

#include <linux/module.h>
#include <linux/version.h>
#include <linux/kernel.h>

#undef DEBUG

#include "graphdev.h"
#include "kgi-module.h"

#define MON_VERSION "0.10"

char kernel_version[]= UTS_RELEASE;

#ifdef DEBUG	/* trick GCC */
static char *DISPTYPES[4]={ "B&W","EGA-8","EGA-16","VGA" };
#endif

static struct GGI_MonParams
CPD_1730 = {
		{24000000,130000000},	/* pixel clock range */
		{28000,58000},		/* hfreq range */
		{   55,  110},		/* vfreq range */
		1024,768,		/* display resolution */
		382,242,		/* display size */
		"Sony",			/* manufacturer */
		"CPD-1730",		/* model */
		VGA,			/* display type (color) */
		SYNC_NORMAL|POWER_SAVE	/* sync type */
	   };
#define MonPar CPD_1730	

/*\
|*|	GGI interface
\*/

void
kgi_MonitorGetParameters(struct GGI_MonParams * MP)
{
  *MP=MonPar;
}

int
kgi_MonitorCheckTiming  (struct GGI_Timing *TM)
{ 
  int hfreq,vfreq;
  int width = TM->xwidth;

  if (TM->clock < MonPar.pfreq.min)
    return FALSE;

  if (TM->clock > MonPar.pfreq.max) /* if so, we are called first time */
    {
      TM->clock = MonPar.pfreq.max;

      /* propose a timing for the given resolution */
      for(hfreq = MonPar.hfreq.max; hfreq > MonPar.hfreq.min; TM->clock -= 1000)
        /* Try from highest frequency down */
        {
           /* These timing calculations are designed to meet the VESA-specs at
   	      800 and 1024 pixels horizontal resolution. Anyhow, pixelclock may  
	      not be near the specs. 
            */
           TM->xsyncstart = (width*(width     +41360)/40000);
           TM->xsyncend   = (width*(width*7/10+ 8952)/ 8000);
           TM->xend       = (width*(width     + 9360)/ 8000);

           hfreq = TM->clock / TM->xend;
           if(MonPar.hfreq.max < hfreq)
             continue;

           TM->ysyncstart = TM->ywidth + 3;
           TM->ysyncend   = TM->ywidth + 9;
           TM->yend       = TM->ywidth + hfreq/1000 + 1; /* 1ms for flyback */

           TM->xsyncpol   = TM->ysyncpol	= 1; 

           vfreq = TM->clock / (TM->xend * TM->yend);
           if ((MonPar.vfreq.min <= vfreq) && (vfreq <= MonPar.vfreq.max))
            {
	      TRACE(printk("%s: calculated %i Hz refresh (%i Hz, DCLK = %i kHz)\n",\
			  __FILE__, vfreq, hfreq, TM->clock/1000));
	      return TRUE;
            }
        }
      TRACE(printk("%s: invalid mode request.\n",__FILE__));
      return FALSE; /* invalid timing request */
    }
   else	/* TM->clock > MonPar.pfreq.max */
    {
      int result;
      hfreq = TM->clock / TM->xend;
      vfreq = TM->clock / (TM->xend * TM->yend);
	
      result =  (MonPar.hfreq.min < hfreq) && (hfreq <= MonPar.hfreq.max) 
	     && (MonPar.vfreq.min < vfreq) && (vfreq <= MonPar.vfreq.max)
         && (MonPar.pfreq.min < TM->clock) && (TM->clock <= MonPar.pfreq.max);

      #ifdef DEBUG
       if(result)
         TRACE(printk("%s: accepted %i Hz refresh (%i Hz, DCLK = %i kHz)\n",\
               __FILE__, vfreq, hfreq, TM->clock/1000));
        else
         TRACE(printk("%s: refresh check failed. (%i Hz, %i Hz, %i kHz)\n",\
                     __FILE__, vfreq, hfreq, TM->clock/1000));
      #endif

      return result;
    }
}

int
kgi_MonitorSetTiming(struct GGI_Timing *TM)
{ /* a real check may go here (later ;-) */
   return TRUE;
}

int
kgi_MonitorIoctl (struct inode *inode, struct file *file, unsigned int cmd,
		  unsigned long arg)
{
  return -1;
}

/*\
|*|	module initialisation
\*/

int
init_module(void)
{
   printk("%s %s Monitor Driver v"MON_VERSION"\n",MonPar.manufact,MonPar.model);
   printk("(c) Steffen Seeger [seeger@physik.tu-chemnitz.de]\n");
   TRACE(printk("(%s - %s, %d x %d Pixels, %d mm x %d mm, %d-%d kHz, %d-%d Hz)\n",\
	  DISPTYPES[MonPar.disptype/8],\
	  (MonPar.disptype&1) ? "Monochrome" : "Color",\
	  MonPar.xmaxdots,\
	  MonPar.ymaxdots,\
	  MonPar.xsize,\
	  MonPar.ysize,\
	  MonPar.hfreq.min/1000 ,MonPar.hfreq.max/1000,\
	  MonPar.vfreq.min      ,MonPar.vfreq.max ));
   return(0);
}

void
cleanup_module(void)
{
   TRACE(printk("%s %s Monitor driver removed.\n",MonPar.manufact,MonPar.model));
}
