/* 
   Monitor configuration file for SAMPO - AlphaScan 15g

   Copyright (C) 1995 Andreas Beck - becka@hp.rz.uni-duesseldorf.de

   If you do any modifications, I would like you to send diffs to me
   to allow for collecting a more and more complete set of drivers and
   to improve existing ones.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

struct ggi_MonParams MonPar ={ 
			{    0,100000000},	/* bandwitdth */
			{30000,    60000},	/* horizontal frequency range */
			{   50,       90},	/* vertical   frequency range */
			1280,960,		/* max Resolution (Pixels)    */
			285,213,		/* physical picture size (mm) */
			"SAMPO",		/* Manufacturer */
			"AlphaScan 15g",	/* Monitor Name */
			VGA,			/* Monitor Type */
			1 };			/* VESA power-management */

/*
 * These timings are all from "picture-end" - i.e. the timings below will 
 * give 0.7 us from picture end to sync, 2.3 us sync and 1.2 us after sync
 * plus the time needed for 8 pixels per above mentioned area.
 *
 * I found them by trial and error and looking at the timings of working
 * modes - let's hope other monitors will work in a similar pattern.
 */ 

static struct timing_consts 
{ int xbefore_ns ,xlen_ns ,xafter_ns;  /* in ns */ 
  int xbefore_pix,xlen_pix,xafter_pix; /* in pixels */
  int ybefore_us ,ylen_us ,yafter_us;  /* in us */ 
  int ybefore_pix,ylen_pix,yafter_pix; /* in pixels */ } 
MonTimeConst={ 600,3000,4300,
	         8,  16,  24,
	         0,   0, 800,
	         0,   0,   0 };

