/*
   Generic Monitor driver for using fixed Timings calculated for XFree
   A user mode program is required for downloading these values.

   Copyright (C) 1995 Andreas Beck - becka@hp.rz.uni-duesseldorf.de

   If you do any modifications, I would like you to send diffs to me
   to allow for collecting a more and more complete set of drivers and
   to improve existing ones.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <linux/config.h>
#include <linux/module.h>
#include <linux/version.h>
#include <linux/kernel.h>
#include <linux/errno.h>
#include <linux/sched.h>
#include <linux/mm.h>
#include <linux/fs.h>
#include <linux/malloc.h>
#include <linux/fcntl.h>
#include <linux/vt.h>
#include <sys/ioctl.h>
#include <asm/io.h>
#include <asm/pgtable.h>
#include "graphdev.h"
#include "kgi-module.h"
#include "monitor_generic.h"

/* This is empty now - will be loaded with values by setup-ioctl */

struct ggi_MonParams MonPar ={ 
			{-1,-1},		/* bandwitdth */
			{-1,-1},		/* horizontal frequency range */
			{-1,-1},		/* vertical   frequency range */
			0,0,			/* max Resolution (Pixels)    */
			0,0,			/* physical picture size (mm) */
			"Xfree",		/* Manufacturer */
			"Timing-List",		/* Monitor Name */
			VGA,			/* Monitor Type */
			0 };			/* No power saving */

int  kgi_CheckMonitorTiming  (struct ggi_Timing * MT,int olderr)
{ int x,help;
  int bestdiff=999999;
  int bestTM=-1;
  
  for(x=0;x<TMnum;x++)
  { if ( MT->clock < TMlist[x].clock ||		/* Clock too high */
         MT->xwidth > TMlist[x].xwidth ||	/* Mode too small */
         MT->ywidth > TMlist[x].ywidth )
         	continue;			/* Don't use it   */
    
    help=TMlist[x].clock/TMlist[x].xend;	/* Hfreq OK ? */
    if (help<MonPar.hfreq.min||help>MonPar.hfreq.max)
       {printk("Invalid mode #%d: hfreq=%d limits: %d-%d.\n",
                x,help,MonPar.hfreq.min,MonPar.hfreq.max);continue;}
    
    help/=TMlist[x].yend;			/* Vfreq OK ? */
    if (help<MonPar.vfreq.min||help>MonPar.vfreq.max)
       {printk("Invalid mode #%d: vfreq=%d limits: %d-%d.\n",
                x,help,MonPar.hfreq.min,MonPar.hfreq.max);continue;}
    
    if (TMlist[x].xwidth-MT->xwidth < bestdiff)
      { bestdiff=TMlist[x].xwidth-MT->xwidth;
        bestTM=x;
      }
  }

  if (bestTM!=-1) 
  {
#define CP(a) MT->a=TMlist[bestTM].a 
    CP(clock);
    CP(xsyncstart);
    CP(xsyncend);
    CP(xend);
    CP(ysyncstart);
    CP(ysyncend);
    CP(yend);
    CP(xsyncpol);
    CP(ysyncpol);
#undef CP
    switch(x=kgi_CheckClockTiming(MT,CMD_CLK_HIGHER))
    { case MR_HIGHEST_CLOCK:/* No corresponding clock found !*/
      case MR_HIGHER_CLOCK :printk("Invalid mode #%d: Clock %d not found\n",bestTM,MT->clock);
      				return(-ENOMODESUP_MON);
      default: return x;
    }
  }                        
  return(-ENOMODESUP_MON);
}


int kgi_MonitorIoctl(struct inode *inode, struct file *file, \
        unsigned int cmd, unsigned long arg)
{ switch(cmd)
  { case MONITOR_GETINFO    :COPYPAR(sizeof(void *));
                             return(mon_getinfo());
                                  
    case MONITOR_SETINFO    :if (!suser()) return(-EPERM);
    			     COPYPAR(sizeof(void *));return(mon_setinfo());
    case MONITOR_SETPREFMODE:if (!suser()) return(-EPERM);
			     COPYPAR(sizeof(void *));
			     return(mon_setprefmode());  
    case MONITOR_GETPREFMODE:COPYPAR(sizeof(int)+sizeof(void *));
			     return(mon_getprefmode());  
    case MONITOR_CLEARPREF  :if (!suser()) return(-EPERM);
    			     TMnum=0;return(0);
    default : return -ENODRVSUP_ALWAYS_CANT; }
}
          
/* Argument parsing and initialization */

int kgi_MonitorInit(void)
{ printk("XFree-Timing-List Monitor driver V"VERSION" loading ...\n");
  return(0); }


void kgi_MonitorCleanup(void) {}