#include <linux/config.h>
#include <linux/module.h>
#include <linux/version.h>
#include <linux/kernel.h>
#include <linux/errno.h>
#include <linux/sched.h>
#include <linux/mm.h>
#include <linux/fs.h>
#include <linux/malloc.h>
#include <linux/fcntl.h>
#include <linux/vt.h>
#include <sys/ioctl.h>
#include <asm/io.h>
#include <asm/pgtable.h>
#include "graphdev.h"
#include "kgi-module.h"
#include "bt485.h"

/***********************************************
**** For chipsets with BrookTree 485 ramdac ****
***********************************************/

void OutBtReg(int reg, unsigned char data)
{
   ramdac_select_RS23(reg);
   outb(data,0x3c6+(reg & 3));

   ramdac_select_RS23(0);
}

unsigned char InBtReg(unsigned short reg)
{
   unsigned char ret;
   
   ramdac_select_RS23(reg);
   ret = inb(0x3c6+(reg & 3));

   ramdac_select_RS23(0);
   return(ret);
}

/**************************/
/*** Palette operations ***/
/**************************/
int hw_setpal(int start,int anz,struct ggi_Palentry *buf)
{ if (CurrState->bgmode) return(0);
  outb(start,0x3c8);
  while(anz--)
  { outb(buf->r,0x3c9);
    outb(buf->g,0x3c9);
    outb(buf->b,0x3c9);
    buf++; }
 return(0);
}

int setpal(void)
{ int i;
  struct MyP {	int start,anz;
		struct ggi_Palentry *pal; } *mypars;

  mypars=(struct MyP *)parameters;

  if ((i=verify_area(VERIFY_READ, mypars->pal, 
                     sizeof(struct ggi_Palentry)*mypars->anz))) 
         return(i);

  if (mypars->anz  <  0||
      mypars->start<  0||
      mypars->start>255||
      mypars->anz+mypars->start>256) return(-EINVAL);

  memcpy_fromfs(&CurrState->palette[mypars->start],mypars->pal,
  		sizeof(struct ggi_Palentry)*mypars->anz);

  hw_setpal(mypars->start,mypars->anz,&CurrState->palette[mypars->start]);
  return(0);
}

void hw_getpal(int start,int anz,struct ggi_Palentry *buffer)
{ outb(start,0x3c7);
  while(anz--)
  { buffer->r=inb(0x3c9);
    buffer->g=inb(0x3c9);
    buffer->b=inb(0x3c9);
    buffer++; }
}

int getpal(void)
{ int i;
  struct MyP {	int start,anz;
		struct ggi_Palentry *pal; } *mypars;

  mypars=(struct MyP *)parameters;

  if ((i=verify_area(VERIFY_WRITE, mypars->pal, 
                     sizeof(struct ggi_Palentry)*mypars->anz))) 
         return(i);

  if (mypars->anz  <  0||
      mypars->start<  0||
      mypars->start>255||
      mypars->anz+mypars->start>256) return(-EINVAL);

 memcpy_tofs(mypars->pal,&CurrState->palette[mypars->start], sizeof(struct ggi_Palentry)*mypars->anz);
 return(0);
}

int kgi_CheckRamdacTiming(struct ggi_Timing * MT,int cmd)
{ return MR_OK; }

int kgi_RamdacIoctl(struct inode *inode, struct file *file, \
        unsigned int cmd, unsigned long arg)
{ switch(cmd)
  { case RAMDAC_SETPAL :COPYPAR(2*sizeof(int)+sizeof(void *));
			return(setpal());
    case RAMDAC_GETPAL :COPYPAR(2*sizeof(int)+sizeof(void *));
                        return(getpal());
    default : return -ENODRVSUP_ALWAYS_CANT; }
}

int kgi_RamdacInit(void)
{ printk("Generic VGA Ramdac driver V"VERSION" loading ...\n");

  /* Set 6/8 bit mode and sync-on-green if required */
  OutBtReg(BT_COMMAND_REG_0, 0x02 /* 8 Bit */
			/* | 0x08 SyncOnGreen */);
  hw_getpal(0,256,OpenState.palette);			

  return(0);
}

void kgi_RamdacCleanup(void) 
{ /* Back to 6 bit mode */
  hw_setpal(0,256,OpenState.palette);
  OutBtReg(BT_COMMAND_REG_0, 0x00);
}

int kgi_SetRamdacTiming(struct ggi_Timing * MT)
{
#if 0
      /* Use Bt485 clock doubler - Bit 3 of Command Reg 3 */
      OutBtRegCom3(0xF7, (mode->Flags & V_DBLCLK ? 0x08 : 0x00));
	/* Use Cursor */
      OutBtReg(BT_COMMAND_REG_2,InBtReg(BT_COMMAND_REG_2)|0x03);
      OutBtReg(BT_CURS_X_LOW,128);
      OutBtReg(BT_CURS_Y_LOW,128);
#endif

	return(0);
}

