#include <linux/config.h>
#include <linux/module.h>
#include <linux/version.h>
#include <linux/kernel.h>
#include <linux/errno.h>
#include <linux/sched.h>
#include <linux/mm.h>
#include <linux/fs.h>
#include <linux/malloc.h>
#include <linux/fcntl.h>
#include <linux/vt.h>
#include <sys/ioctl.h>
#include <asm/io.h>
#include <asm/pgtable.h>
#include "graphdev.h"
#include "kgi-module.h"

/**********************************************
**** For chipsets with standard vga ramdac ****
**********************************************/

/**************************/
/*** Palette operations ***/
/**************************/
int hw_setpal(int start,int anz,struct ggi_Palentry *buf)
{ if (CurrState->bgmode) return(0);
  outb(start,0x3c8);
  while(anz--)
  { outb(buf->r>>2,0x3c9);
    outb(buf->g>>2,0x3c9);
    outb(buf->b>>2,0x3c9);
    buf++; }
 return(0);
}

int setpal(void)
{ int i;
  struct MyP {	int start,anz;
		struct ggi_Palentry *pal; } *mypars;

  mypars=(struct MyP *)parameters;

  if ((i=verify_area(VERIFY_READ, mypars->pal, 
                     sizeof(struct ggi_Palentry)*mypars->anz))) 
         return(i);

  if (mypars->anz  <  0||
      mypars->start<  0||
      mypars->start>255||
      mypars->anz+mypars->start>256) return(-EINVAL);

  memcpy_fromfs(&CurrState->palette[mypars->start],mypars->pal,
  		sizeof(struct ggi_Palentry)*mypars->anz);

  hw_setpal(mypars->start,mypars->anz,&CurrState->palette[mypars->start]);
  return(0);
}

void hw_getpal(int start,int anz,struct ggi_Palentry *buffer)
{ outb(start,0x3c7);
  while(anz--)
  { buffer->r=inb(0x3c9)<<2;
    buffer->g=inb(0x3c9)<<2;
    buffer->b=inb(0x3c9)<<2;
    buffer++; }
}

int getpal(void)
{ int i;
  struct MyP {	int start,anz;
		struct ggi_Palentry *pal; } *mypars;

  mypars=(struct MyP *)parameters;

  if ((i=verify_area(VERIFY_WRITE, mypars->pal, 
                     sizeof(struct ggi_Palentry)*mypars->anz))) 
         return(i);

  if (mypars->anz  <  0||
      mypars->start<  0||
      mypars->start>255||
      mypars->anz+mypars->start>256) return(-EINVAL);

 memcpy_tofs(mypars->pal,&CurrState->palette[mypars->start], sizeof(struct ggi_Palentry)*mypars->anz);
 return(0);
}

int kgi_CheckRamdacTiming(struct ggi_Timing * MT,int cmd)
{ return MR_OK; }

int kgi_SetRamdacTiming(struct ggi_Timing * MT)
{ return 0; }

int kgi_RamdacIoctl(struct inode *inode, struct file *file, \
        unsigned int cmd, unsigned long arg)
{ switch(cmd)
  { case RAMDAC_SETPAL :COPYPAR(2*sizeof(int)+sizeof(void *));
			return(setpal());
    case RAMDAC_GETPAL :COPYPAR(2*sizeof(int)+sizeof(void *));
                        return(getpal());
    default : return -ENODRVSUP_ALWAYS_CANT; }
}

int kgi_RamdacInit(void)
{ hw_getpal(0,256,OpenState.palette);
  printk("Generic VGA Ramdac driver V"VERSION" loading ...\n");
  return(0); /* We assume there is always a generic RAMDAC there ...
  		maybe we should check for the palette being all empty -
  		this might indicate a non VGA system */
}

void kgi_RamdacCleanup(void) {}
