#include "graphdev.h"

/****************************************************************************/
/* Some useful Macros first - these might even be used for user-level-ex-   */
/* tensions for the GGI-lib that make use of special features in certain    */
/* drivers (before they become integrated into the lib ...)                 */
/****************************************************************************/

/* Check driver capabilities for a given funtion and remember them : */

#define switcha(request) switch(ioctl_avail[request&0x03ff]&AVM_MASK)

/* ATTENTION : this macro will __RETURN__ (!) if the ioctl succeeds or
   we already have an emulation function! */

#define switchavail(request,param) \
  { int rc;								\
    int rq=request&0x03ff;						\
    if ((ioctl_avail[rq]&AVM_MASK)==AVM_IOCTL)				\
      if (((rc=-ggi_ioctl(request,param))&0xffffff00)==ENODRVSUP)	\
      { ioctl_avail[rq]=rc&0xff; }					\
      else return(rc);							\
  if (emu_func[rq]) return(emu_func[rq](param));			\
  }

/* Set a new emulation function and execute it */

#define setdoemu(request,func,param)	\
  emu_func[request&0x03ff]=func;return(func(param));

/********************************************************************************/
/* These are exported for "special" uses only and SHOULD NOT be used !          */
/********************************************************************************/

enum availlist { 	/* Methods */
			AVM_IOCTL =0x00,	/* ioctl is ok - use it */
			AVM_MMAP  =0x01,	/* use mmap */
			AVM_LOWER =0x02,	/* use lower level functions */
			AVM_CANT  =0x03,	/* no support (like setpal in 16M) */
			AVM_MASK  =0x0f,
			/* Expire-times */
			AVE_TEST  =0x00,	/* Test it ... */
			AVE_NOW   =0x00,	/* Retry next time */
			AVE_MODE  =0x01,	/* Always do it this way   */
			AVE_ALWAYS=0x02,	/* reset when mode changes */
			AVE_MASK  =0xf0 };

extern char *ggi_membuffer;
extern enum availlist ioctl_avail[0x400];
extern struct ggi_Timing_req CurrentMode,StartUpMode;

enum Events	{ EV_ALL=0,			/* Ignore */
		  EV_TIMER,			/* Timer  */
		  EV_VIDEO,			/* Accel_ready,retrace,... */
		  EV_VT,			/* VT switch */
		  EV_MOUSE,
		  EV_KEY,
		  NUM_EVENTS
		  };

struct Ev_None {};

struct Ev_Timer	{ int ticks; };

enum EvVideo	{ VIDEO_ACCEL_READY,
		  VIDEO_HSYNC,
		  VIDEO_VSYNC };
struct Ev_Video	{ enum	EvVideo	subtype; };

enum EvVt	{ VT_SWITCH_TO,
		  VT_SWITCH_AWAY };
struct Ev_Vt	{ enum	EvVt	subtype;
		  int console; };

enum EvMouse	{ MOUSE_MOVE = 0x01,
		  MOUSE_BT1_PRESS = 0x02,
		  MOUSE_BT2_PRESS = 0x04,
		  MOUSE_BT3_PRESS = 0x08,
		  MOUSE_BT1_RELEASE = 0x10,
		  MOUSE_BT2_RELEASE = 0x20,
		  MOUSE_BT3_RELEASE = 0x40 } ;
struct Ev_Mouse	{ enum	EvMouse	subtype;
		  int xpos,ypos;
		  int buttonstat; };

enum EvKey	{ KEY_PRESS,
		  KEY_RELEASE };
struct Ev_Key	{ enum	EvKey	subtype;
		  int keycode;
		  int ascii;
		  int modifier_state; };

union Evdata {	struct Ev_None  none;
		struct Ev_Timer timer;
		struct Ev_Video video;
		struct Ev_Vt    vt;
		struct Ev_Mouse mouse;
		struct Ev_Key	key;	};

struct ggi_event { enum Events	eventtype;
		   union Evdata evdata; };

extern int lock_count;
extern volatile int release_flag;
extern volatile int acquire_flag;

void releasevt_signal( int n ) ;
void acquirevt_signal( int n ) ;

/********************************************************************************/
/* Exported functions                                                           */
/********************************************************************************/

/* Library control */
void ggi_init(void);		/* Call this first */
void ggi_exit(void);		/* and this last - wil NOT reset old mode ! */
void ggi_panic(char *unused);	/* reset old mode,print panic and exit */

/* Mode control */
int ggi_setmode(struct ggi_Timing_req *tm);	/* Set any desired mode */
int ggi_startupmode(void);		/* resets to mode at ggi_init time */
int ggi_keepmode(void);			/* keep mode after exit (suser only) */
int ggi_textmode(int cols,int rows,int fontsizex,int fontsizey);	/* set given textmode */
int ggi_graphmode(int xsize,int ysize,int xvirtual,int yvirtual,int type);	/* set given graphics mode */
void *ggi_savestate(void);		/* save current state to user-space memory */
int ggi_restorestate(void *state);	/* restore such a state-buffer */

int ggi_setviswin(int x,int y);		/* Set the visible window (panning) */

/* Palette and color control */
int ggi_setpalvec(int start,int anz,struct ggi_Palentry *pp);
int ggi_getpalvec(int start,int anz,struct ggi_Palentry *pp);

/* Graphics primitives */
int ggi_setcolor(int x);

int ggi_drawpixel(int x,int y);
int ggi_getpixel(int x,int y,void *buffer);
int ggi_putpixel(int x,int y,void *buffer);

int ggi_drawhline(int x,int y,int width);
int ggi_gethline(int x,int y,int width,void *buffer);
int ggi_puthline(int x,int y,int width,void *buffer);

int ggi_drawvline(int x,int y,int width);
int ggi_getvline(int x,int y,int width,void *buffer);
int ggi_putvline(int x,int y,int width,void *buffer);

int ggi_drawbox(int x,int y,int width,int length);
int ggi_getbox(int x,int y,int width,int length,void *buffer);
int ggi_putbox(int x,int y,int width,int length,void *buffer);

int ggi_fillscreen(void);
int ggi_drawcircle(int xcenter,int ycenter,int rad);

int ggi_printf(int x,int y,const char *format,...);

int ggi_mon_power(enum PowerSave state);

/* Administrativa */
int ggi_vt_activate(int number);
int ggi_get_active_vt(void);
int ggi_run_in_bg(int yesno);
int ggi_register_evh(int evtype,void (*EvHand)(struct ggi_event));
int ggi_send_event(struct ggi_event ev);

/* Low level driver access */
int ggi_ioctl(int cmd,void *parm);

/* Keyboard */
int ggi_getch(void);