#include <stdio.h>
#include <sys/times.h>
#include <linux/fs.h>
#include <linux/timer.h>
#include <linux/genhd.h>
#include <linux/errno.h>
#include <linux/major.h>

#define GFP_KERNEL 0x03

#include "config.h"

#ifdef USE_VARARGS
#include <varargs.h>
#else
#include <stdarg.h>
#endif

#define NGROUPS 32
#define RLIM_NLIMITS 6

#ifndef FAKE_BUFFERS
void * pages[NR_PAGES];
char pageavl[NR_PAGES];
#endif

struct task_struct {
/* these are hardcoded - don't touch */
	long state;		/* -1 unrunnable, 0 runnable, >0 stopped */
	long counter;
	long priority;
	unsigned long signal;
	unsigned long blocked;	/* bitmap of masked signals */
	unsigned long flags;	/* per process flags, defined below */
	int errno;
	int debugreg[8];  /* Hardware debugging registers */
/* various fields */
};

static double
  time_so_far()
{
  clock_t        val;
  struct tms tms;


  if ((val = times(&tms)) == -1)
    perror("times");

  return ((double) val) / ((double) CLK_TCK);
}

#ifdef USE_VARARGS
void panic(va_alist)
  va_dcl
#else
void panic(char *format, ...)
#endif
{
  va_list vp;
#ifdef USE_VARARGS
  char *format;
#endif

  fprintf(stderr, "kbench: ");

#ifdef USE_VARARGS
  va_start(vp);
  format = va_arg (vp, char *);
#else
  va_start(vp, format);
#endif
  vfprintf(stderr, format, vp);
  va_end(va);

  fputc('\n', stderr);

  exit(1);
}

int check_cdrom_media_change(){ return 0; }
int floppy_change(struct buffer_head * bh){ return; }
void invalidate_inodes(dev_t dev){ return; }
void put_super(dev_t dev){ return; }
void sync_supers(dev_t dev){ return; }
void sync_inodes(dev_t dev){ return; }
int hd_init(int a, int b){ return a; }
int rd_init(int a, int b){ return a; }
int verify_area(int type, void * arg, int size) { return 0;}

unsigned long timer_active;
struct timer_struct timer_table[32];

volatile int jiffies = 0;
extern int nr_hash;
extern struct buffer_head ** hash_table;

int need_resched = 0;
int ramdisk_size = 0;
int nr_free_pages = 0;
int high_memory = NR_PAGES * 4096;
unsigned short int int_mem_map[NR_PAGES + 1024];
unsigned short int * mem_map = &int_mem_map[0];
static int current_minor = 0;
struct gendisk *gendisk_head = NULL;


struct task_struct task[2];
struct task_struct * current = &task[1];

struct super_block super_blocks[NR_SUPER];

int schedule(){
  fprintf(stderr,"Schedule");
  exit(1);
}

#ifdef FAKE_BUFFERS
int free_page(void * page){
  fprintf(stderr,"Free page %x\n", page);
  exit(1);
}

void * __get_free_page(int prior){
  fprintf(stderr,"Get free page %x\n", prior);
  exit(1);
}
#else
int free_page(void * page){
  int i;
  for(i=0; i<NR_PAGES; i++){
    if(page == pages[i]){
      if(pageavl[i]) fprintf(stderr,"Attempt to free free page %x\n", page);
      pageavl[i] = 1;
      nr_free_pages++;
      return;
    };
  };
  fprintf(stderr,"Attempt to free unknown page %x\n", page);
  exit(1);
}

void * __get_free_page(int prior){
  int i;
  while(1==1){
    for(i=0; i<NR_PAGES; i++){
      if(pageavl[i]){
	pageavl[i] = 0;
	nr_free_pages--;
	return pages[i];
      };
    };
    shrink_buffers(prior);
  };
}

#endif

int sleep_on(struct wait_queue ** foo){
  fprintf(stderr,"Sleeping...\n");
  sleep(1);
}

int interruptible_sleep_on(struct wait_queue ** foo){
  fprintf(stderr,"Sleeping...\n");
  sleep(1);
}

void * vmalloc(int size){
  return malloc(size);
}

void resetup_one_dev(struct gendisk *dev, int drive)
{
}

struct file_operations * blkdev_fops[MAX_BLKDEV] = {
	NULL,
};

int register_blkdev(unsigned int major, const char * name, struct file_operations *fops)
{
	if (major >= MAX_BLKDEV)
		return -EINVAL;
	if (blkdev_fops[major])
		return -EBUSY;
	blkdev_fops[major] = fops;
	return 0;
}

int wake_up(struct wait_queue ** foo){
  if((*foo) == NULL) return;
  fprintf(stderr,"Wake up!\n");
}

#ifdef FAKE_BUFFERS
char test_buffer[8192];
#endif

char test_buffer2[1024];
extern struct buffer_head * free_list;

struct blk_dev_struct {
	void (*request_fn)(void);
	struct request * current_request;
};


extern struct blk_dev_struct blk_dev[10];
#ifndef CURRENT
#define CURRENT (blk_dev[MAJOR_NR].current_request)
#endif

struct request {
	int dev;		/* -1 if no request */
	int cmd;		/* READ or WRITE */
	int errors;
	unsigned long sector;
	unsigned long nr_sectors;
	unsigned long current_nr_sectors;
	char * buffer;
	struct task_struct * waiting;
	struct buffer_head * bh;
	struct buffer_head * bhtail;
	struct request * next;
};


#if 1
void fake_disk_fn(void){
	struct request * req;
	struct buffer_head * bh;

	req = CURRENT;
	if(req->dev == -1) return;  /* This must be a plug */
      repeat:
	if ((bh = req->bh) != NULL) {
		req->bh = bh->b_reqnext;
		bh->b_reqnext = NULL;
		bh->b_uptodate = 1;
		bh->b_lock = 0;
		if ((bh = req->bh) != NULL) {
			req->current_nr_sectors = bh->b_size >> 9;
			if (req->nr_sectors < req->current_nr_sectors) {
				req->nr_sectors = req->current_nr_sectors;
				printk("end_request: buffer-list destroyed\n");
			}
			req->buffer = bh->b_data;
			goto repeat;
		}
	}
	CURRENT = req->next;
	req->dev = -1;
}
#endif


/* We keep this separate so that we know how much time we spend here */

int setup(){
  struct buffer_head * bh, *bhprev, *bhpage;
  char * start, *end;
  int i;
  char * start_buffer;

  nr_buffers = 0;
  for(i=0; i<NR_PAGES + 1024; i++) mem_map[i] = 1;


#ifdef FAKE_BUFFERS
  free_list = (struct buffer_head *) malloc(sizeof(struct buffer_head));
  free_list->b_prev_free = free_list;
  free_list->b_next_free = free_list;

  if (high_memory >= 4*1024*1024) {
    nr_hash = 4093;
  } else {
    nr_hash = 997;
  };

  hash_table = (struct buffer_head **) malloc(nr_hash * 
						     sizeof(struct buffer_head *));
  for (i = 0 ; i < nr_hash ; i++)
    hash_table[i] = NULL;

  bhprev = NULL;

  start_buffer = (char *) ((((unsigned int) test_buffer) + 4095) & 0xfffff000);
  for(i=0; i<15000; i++){
    bh = (struct buffer_head *) malloc(sizeof(struct buffer_head));
    bh->b_size = 1024;
    bh->b_dev = 0x301;
    bh->b_data = start_buffer + ((i % 4) * 1024);
    bh->b_blocknr = i;
    bh->b_lock = 0;
    if(i < NR_SHARED * 4) bh->b_lock = 1;
    if((i % 4) == 0) {
      if (bhprev) bhprev->b_this_page = bhpage;
      bhpage = bh;
    } else {
      bhprev->b_this_page = bh;
    };
    bhprev = bh;
    nr_buffers++;
    insert_into_queues(bh);
    buffermem++;
  };
#else
  for(i=0; i<NR_PAGES; i++){
    pages[i] = (void *) malloc(4096);
    *((char*)(pages[i])) = 1; /* Force a page fault */
    *((char*)(pages[i])) = 0; /* Force a page fault */
    nr_free_pages++;
    pageavl[i] = 1;
  };

  buffer_init();

#ifdef NR_SHARED
  for(i=0; i<NR_SHARED; i++) mem_map[(((unsigned int)pages[i]) >> 12)] = 2;
#endif

#ifdef GROW_BUFFERS
  while(nr_free_pages > 20) grow_buffers(GFP_KERNEL, BLOCK_SIZE);
#endif
#endif

  blk_dev_init(0, 0);

#if MAJOR_NR == SCSI_DISK_MAJOR
  start = (char *) malloc(50000);
  end = start + 50000;
  start = scsi_dev_init(start, end);
  sd_geninit();
#endif
}


main(int argc, char * argv[]){
  double starttime, endtime, datarate;
  struct file filep;
  struct inode ind;
  int i, j;
  int mb;

  if(argc < 2) exit(0);
  sscanf(argv[1], "%d", &mb);

  setup();
  
  filep.f_pos = 0;
  filep.f_reada = 0;
  ind.i_rdev = (MAJOR_NR << 8);  /* Simulate an IDE disk */
  blk_dev[HD_MAJOR].request_fn = fake_disk_fn;

#ifdef DO_WRITE
  i = 0;
  starttime = time_so_far();
  do{
    block_write(&ind, &filep, test_buffer2, sizeof(test_buffer2));
  } while(filep.f_pos < mb*1000*1024);

  endtime = time_so_far() - starttime;
  datarate = filep.f_pos / endtime;
  fprintf(stderr,"Finished writing, %g seconds, datarate=%g\n", endtime, datarate);
#endif

  starttime = time_so_far();
  filep.f_pos = 0;
  filep.f_reada = 0;

  do{
    block_read(&ind, &filep, test_buffer2, sizeof(test_buffer2));
    if((filep.f_pos % 10000) == 0) fprintf(stderr,"%d ", filep.f_pos);
  } while(filep.f_pos < mb*1000*1024);
  endtime = time_so_far() - starttime;
  datarate = filep.f_pos / endtime;
  fprintf(stderr,"Finished reading, %g seconds, datarate = %g\n", endtime, datarate);

  return 0;
}


#ifndef __OPTIMIZE__
void wait_on_buffer(struct buffer_head * bh)
{
	if (bh->b_lock)
		__wait_on_buffer(bh);
}


void lock_buffer(struct buffer_head * bh)
{
	if (bh->b_lock)
		__wait_on_buffer(bh);
	bh->b_lock = 1;
}

void unlock_buffer(struct buffer_head * bh)
{
	bh->b_lock = 0;
	wake_up(&bh->b_wait);
}

#define cli()
#define sti()
#define save_flags(X) 1
#define restore_flags(X) 1

void add_wait_queue(struct wait_queue ** p, struct wait_queue * wait)
{
	unsigned long flags;

#ifdef DEBUG
	if (wait->next) {
		unsigned long pc;
		__asm__ __volatile__("call 1f\n"
			"1:\tpopl %0":"=r" (pc));
		printk("add_wait_queue (%08x): wait->next = %08x\n",pc,(unsigned long) wait->next);
	}
#endif
	save_flags(flags);
	cli();
	if (!*p) {
		wait->next = wait;
		*p = wait;
	} else {
		wait->next = (*p)->next;
		(*p)->next = wait;
	}
	restore_flags(flags);
}

void remove_wait_queue(struct wait_queue ** p, struct wait_queue * wait)
{
	unsigned long flags;
	struct wait_queue * tmp;
#ifdef DEBUG
	unsigned long ok = 0;
#endif

	save_flags(flags);
	cli();
	if ((*p == wait) &&
#ifdef DEBUG
	    (ok = 1) &&
#endif
	    ((*p = wait->next) == wait)) {
		*p = NULL;
	} else {
		tmp = wait;
		while (tmp->next != wait) {
			tmp = tmp->next;
#ifdef DEBUG
			if (tmp == *p)
				ok = 1;
#endif
		}
		tmp->next = wait->next;
	}
	wait->next = NULL;
	restore_flags(flags);
#ifdef DEBUG
	if (!ok) {
		printk("removed wait_queue not on list.\n");
		printk("list = %08x, queue = %08x\n",(unsigned long) p, (unsigned long) wait);
		__asm__("call 1f\n1:\tpopl %0":"=r" (ok));
		printk("eip = %08x\n",ok);
	}
#endif
}

unsigned long get_free_page(int priority)
{
	unsigned long page;

	page = __get_free_page(priority);
	if (page)
		__asm__ __volatile__("rep ; stosl"
			: /* no outputs */ \
			:"a" (0),"c" (1024),"D" (page)
			:"di","cx");
	return page;
}

#endif



