/*	-*-C-*- (Just help Emacs)
**	Name	:	cyril
**	Date	:	Sat Jan 15 12:17:36 1994
**	Subjetc	:	The main part of the driver
**	File	:	dpt.c
**	Modif	:	Thu Sep  8 22:06:42 1994
**	Version	:	$Id: dpt.c,v 1.3 1994/09/22 19:45:07 cyril Exp $
*/

/*
** $Log: dpt.c,v $
 * Revision 1.3  1994/09/22  19:45:07  cyril
 * Cleanup
 *
 * Revision 1.2  1994/08/18  22:57:39  cyril
 * New Version lot's of new think.
 *
 * Revision 1.1  1994/07/05  23:08:49  cyril
 * Every think in DMA mode
 * Cluster mode support
 * Cleanup and more
 *
*/ 

/*  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

/*
** Mon Jun  6 23:51:26 1994
** Version For the New Version of the scsi midle ware
** Fri Jun 17 22:07:06 1994
** Cleanup
** Mon Jun 20 20:15:59 1994 
** Debug include 
** Warning For All Message
**	Fri Jul  1 20:35:35 1994 
** Abort Correct For new version
** Reset Correct, and now it is working
** Request sens is past now
**	Wed Jul 13 19:40:14 1994 
** For Linux 1.1.28, and good new's i can malloc memory at init time
** so a new cp and sp alloc and free algo, that can use this malloc.
** Now all parameters are dynamic allocate and transfer to scsi middle-ware.
** Multi Board is code
** scsicam_bios_param Include remove dpt_bios ...
** printk KERN_.. message include
*/

/*
**	Thu Jun 23 18:23:04 1994 
**  modified by stefan
**  dkns@hasler.ascom.ch
**  changed dma-detection in dpt_detect
**  minor modification of the code to improve readability 
*/

#include <linux/kernel.h>
#include <linux/head.h>
#include <linux/types.h>
#include <linux/string.h>
#include <linux/ioport.h>
#include <linux/in.h>

#include <linux/sched.h>
#include <asm/dma.h>

#include <asm/system.h>
#include <asm/io.h>
#include "../block/blk.h"
#include "scsi.h"
#include "hosts.h" 
#include "sd.h"
#include "scsi_ioctl.h"

#include "dpt.h"

#define NUM_OCT sizeof(unsigned int)
#define NUM_BIT NUM_OCT*8

#define STRING_WARNING KERN_WARNING "DPT : "  
#define WARNING(x)  printk x 

/*
** If You Want Debug uncomment Next Line
** #define DEBUG  
*/

#ifdef DEBUG 
#define STRING_DEBUG KERN_DEBUG "DPT : "
#define DEBUG_PRINT(x) printk x
#else
#define DEBUG_PRINT(__args)
#endif

/* Global Struct */
static struct dpt_ccb_cp *dpt_cp;  /* I am not alone */
static struct dpt_ccb_sp *dpt_sp;
static ushort  dptmailbox;
static unsigned int *adr_bit;

struct Scsi_Host * first_host = NULL;

/*
** an EISA board can have up to 15 slots 0x1c88 to 0xfc88 
** slot 0 is the motherboard                              
** but I never saw a board with more than 12 slots        
** however I coded for up to six busmasterslots 
** if you have your dpt in an other slot add it here
** 0xnc88 where n is the number of the slot 1 to f 
*/

/* For Isa and Eisa */
/* first detect EISA HBA */

ushort dpt_iobase[] = { 0x1c88,0x2c88,0x3c88,0x4c88,0x5c88,0x6c88,0x1f0, 0x170, 0x330,0x230, 0x0  };

/* Isa Only */
/* ushort dpt_iobase[] = { 0x1f0, 0x170, 0x330,0x230, 0x0  } */

static ushort *dpt_base = dpt_iobase;
static volatile int internal_done_flag = 0;
static volatile int internal_done_errcode = 0;


/*
** Down This part The bitmap table free and use 
** a little lib i write and i put here i don't think
** i need so optimise but it was write so ..
*/


/*
**	Date		:	Mon Jun 20 09:44:58 1994
**	Function	:	bit_alloc
**	Input  Param	:	*pos ptr to the bit map; size of the  map
**	Output Param	:	return pos if Ok;  or size can't alloc
**	Description	:	Alloc a bit map
*/

static inline unsigned int bit_alloc (unsigned int *adr,\
				      register unsigned int size) {

register unsigned int bit_pos, bit,byte_pos,size_bit;
unsigned int *pos = adr;

/*
** Find a free sp, in a bit list 
** This is not nice i know
** but the asm code generate is Not to bad (14 opcode !!)
*/


/*
** I need 4 Registers To do the job
** A Memory Access is done only on change 32 bits
** Every 32 bits for my part 
*/

/* 
** Initiale Condition 
*/

--pos; 
size += NUM_BIT;
byte_pos=0;

 Begin_Search:
pos++;bit=*pos;bit_pos=0;
size -= NUM_BIT;
size_bit = (size <= NUM_BIT) ? size : NUM_BIT; 

 Loop_Search:
if (~bit & (1<<bit_pos)) 
  goto End_Search;
if (++bit_pos < size_bit)
  goto Loop_Search;

if ( size > NUM_BIT ) {
  byte_pos += NUM_BIT;
  goto Begin_Search;
}

return (bit_pos+byte_pos);

 End_Search:
bit |= (1<<bit_pos);
*pos=bit;

return(bit_pos+byte_pos);

}

/*
**	Date		:	Wed Jul 20 20:07:06 1994
**	Function	:	bit_free
**	Input  Param	:	adr and pos to free
**	Output Param	:	nothink
**	Description	:	Put 
*/


static inline unsigned int bit_free (register unsigned int *adr,\
				     register unsigned int pos) {
  register unsigned int num = NUM_BIT;
  *(adr+(pos/num)) &= ~(1 << (pos%num));
}

/*
** End Of the bitmap Gestion
*/

/*
** Like the name send DPT DMA Command But all Type of cmd 
*/

static inline unchar dpt_send_cmd(ushort iobase, unsigned int adr,unchar cmd) {
  register unsigned int timeout = TIMEOUT*2;

  /* Wait for the Busy */
 cli();

 while (( ((inb(iobase+RAS) & 0x1) == 0x1) ^ !--timeout ));

 /* A timeout occur */
 if ( !timeout ) 
   return(1);

  outb( (char) adr, iobase+REG_LOW);
  outb( (char) (adr>>8), iobase+REG_LM);
  outb( (char) (adr>>16), iobase+REG_MID);
  outb( (char) (adr>>24), iobase+REG_MSB);

 /* Every think perfect */

 outb(cmd,iobase+CMD);

 sti();
 return(0);
}

/*
** Read Info
*/

static inline unchar dpt_read_info(struct dpt_info *info, ushort iobase)  {
register unsigned int timeout=512*TIMEOUT;

while ( !(inb(iobase+RAS) & 0x2) ^ !--timeout);
cli();

if (!timeout) 
  return(-1);   /* Timeout ! */

/* 
** Hep Man look at this i receive something, it is wonderfull
** Hey Man your dead, No Man !!
*/

  if (info->sign != 0x41544145)
    return(-1); /* This is not a dpt (Snif !! Ouin !!) */
 
return(0);
}

/*
 ** This Fonction detect the dpt board
 */
     
int dpt_detect(Scsi_Host_Template *tpnt) {
  struct dpt_info ccb_info;
  register unsigned int i ;
  ushort hostnum = 0;
  struct Scsi_Host * shpnt = NULL;
  unchar dma_trans[] = { 0, 7, 6, 5 };

  dptmailbox = 0;
/*
** Try to find a board
*/
  
  DEBUG_PRINT((STRING_DEBUG"Detect\n"));

#ifdef DPT_MULTI
  while (*dpt_base) 
#else
  while (*dpt_base | hostnum != 1) 
#endif 

    switch (!dpt_send_cmd(*dpt_base,(unsigned int)&ccb_info,DPT_READ_CONFIG) && !dpt_read_info(&ccb_info,*dpt_base)  )  {

    case 1 : 
      { 
	DEBUG_PRINT((STRING_DEBUG "Try To Find IO %x\n",*dpt_base));

	/* DMA Support ? */
	if (!ccb_info.dmasup) {
	  WARNING((STRING_WARNING"The DPT doesn't Support DMA.\n"));
	  break;
	}
      
	/* Reset Not need Normally But */
#ifdef DPT_NEED_RESET
	send_dpt_cmd(*dpt_base,RESET); 
#endif

	/* Find the irq */
	if (request_irq(ccb_info.irq,dpt_intr,0,"DPT EATA")) {
	  WARNING((STRING_WARNING "Unable to allocate IRQ for dpt controller at irq = %d\n",ccb_info.irq));
	  break;
	}
      
	/*
	 ** If need DMA 
	 */
	
	if (ccb_info.drqvld ) 
	  if(request_dma(dma_trans[ccb_info.drqx],"DPT EATA")) {
	    WARNING((STRING_WARNING "Unable to allocate DMA for dpt controller at dma = %d\n",dma_trans[ccb_info.drqx]));
	      free_irq(ccb_info.irq);
	    break;
	  }	

	if (!ccb_info.drqvld & (*dpt_base & 0xf000) )
	    WARNING((STRING_WARNING "DRQ on ISA board Not Valid it is working it is luck\n"));
	    
	if (*dpt_base && 0xf000)
	  printk(KERN_INFO "DPT found at IO %X IRQ %d DMA EISA Busmaster\n", *dpt_base, ccb_info.irq) ;
      else 
	printk(KERN_INFO "DPT found at IO %x IRQ %d DMA %x\n", *dpt_base, ccb_info.irq, dma_trans[ccb_info.drqx]);
      
#ifdef DPT_NEED_CONFIG
	ccb_config.len = (ushort) ntohs((ushort)510);
	ccb_config.edis =  0;
	ccb_config.ocena = 1;
	ccb_config.mdpena = 1;
	ccb_config.tarena =0 ;
	ccb_config.nul = 0;
	ccb_config.zero = 0;
	
	if (dpt_send_cmd(*dpt_base,(unsigned int)&ccb_config,DPT_SET_CONFIG)) 
	  WARNING((STRING_WARNING "Trobble send config Good Luke.\n"));
#endif 
      
	shpnt = scsi_register(tpnt, 0);
	if ( !hostnum )
	  first_host = shpnt ;
	if (ccb_info.drqvld & (*dpt_base & 0xf000) )
	  shpnt->dma_channel = dma_trans[ccb_info.drqx] ; 
	hostnum++;
	snarf_region(*dpt_base,9);
	shpnt->io_port = *dpt_base;
	shpnt->irq = ccb_info.irq; 
	shpnt->sg_tablesize = (ushort )ntohs(ccb_info.scatt_size);
	shpnt->this_id =  (ushort )ntohl(ccb_info.host_adr);;
	*dpt_base++;

#ifdef DPT_MAX_MAILBOXE 
	dptmailbox += DPT_MAILBOXES ;     
	shpnt->hostt->can_queue = DPT_MAILBOXES; 
#else
	dptmailbox +=  (ushort )ntohs(ccb_info.queue_len);
	shpnt->hostt->can_queue = (ushort )ntohs(ccb_info.queue_len); 
#endif /* DPT_MAX_MAILBOXE */
      
      } /* The Case 1 statement */
     
    default:
      DEBUG_PRINT((STRING_DEBUG "Try To Find IO %x\n",*dpt_base));
      *dpt_base++;


    } /* while */

/*
** Alloc the CP and SP 
** At init Time No Error Return
*/

  dpt_cp = (struct dpt_ccb_cp *) \
    scsi_init_malloc(dptmailbox*sizeof(struct dpt_ccb_cp));
  dpt_sp = (struct dpt_ccb_sp *) \
    scsi_init_malloc(dptmailbox*sizeof(struct dpt_ccb_sp));

/* The Bitmap alloc and init*/

  adr_bit = (unsigned int *) \
    scsi_init_malloc(dptmailbox/sizeof(unsigned int)+1);

  memset(adr_bit, 0, (dptmailbox/sizeof(unsigned int)+1));  

#ifdef DPT_MAX_MAILBOXE 

  printk(KERN_INFO "DPT : Static %d Alloc SCSI %d Alloc Bitmap %d\n",\
  DPT_MAILBOXES, \
 (dptmailbox*sizeof(struct dpt_ccb_cp)+dptmailbox*sizeof(struct dpt_ccb_sp)),\
 dptmailbox/sizeof(unsigned int)+1);

#else

  printk(KERN_INFO "DPT : Size %d Alloc SCSI %d Alloc Bitmap %d\n",\
 (ushort )ntohs(ccb_info.queue_len),\
 (dptmailbox*sizeof(struct dpt_ccb_cp)+dptmailbox*sizeof(struct dpt_ccb_sp)),\
dptmailbox/sizeof(unsigned int)+1);

#endif /* DPT_MAX_MAILBOXE */


/*
** Make EOC Clear
*/

  for(i=0;i<dptmailbox;i++)
    dpt_sp[i].eoc = 0 ;

/* Return the number of board */
  return(hostnum);
}

/*
** Return a info string
*/

const char *dpt_info(void) {
  return("EATA Driver Version $Revision: 1.3 $");
}

/*
** Work With dpt_command
*/

static void internal_done(Scsi_Cmnd * cmnd) {
    internal_done_errcode = cmnd->result;
    ++internal_done_flag;
}

/*
** Work ?
*/

int dpt_command(Scsi_Cmnd *cmnd) {
    dpt_queuecommand(cmnd, internal_done);

    while (!internal_done_flag);
    internal_done_flag = 0;
    return internal_done_errcode;
}

/*
** The main Part of the driver ( What a job )
*/

int dpt_queuecommand(Scsi_Cmnd *cmnd, void (*done)(Scsi_Cmnd *)) {
  register unsigned int pos,j ;
  struct sg *sgptr;
  struct scatterlist *sgpnt;

  DEBUG_PRINT((STRING_DEBUG "QueueCommand\n"));

  cli();

/*
** Find a free sp, in a bit list 
*/

  pos = bit_alloc(adr_bit, dptmailbox) ;

  if (pos == dptmailbox) {
    sti();
/*
** This normally can't arrive but in case ..
*/
    WARNING((STRING_WARNING "Can't allocate cp\n"));
    cmnd->result = DID_TIME_OUT << 16 ; 
    cmnd->scsi_done(cmnd);    
    return 0;
  }
    
  sti();

  /* Init Memory */
  memset(&dpt_cp[pos], 0, sizeof(struct dpt_ccb_cp));

  dpt_cp[pos].sp_adr= ntohl((unsigned int) &dpt_sp[pos]);
  cmnd->scsi_done=done;

  /* Position for Write or Read */
  if (cmnd->cmnd[0] == WRITE_10 || cmnd->cmnd[0] == WRITE_6)
    dpt_cp[pos].dout=1;
  else
    dpt_cp[pos].din=1;

  dpt_cp[pos].reqsen=1;   dpt_cp[pos].devadr=cmnd->target;

  /* Mess */

  dpt_cp[pos].lun=cmnd->lun;  
  dpt_cp[pos].dispri=1;  dpt_cp[pos].one=1;
  dpt_cp[pos].vir_cp=(unsigned int) cmnd;

  /* Take the value in the scsi.h file for the sens buffer */

  dpt_cp[pos].rsl=16;
  dpt_cp[pos].res_sens_adr=ntohl((unsigned int) cmnd->sense_buffer); 

  if (cmnd->use_sg)
    {

      DEBUG_PRINT((STRING_DEBUG "Sg\n"));

      /* Use the scather/gather mode */
      dpt_cp[pos].sg=1;
/*
** Made the Scatter/Gather List
*/
      cmnd->host_scribble = (unsigned char *) scsi_malloc( ( (cmnd->use_sg*sizeof(struct sg)/512)+1)*512 );
      sgptr = (struct sg *) cmnd->host_scribble;
      sgpnt = (struct scatterlist *) cmnd->request_buffer;  
      
      if (!sgptr) panic("Dpt : Can't allocate Memory");

      for(j=0;j<cmnd->use_sg;j++) {
	sgptr[j].adress = ntohl((unsigned int) sgpnt[j].address);
	sgptr[j].len= ntohl((unsigned int) sgpnt[j].length);
      }

      dpt_cp[pos].data_adr= ntohl((unsigned int) sgptr);
      dpt_cp[pos].data_trans_len=ntohl( (cmnd->use_sg*sizeof(struct sg)) );
    }
  else {
    DEBUG_PRINT((STRING_DEBUG "NoSg\n"));
    cmnd->host_scribble = NULL ;
    dpt_cp[pos].data_adr= ntohl((unsigned int) cmnd->request_buffer);
    dpt_cp[pos].data_trans_len=ntohl(cmnd->request_bufflen);
  }

  /* Copy the Command */

  memcpy(dpt_cp[pos].cdb,cmnd->cmnd,COMMAND_SIZE(*cmnd->cmnd));

/*
** If a error occur when send try to timeout the command
*/
  DEBUG_PRINT((STRING_DEBUG "Send\n"));

  if (dpt_send_cmd(cmnd->host->io_port,(unsigned int)&dpt_cp[pos],DPT_SEND)) {
    WARNING((STRING_WARNING "Timeout Send dma (Board Busy)\n"));
    cmnd->result = DID_TIME_OUT << 16 ; 
    cmnd->scsi_done(cmnd);    
    bit_free(adr_bit,pos);
  }
  
  return(0);
}

/*
** Abort 
*/

int dpt_abort(Scsi_Cmnd *cmnd) {
 register unsigned int i;
  DEBUG_PRINT((STRING_DEBUG "Abort.\n"));

 /* The Command is return ? */
 
 for( i=0; i < dptmailbox ; i++) 
   if (dpt_sp[i].vir_cp == (ulong) cmnd) 
     return  SCSI_ABORT_NOT_RUNNING ;
   
  /* The Command is on the bus and ... */
 
 return SCSI_ABORT_BUSY;
}

/*
** The Reset routine
*/

int dpt_reset(Scsi_Cmnd *cmnd) {
  register unsigned int pos ;
  DEBUG_PRINT((STRING_DEBUG "Reset\n"));
  cli();

/*
** Find a free sp, in a bit list 
*/
  pos = bit_alloc(adr_bit, dptmailbox);
  if (pos == dptmailbox) {
    sti();
/*
** This normally can't arrive but in case ..
*/
    WARNING((STRING_WARNING "Can't allocate cp\n"));
    cmnd->result = DID_TIME_OUT << 16 ; 
    cmnd->scsi_done(cmnd);    
    return 0;
  }

  sti();

  memset(&dpt_cp[pos], 0, sizeof(struct dpt_ccb_cp));

  /* Some Parameters */

  cmnd->host_scribble = NULL ;
  dpt_cp[pos].sp_adr= ntohl((unsigned int) &dpt_sp[pos]);
  dpt_cp[pos].res_sens_adr=ntohl((unsigned int) cmnd->sense_buffer); 
  dpt_cp[pos].data_adr= ntohl((unsigned int) cmnd->request_buffer);
  dpt_cp[pos].din=1;
  dpt_cp[pos].reqsen=1;  dpt_cp[pos].init=1;   dpt_cp[pos].devadr=cmnd->target;
  dpt_cp[pos].lun=cmnd->lun;  dpt_cp[pos].one=1;
  dpt_cp[pos].rsl=16;
  dpt_cp[pos].data_trans_len=ntohl(cmnd->request_bufflen);
  dpt_cp[pos].vir_cp=(unsigned int) cmnd;

  if (dpt_send_cmd(cmnd->host->io_port,(unsigned int)&dpt_cp[pos],DPT_SEND)) {
    WARNING((STRING_WARNING "Reset Timeout.\n"));
    bit_free(adr_bit,pos);
    return SCSI_RESET_ERROR;
  }

  return  SCSI_RESET_PENDING ; 
}


/*
** Interrup handle
*/

void dpt_intr(int irq) {
  Scsi_Cmnd *scd=NULL;
  unchar ret_code;
  struct Scsi_Host *p_host; 
  int *adr_irq; 
  

/*
** Find the irq and port io i need to free
*/
  adr_irq = (int *) irq ;
  adr_irq -= 2 ;
  p_host = scsi_hostlist; 

  while ( (p_host->irq != *adr_irq) && (p_host->next))
    p_host = p_host->next;
  
  if ( p_host->irq != *adr_irq ) {
    WARNING((STRING_WARNING "This interrupt is Not for me!\n"));
    return;
  }

  /*
   ** Find the Sp Free it And
   ** Return to Done
   */

  DEBUG_PRINT((STRING_DEBUG "Int\n")); 

  /* Free intr */
  /* 
   ** Don't even think the return code are Good
   ** it is only a joke from DPT, and thank you 
   ** DPT i look for a log time for this bug 
   ** I just want to tell you. Na !!
   */  

  inb(p_host->io_port+STATUS);

  /*
   ** Looking for all the sp return 
   */

  for(ret_code=0; ret_code < dptmailbox; ret_code++)
    
    if ( dpt_sp[ret_code].eoc == 1 ) {
      bit_free (adr_bit, ret_code);

      dpt_sp[ret_code].eoc=0;
      scd=(Scsi_Cmnd *) dpt_sp[ret_code].vir_cp;

      if (scd)   {
	
    /* Free the memory, if needed */

	if (scd->host_scribble) 
	  scsi_free(scd->host_scribble, ( (scd->use_sg*sizeof(struct sg)/512)+1)*512 );
	
	/*
	 ** Look for the error message 
	 */

#ifdef DEBUG
	if ( ( dpt_sp[ret_code].cont_stat)  | (dpt_sp[ret_code].scsi_stat ) ) 
	  DEBUG_PRINT((STRING_DEBUG"R C %d, R S %d\n",dpt_sp[ret_code].cont_stat,dpt_sp[ret_code].scsi_stat)); 
#endif


	switch(dpt_sp[ret_code].cont_stat) {
	  
	case 0:			/* No Error */
	  scd->result = DID_OK << 16 | dpt_sp[ret_code].scsi_stat;
	  break ;
	  
	case 1:			/* Selection Time Out */
	case 2:			/* Command Time Out   */
	  scd->result = DID_TIME_OUT << 16 | dpt_sp[ret_code].scsi_stat;
	  break ;
      
	case 3:			/* SCSI Bus Reset Receive */
	  scd->result = DID_RESET << 16 | dpt_sp[ret_code].scsi_stat;
	  break ;
	case 4:			/* Initial Controller Power-up */
	case 5:			/* Unexpected Bus Phase */
	case 6:			/* Unexpected Bus Free */
	  scd->result = DID_ERROR << 16 | dpt_sp[ret_code].scsi_stat;
	  break ;
    
	case 7:			/* Bus Parity Error */
	  scd->result = DID_PARITY << 16 | dpt_sp[ret_code].scsi_stat;
	  break ;
	case 8:			/* SCSI Hung */
	case 9:			/* Unexpected Message Reject */
	case 0xa:		/* SCSI Bus Reset Stuck */
	case 0xb:		/* Auto Request-Sens Failed */
	  scd->result = DID_ERROR << 16 | dpt_sp[ret_code].scsi_stat;
	  break ;

	case 0xc:		/* Controller Ram Parity */
	  scd->result = DID_PARITY << 16 | dpt_sp[ret_code].scsi_stat;
	  break ;
	}
    
	/* And then say a little Hello to the scsi ;-) */

	if (scd->scsi_done) 
	  scd->scsi_done(scd);

	/* This For The Abort Cmd */
	dpt_sp[ret_code].vir_cp=0;

      } /* End If */
    } /* End if eoc */
 
 
} /* Intr Func */

