/*
 * Ricoh GSI-8 NCR5380 driver defines
 *
 * Copyright 1993, Drew Eckhardt
 *	Visionary Computing
 *	(Unix and Linux consulting and custom programming)
 *	drew@colorado.edu
 *      +1 (303) 666-5836
 *
 * ALPHA RELEASE 1. 
 *
 * For more information, please consult 
 *
 * NCR 5380 Family
 * SCSI Protocol Controller
 * Databook
 *
 * NCR Microelectronics
 * 1635 Aeroplaza Drive
 * Colorado Springs, CO 80916
 * 1+ (800) 525-2252
 */

/*
 * $Log: gsi8.h,v $
 * Revision 1.1  1993/10/16  22:43:42  drew
 * Initial revision
 *
 * Revision 1.1  1993/10/15  00:56:45  drew
 * Initial revision
 *
 * Revision 1.1  1993/10/15  00:56:45  drew
 * Initial revision
 *
 * Revision 1.1  1993/10/15  00:56:09  drew
 * Initial revision
 *
 */

#ifndef GSI8_H
#define GSI8_H

#define GSI8_PUBLIC_RELEASE 1


#ifndef ASM
int gsi8_abort(Scsi_Cmnd *, int);
int gsi8_detect(int);
const char *gsi8_info(void);
int gsi8_queue_command(Scsi_Cmnd *, void (*done)(Scsi_Cmnd *));
int gsi8_reset(void);

/*
  Jumper bit settings in the magic port 1 byte.  Reading this
  port appears to have the side-effect of enabling the NCR5380.
*/

#define GSI_MAGIC_PORT_1 0x146

#define GSI_JUMPER_W1   0x80
#define GSI_JUMPER_W2   0x40
#define GSI_JUMPER_W3   0x10
#define GSI_JUMPER_W4   0x04
#define GSI_JUMPER_W5   0x20
#define GSI_JUMPER_W6   0x08
#undef  GSI_JUMPER_W7
#define GSI_JUMPER_W8   0x02
#undef  GSI_JUMPER_W9

/*
  Jumper bit settings in the magic port 1 byte.  Reading this
  port appears to have the side-effect of disabling the NCR5380.
*/

#define GSI_MAGIC_PORT_2 0x147

#define GSI_JUMPER_W10  0x08
#define GSI_JUMPER_W11  0x04
#define GSI_JUMPER_W12  0x02
#define GSI_JUMPER_W13  0x01

/*
  The NCR5380 ports are at either 0x148 (W8 reset) or 0x248 (W8 set).
*/

#define GSI_LOW_PORT_BASE  0x148
#define GSI_HIGH_PORT_BASE 0x248

/*
  The ROM BIOS and on-board RAM appear at one of the following sets
  of addresses, depending on the settings of W6 and W4.
*/

#define GSI_BIOS_W6_OFF        0xC8000
#define GSI_BIOS_W6_ON_W4_OFF  0xD0000
#define GSI_BIOS_W6_ON_W4_ON   0xD8000

#define GSI_OFFSET_BIOS_TO_RAM 0x04000

#ifndef NULL
#define NULL 0
#endif

#ifndef CMD_PER_LUN
#define CMD_PER_LUN 2
#endif

#ifndef CAN_QUEUE
#define CAN_QUEUE 16
#endif

#ifdef HOSTS_C

#define GSI8 {"Ricoh GSI-8", 			\
	gsi8_detect, gsi8_info, NULL, 		\
	gsi8_queue_command, gsi8_abort, 		\
	gsi8_reset, NULL, 					\
	NULL, /* can queue */ CAN_QUEUE, /* id */ 7, /* SG_NONE */ SG_ALL,		\
	/* cmd per lun */ CMD_PER_LUN , 0, 0}

#else
#define NCR5380_implementation_fields 

#define NCR5380_local_declare() \
    register int port

#define NCR5380_setup(instance) \
    port = (instance)->io_port

#define NCR5380_read(reg) (__inb(port + (reg)))
#define NCR5380_write(reg, value) (__outb((value), port + (reg)))

/* #define NCR5380_intr gsi8_intr */
#define NCR5380_queue_command gsi8_queue_command
#define NCR5380_abort gsi8_abort
/* #define NCR5380_reset gsi8_reset */

#define NCR5380_dma_read_setup NCR5380_i386_dma_read_setup
#define NCR5380_dma_write_setup NCR5380_i386_dma_write_setup
#define NCR5380_dma_residual NCR5380_i386_dma_residual

#define NCR5380_dma_xfer_len gsi8_dma_xfer_len

#endif /* else def HOSTS_C */
#endif /* ndef ASM */
#endif /* GSI8_H */
