#
# BIOS header junk and signature string
#

D000:0000 55            PUSH    BP
D000:0001 AA            STOSB
D000:0002 10EB          ADC     BL,CH
D000:0004 50            PUSH    AX
D000:0005 90            NOP
D000:0006 52            PUSH    DX
D000:0007 49            DEC     CX
D000:0008 43            INC     BX
D000:0009 4F            DEC     DI
D000:000A 48            DEC     AX
D000:000B 20484F        AND     [BX+SI+4F],CL
D000:000E 53            PUSH    BX
D000:000F 54            PUSH    SP
D000:0010 204144        AND     [BX+DI+44],AL
D000:0013 41            INC     CX
D000:0014 50            PUSH    AX
D000:0015 54            PUSH    SP
D000:0016 45            INC     BP
D000:0017 52            PUSH    DX
D000:0018 20494E        AND     [BX+DI+4E],CL
D000:001B 53            PUSH    BX
D000:001C 54            PUSH    SP
D000:001D 41            INC     CX
D000:001E 4C            DEC     SP
D000:001F 4C            DEC     SP
D000:0020 45            INC     BP
D000:0021 44            INC     SP
D000:0022 0A0D          OR      CL,[DI]
D000:0024 4D            DEC     BP
D000:0025 4F            DEC     DI
D000:0026 44            INC     SP
D000:0027 45            INC     BP
D000:0028 4C            DEC     SP
D000:0029 204753        AND     [BX+53],AL
D000:002C 49            DEC     CX
D000:002D 2D382C        SUB     AX,2C38
D000:0030 205645        AND     [BP+45],DL
D000:0033 52            PUSH    DX
D000:0034 20362E30      AND     [302E],DH
D000:0038 0A0D          OR      CL,[DI]
D000:003A 3035          XOR     [DI],DH
D000:003C 2F            DAS
D000:003D 3138          XOR     [BX+SI],DI
D000:003F 2F            DAS
D000:0040 3838          CMP     [BX+SI],BH
D000:0042 0A0D          OR      CL,[DI]

	db 1A
#
# This is the jump table used to jump to a routine based on the phase 
# we are currently in.
#

	dw DA24
D000:0044 24
D000:0046 03DA          ADD     BX,DX
D000:0048 043C          ADD     AL,3C
D000:004A 035803        ADD     BX,[BX+SI+03]
D000:004D 6B            DB      6B
D000:004E 036B03        ADD     BP,[BP+DI+03]
D000:0051 4B            DEC     BX
D000:0052 035E03        ADD     BX,[BP+03]

# BIOS initialization

D000:0055 1E            PUSH    DS
D000:0056 52            PUSH    DX
D000:0057 53            PUSH    BX
D000:0058 57            PUSH    DI

# Query W6 and W4 to figure out BIOS and RAM address

D000:0059 BB00CC        MOV     BX,CC00
D000:005C BF0000        MOV     DI,0000
D000:005F FC            CLD

# Read jumpers
D000:0060 BA4601        MOV     DX,GSI_MAGIC_PORT_1
D000:0063 EC            IN      AL,DX
D000:0064 A808          TEST    AL,GSI_JUMPER_W6
D000:0066 740A          JZ      0072
D000:0068 BB00D4        MOV     BX,D400
D000:006B A804          TEST    AL,GSI_JUMPER_W4
D000:006D 7403          JZ      0072
D000:006F BB00DC        MOV     BX,DC00
D000:0072 8EDB          MOV     DS,BX

# Query W3 and set flag - WR low = DMA 1, high = DMA 3

D000:0074 C6452E00      MOV     BYTE PTR [DI+2E],00
D000:0078 A810          TEST    AL,GSI_JUMPER_W3
D000:007A 7404          JZ      0080
D000:007C C6452EFF      MOV     BYTE PTR [DI+2E],FF

# Query W8 to see whether the ports are at 0x148-0x14F or 0x248-0x24F

D000:0080 C7452B0001    MOV     WORD PTR [DI+2B],0100
D000:0085 A802          TEST    AL,GSI_JUMPER_W8
D000:0087 7405          JZ      008E
D000:0089 C7452B0002    MOV     WORD PTR [DI+2B],0200

# Query W10 and set a flag in SRAM.  I think this controls whether
# parity checking is enabled in the mode register.  Yes, it does.

D000:008E BA4701        MOV     DX,GSI_MAGIC_PORT_2
D000:0091 EC            IN      AL,DX
D000:0092 C6453300      MOV     BYTE PTR [DI+33],00
D000:0096 A808          TEST    AL,GSI_JUMPER_W10
D000:0098 7404          JZ      009E
D000:009A C6453320      MOV     CONFIG_PARITY, MR_ENABLE_PARITY_CHECK

# interesting magic with W11-W13.  Treats these as an integer N, creates
# a mask 1<<N, stores in RAM.  Later it's being used as the
# select-enable, and occasionally pushed out onto the bus.  Inference...
# these bits set the host-adapter unit number.

D000:009E 2407          AND     AL,07
D000:00A0 8AC8          MOV     CL,AL
D000:00A2 B401          MOV     AH,01
D000:00A4 D2E4          SHL     AH,CL
D000:00A6 886534        MOV     [DI+34],AH

# Store the address of our software-interrupt routine in the vector for
# INT 0x66

D000:00A9 1E            PUSH    DS
D000:00AA 2BC0          SUB     AX,AX
D000:00AC 8ED8          MOV     DS,AX
D000:00AE B8D300        MOV     AX,00D3
D000:00B1 A39801        MOV     [0198],AX
D000:00B4 8CC8          MOV     AX,CS
D000:00B6 A39A01        MOV     [019A],AX
D000:00B9 1F            POP     DS

# Print adapter BIOS salutation.

D000:00BA BF0600        MOV     DI,0006
D000:00BD 2E            CS:
D000:00BE 8A05          MOV     AL,[DI]
D000:00C0 47            INC     DI
D000:00C1 3C24          CMP     AL,24
D000:00C3 7409          JZ      00CE
D000:00C5 B40E          MOV     AH,0E
D000:00C7 BB0000        MOV     BX,0000
D000:00CA CD10          INT     10
D000:00CC EBEF          JMP     00BD

# amadahia

D000:00CE 5F            POP     DI
D000:00CF 5B            POP     BX
D000:00D0 5A            POP     DX
D000:00D1 1F            POP     DS
D000:00D2 CB            RETF

# INT 0x66 enters here.  DX apparently points to a command structure of
# some sort.

D000:00D3 1E            PUSH    DS
D000:00D4 57            PUSH    DI

# Locate SRAM

D000:00D5 33C0          XOR     AX,AX
D000:00D7 8ED8          MOV     DS,AX
D000:00D9 A19A01        MOV     AX,[019A]
D000:00DC 050004        ADD     AX,0400
D000:00DF 8ED8          MOV     DS,AX
D000:00E1 BF0000        MOV     DI,0000

# Save user-stack pointers in RAM.  Set up a new stack in our RAM.

D000:00E4 FA            CLI
D000:00E5 89653A        MOV     [DI+3A],SP
D000:00E8 8C5538        MOV     [DI+38],SS
D000:00EB 8ED0          MOV     SS,AX
D000:00ED BC0020        MOV     SP,2000

# Save caller regs.

D000:00F0 56            PUSH    SI
D000:00F1 53            PUSH    BX
D000:00F2 51            PUSH    CX
D000:00F3 52            PUSH    DX
D000:00F4 06            PUSH    ES
D000:00F5 52            PUSH    DX
D000:00F6 8BF2          MOV     SI,DX
D000:00F8 FB            STI

# Read magic port (don't know yet what doing this does)

D000:00F9 FC            CLD
D000:00FA BA4601        MOV     DX,0146
D000:00FD EC            IN      AL,DX

# Copy input structure from user's memory to our RAM... 40 bytes
# are transferred to the beginning of our RAM.  This is maybe the
# SCSI command??

D000:00FE B92800        MOV     CX,0028
D000:0101 26            ES:
D000:0102 8A04          MOV     AL,[SI]
D000:0104 8805          MOV     [DI],AL
D000:0106 46            INC     SI
D000:0107 47            INC     DI
D000:0108 E2F7          LOOP    0101
D000:010A BE0000        MOV     SI,0000

# Reset flags for a new operation (I think), including the clearing of
# a few flags in the first few bytes we copied from the user.

# The USER specified flags for SELECTION are limited to 
# ASSERT_ATN, which should let the USER decide weather or not they 
# want to send a message to the device.

D000:010D 80640402      AND     PARAM_SELECT, ICR_ASSERT_ATN

D000:0111 80640540      AND     BYTE PTR [SI+05],40

D000:0115 80643320      AND     PARAM_PARITY, MR_ENABLE_PAR_CHECK

D000:0119 B080          MOV     AL,80
D000:011B 0A4405        OR      AL,[SI+05]
D000:011E 0A4408        OR      AL,[SI+08]
D000:0121 88442F        MOV     [SI+2F],AL
D000:0124 C64429FF      MOV     BYTE PTR [SI+29],FF

# Read magic port (this clears the IRQ bit and may do some other
# resetting of the chip??)

D000:0128 BA4701        MOV     DX,GSI_MAGIC_PORT_2 ; clear adapter IRQ
D000:012B EC            IN      AL,DX

# Get upper byte of port address (0x01xx or 0x02xx)

D000:012C 8B542B        MOV     DX,[SI+2B]

# Disable reselection interrupts

D000:012F B24C          MOV     DL, BASE + SELECT_ENABLE_REG
D000:0131 32C0          XOR     AL,AL
D000:0133 EE            OUT     DX,AL

# Clear, in sequence:  output data register, mode register, select
# enable register, start DMA target receive register (I wouldn't have
# expected the latter!)  

# WRONG.  output data, initiator command, mode register, TARGET 
# COMMAND register.   IMHO, they should have set the SELECT ENABLE register
# to zero along with the rest of them.

D000:0134 B90400        MOV     CX,0004
D000:0137 B248          MOV     DL,BASE
D000:0139 33C0          XOR     AX,AX	
D000:013B EE            OUT     DX,AL
D000:013C 83C202        ADD     DX,+02
D000:013F E2FA          LOOP    013B

# Convert target unit number to select mask

D000:0141 8A4C07        MOV     CL,[SI+07]
D000:0144 80E107        AND     CL,07
D000:0147 B001          MOV     AL,01
D000:0149 D2E0          SHL     AL,CL
D000:014B 884407        MOV     [SI+07],AL

# See if we're trying to talk with ourselves

D000:014E 3A4434        CMP     AL,[SI+34]
D000:0151 5A            POP     DX
D000:0152 7507          JNZ     015B

# Yes, we are.

D000:0154 C6442DFE      MOV     BYTE PTR [SI+2D],FE
D000:0158 EB1B          JMP     0175

# Nope, sending command to somebody else.

D000:015A 90            NOP
D000:015B B080          MOV     AL,80
D000:015D 0A4405        OR      AL,[SI+05]
D000:0160 0A4408        OR      AL,[SI+08]
D000:0163 88442F        MOV     [SI+2F],AL
D000:0166 C6442D00      MOV     BYTE PTR [SI+2D],00
D000:016A C6443700      MOV     BYTE PTR [SI+37],00
D000:016E 06            PUSH    ES
D000:016F 52            PUSH    DX
D000:0170 E89800        CALL    020B
D000:0173 5A            POP     DX
D000:0174 07            POP     ES
D000:0175 8A442D        MOV     AL,[SI+2D]
D000:0178 3C02          CMP     AL,02
D000:017A 756F          JNZ     01EB
D000:017C F64403FF      TEST    BYTE PTR [SI+03],FF
D000:0180 7469          JZ      01EB
D000:0182 C6441403      MOV     BYTE PTR [SI+14],03
D000:0186 C6441500      MOV     BYTE PTR [SI+15],00
D000:018A C6441600      MOV     BYTE PTR [SI+16],00
D000:018E C6441700      MOV     BYTE PTR [SI+17],00
D000:0192 8A4402        MOV     AL,[SI+02]
D000:0195 884418        MOV     [SI+18],AL
D000:0198 C6441900      MOV     BYTE PTR [SI+19],00
D000:019C C6440906      MOV     BYTE PTR [SI+09],06
D000:01A0 B83C00        MOV     AX,003C
D000:01A3 89440C        MOV     [SI+0C],AX
D000:01A6 8CD8          MOV     AX,DS
D000:01A8 89440E        MOV     [SI+0E],AX
D000:01AB B080          MOV     AL,80
D000:01AD 0A4405        OR      AL,[SI+05]
D000:01B0 0A4408        OR      AL,[SI+08]
D000:01B3 88442F        MOV     [SI+2F],AL
D000:01B6 C6442D00      MOV     BYTE PTR [SI+2D],00
D000:01BA C64437FF      MOV     BYTE PTR [SI+37],FF
D000:01BE 06            PUSH    ES
D000:01BF 52            PUSH    DX
D000:01C0 E84800        CALL    020B
D000:01C3 5A            POP     DX
D000:01C4 07            POP     ES
D000:01C5 8A442D        MOV     AL,[SI+2D]
D000:01C8 3C00          CMP     AL,00
D000:01CA 7538          JNZ     0204
D000:01CC 8BFA          MOV     DI,DX
D000:01CE 8A443E        MOV     AL,[SI+3E]
D000:01D1 26            ES:
D000:01D2 8805          MOV     [DI],AL
D000:01D4 8A4448        MOV     AL,[SI+48]
D000:01D7 26            ES:
D000:01D8 884501        MOV     [DI+01],AL
D000:01DB 8B443F        MOV     AX,[SI+3F]
D000:01DE 26            ES:
D000:01DF 894510        MOV     [DI+10],AX
D000:01E2 8B4441        MOV     AX,[SI+41]
D000:01E5 26            ES:
D000:01E6 894512        MOV     [DI+12],AX
D000:01E9 B002          MOV     AL,02
D000:01EB 50            PUSH    AX
D000:01EC BA4701        MOV     DX,GSI_MAGIC_PORT_2
D000:01EF EC            IN      AL,DX
D000:01F0 58            POP     AX
D000:01F1 07            POP     ES
D000:01F2 5A            POP     DX
D000:01F3 59            POP     CX
D000:01F4 5B            POP     BX
D000:01F5 5E            POP     SI
D000:01F6 BF0000        MOV     DI,0000
D000:01F9 FA            CLI
D000:01FA 8B653A        MOV     SP,[DI+3A]
D000:01FD 8E5538        MOV     SS,[DI+38]
D000:0200 FB            STI
D000:0201 5F            POP     DI
D000:0202 1F            POP     DS
D000:0203 CF            IRET
D000:0204 C6442DFA      MOV     BYTE PTR [SI+2D],FA
D000:0208 E96AFF        JMP     0175

#
#  The following looks like a general-purpose "arbitrate for the bus
#  and start a command" routine.
#

D000:020B C6443600      MOV     BYTE PTR [SI+36],00
D000:020F C6442800      MOV     BYTE PTR [SI+28],00
D000:0213 8B542B        MOV     DX,[SI+2B]

# Clear the chip registers in preparation for a new command

D000:0216 E88600        CALL    029F     ;clear initiator cmd reg
D000:0219 B24A          MOV     DL,BASE + MODE_REG
D000:021B EE            OUT     DX,AL    ; clear mode reg

# TARGET COMMAND REG must be zero otherwise the non-driven target 
# signals (all not-active) won't match the phase bits and data won't
# be driven on the bus.

D000:021C B24B          MOV     DL,BASE + TARGET_COMMAND_REG
D000:021E EE            OUT     DX,AL    ; clear target cmd reg
D000:021F B24F          MOV     DL,BASE + RESET_PARITY_INTERRUPT_REG
D000:0221 EC            IN      AL,DX    ; reset pending interrupt condition

# Clear arbitration bit in MODE register

D000:0222 B24A          MOV     DL,BASE + MODE_REG
D000:0224 EC            IN      AL,DX    ; 
D000:0225 24FE          AND     AL,~MR_ARBITRATE 
D000:0227 EE            OUT     DX,AL    ; 

# start arbitration for the bus

D000:0228 B248          MOV     DL,BASE + OUTPUT_DATA_REG
D000:022A 8A4434        MOV     AL,[SI+34] ; this is our device sel mask
# drive our ID plus Target ID on bus once arbitration starts
D000:022D EE            OUT     DX,AL   

# Set NR_ARBITRATE bit in MODE register
D000:022E B24A          MOV     DL,BASE + MODE_REG
D000:0230 EC            IN      AL,DX
D000:0231 0C01          OR      AL,01
D000:0233 EE            OUT     DX,AL    

# wait until arbitration actually begins

D000:0234 B249          MOV     DL,BASE + INITIATOR_COMMAND_REG
D000:0236 EC            IN      AL,DX
D000:0237 A840          TEST    AL, ICR_ARBITRATION_PROGRESS
D000:0239 74F9          JZ      0234

# Spin in place briefly (TIMING HACK! UGLY!)

D000:023B B90200        MOV     CX,0002
D000:023E E2FE          LOOP    023E

# Check to see if we lost arbitration.  If so, go back and try again.

D000:0240 EC            IN      AL,DX
D000:0241 A820          TEST    AL,ICR_ARBITRATION_LOST
D000:0243 75DD          JNZ     0222

# Double-check the results of the arbitration to make sure that we
# didn't get a false win (I think that's what this is doing...) and go
# back if the arbitration results aren't what we expected.  This may
# plug some race conditions...
#
# Yes.

D000:0245 B248          MOV     DL,BASE + CURRENT_SCSI_DATA
D000:0247 EC            IN      AL,DX

# Nifty assembler hack : If no bits higher than our ID are asserted, 
# we think we've won.  If not, go back and wait for the chip to tell
# us we really have lost arbitration.

D000:0248 2A4434        SUB     AL,[SI+34]
D000:024B 2A4434        SUB     AL,[SI+34]
D000:024E 7802          JS      0252
D000:0250 EBD0          JMP     0222

# Check once again for arbitration loss.

D000:0252 B249          MOV     DL,BASE + INITIATOR_COMMAND_REG
D000:0254 EC            IN      AL,DX
D000:0255 A820          TEST    AL,ICR_ARBITRATION_LOST
# Arbitrate until successfull.
D000:0257 75C9          JNZ     0222  

# Following instruction seems to make no sense.

D000:0259 B00C          MOV     AL,0C

# Put both our own selection mask and that of the target into the data reg.

D000:025B B248          MOV     DL,BASE + OUTPUT_DATA_REG
D000:025D 8A4434        MOV     AL,[SI+34]
D000:0260 0A4407        OR      AL,[SI+07]
D000:0263 EE            OUT     DX,AL

# Assert BSY, SEL, DATA bus (ATN too, IFF directed by user)

D000:0264 B249          MOV     DL,BASE + INITIATOR_COMMAND_REG
D000:0266 B00D          MOV     AL,ICR_ASSERT_BSY | ICR_ASSERT_SEL |
				ICR_ASSERT_DATA
D000:0268 0A4404        OR      AL,PARAM_SELECT
D000:026B EE            OUT     DX,AL

# Clear arbitration... we're done with it.

D000:026C B24A          MOV     DL,BASE + MODE_REG
D000:026E EC            IN      AL,DX
D000:026F 24FE          AND     AL,~MR_ARBITRATE
D000:0271 EE            OUT     DX,AL

# Clear select-enable register.

D000:0272 B000          MOV     AL,00
D000:0274 B24C          MOV     DL,BASE + SELECT_ENABLE_REG
D000:0276 EE            OUT     DX,AL

# Assert SEL, DATA bus (ATN iff directed by user)

D000:0277 B249          MOV    DL,BASE  + INITIATOR_COMMAND_REG
D000:0279 B005          MOV     AL,ICR_ASSERT_SEL | ICR_ASSERT_DATA
D000:027B 0A4404        OR      AL,PARAM_SELECT
D000:027E EE            OUT     DX,AL

# Wait for the BUSY bit to go high... spin for a while (ugly timing
# hack) until it does.

D000:027F B900C0        MOV     CX,C000
D000:0282 B24C          MOV     DL,BASE + STATUS_REG
D000:0284 EC            IN      AL,DX
D000:0285 A840          TEST    AL,SR_BSY
D000:0287 751C          JNZ     02A5
D000:0289 E2F7          LOOP    0282

# Target didn't go BSY.  Selection failure, apparently.  Go turn off
# the SEL and DATA assertions.

D000:028B E80C00        CALL    029A

# Check the BUSY bit once again.  Maybe some devices report BUSY only
# after you release SEL?

# NO. This simply prevents race conditions where we deasserted SEL 
# while the target was asserting BSY.  Shouldn't really happen,
# spec. says the host should wait 250ms after which you KNOW something
# went wrong...

D000:028E B24C          MOV     DL,BASE + STATUS_REG
D000:0290 EC            IN      AL,DX
D000:0291 A840          TEST    AL,SR_BSY
D000:0293 7510          JNZ     02A5

# Store data in SRAM (most recent fail code??) and return.

D000:0295 C6442DFD      MOV     BYTE PTR [SI+2D],FD
D000:0299 C3            RET

# Assert SCSI_DATA_REG, deassert everything else.

D000:029A B249          MOV     DL,49
D000:029C B001          MOV     AL,01
D000:029E EE            OUT     DX,AL

# Clear initiator command register (including assert of SCSI_DATA_REG)
# returns with AL zero

D000:029F B249          MOV     DL,49
D000:02A1 B000          MOV     AL,00
D000:02A3 EE            OUT     DX,AL
D000:02A4 C3            RET

# OK, at this point we've won arbitration and have gotten the attention
# of the device we're selecting, SEL is released but ATN remains 
# asserted if the user dictated.

D000:02A5 B249          MOV     DL,BASE + INITIATOR_COMMAND_REG
D000:02A7 B001          MOV     AL,ICR_ASSERT_DATA
D000:02A9 0A4404        OR      AL,SELECTION_PARAM
D000:02AC EE            OUT     DX,AL

# Only ATN is asserted if the user specified.

D000:02AD 8A4404        MOV     AL,PARAM_SELECT
D000:02B0 EE            OUT     DX,AL

# Clear flag??

A
D000:02B1 C6442A00      MOV     BYTE PTR [SI+2A],00

# Clear mode register

D000:02B5 B000          MOV     AL,00
D000:02B7 8B542B        MOV     DX,[SI+2B]
D000:02BA B24A          MOV     DL,BASE + MODE_REG
D000:02BC EE            OUT     DX,AL

# Reset parity-interrupt

D000:02BD B24F          MOV     DL,BASE + RESET_PARITY_INTERRUPT_REG
D000:02BF EC            IN      AL,DX

# Enable interrupt if BSY falls unexpectedly.

D000:02C0 B004          MOV     AL,MR_MONITOR_BSY
D000:02C2 B24A          MOV     DL,BASE + MODE_REG
D000:02C4 EE            OUT     DX,AL

# Check to see if interrupt is being asserted, if not proceed

D000:02C5 B24D          MOV     DL,BASE + BUS_AND_STATUS_REG
D000:02C7 EC            IN      AL,DX
D000:02C8 A810          TEST    AL,BASR_IRQ
D000:02CA 742E          JZ      02FA

# On failure, reset mode register.

D000:02CC 8BD8          MOV     BX,AX
D000:02CE B24A          MOV     DL,4A
D000:02D0 32C0          XOR     AL,AL
D000:02D2 EE            OUT     DX,AL

# Clear all initiator assertions gracefully...

D000:02D3 E8C4FF        CALL    029A

# Unexpected change to BSY status?

D000:02D6 F6C304        TEST    BL,04
D000:02D9 7509          JNZ     02E4

# Nope.  Some other cause.  Clear initiator assertions to zero

D000:02DB E8C1FF        CALL    029F

# Read-to-clear interrupt condition and go bail

D000:02DE B24F          MOV     DL,4F
D000:02E0 EC            IN      AL,DX
D000:02E1 EB12          JMP     02F5

# Hmmm... we lost BSY unexpectedly.  SI+2A nonzero means we expected
# this might happen??

D000:02E3 90            NOP
D000:02E4 807C2A00      CMP     BYTE PTR [SI+2A],00
D000:02E8 740B          JZ      02F5

# SI+30 zero means we expected it and want to do something about it??

D000:02EA 807C3004      CMP     BYTE PTR [SI+30],04
D000:02EE 7509          JNZ     02F9

# go do something (dunno what...)

D000:02F0 E89604        CALL    0789
D000:02F3 EBBC          JMP     02B1

# report failure (0xFC == unexpected interrupt during operation)

D000:02F5 C6442DFC      MOV     BYTE PTR [SI+2D],FC
D000:02F9 C3            RET

# No unexpected IRQ.  Check REQ.  If not up yet, go back and check for
# IRQ troubles.

D000:02FA B24C          MOV     DL,BASE + STATUS_REG
D000:02FC EC            IN      AL,DX
D000:02FD A820          TEST    AL,SR_REQ
D000:02FF 74C4          JZ      02C5

# REQ is high.  Mask off MSG, CD, IO bits.  Move to the 0xE bits and save.

D000:0301 251C00        AND     AX, SR_MSG | SR_CD | SR_IO
D000:0304 D1E8          SHR     AX,1
D000:0306 8BF8          MOV     DI,AX

# shift to the 0x7 bits. and save.

D000:0308 D1E8          SHR     AX,1
D000:030A 884429        MOV     PHASE,AL

# Move these three (phase) bits to the target command register.

D000:030D B24B          MOV     DL,BASE + TARGET_COMMAND_REG
D000:030F EE            OUT     DX,AL

# Clear initiator command register.

D000:0310 B249          MOV     DL,BASE + INITIATOR_COMMAND_REG
D000:0312 B000          MOV     AL,00
D000:0314 EE            OUT     DX,AL

# This looks like a computed GOTO based on the phase we're in??

# Yes, this is an indirect jump.  
# CS:0045 is an array of near pointers which is indexed by the phase
# we're in.  
# Index	Phase Direction		Signals 
# 0 : DATAOUT (to target)
# 1 : DATAIN (from target)	IO
# 2 : CMDOUT (to target)	CD
# 3 : STATIN (from target)	IO | CD
# 4 : undefined
# 5 : undefined
# 6 : MSGOUT (to target)	CD | MSG
# 7 : MSGIN (from target)	CD | MSG | IO

D000:0315 2E            CS:
D000:0316 FFA54500      JMP     [DI+0045]


D000:031A 8B5C0C        MOV     BX,[SI+0C]
D000:031D 8B440E        MOV     AX,[SI+0E]
D000:0320 8EC0          MOV     ES,AX
D000:0322 C6442F08      MOV     BYTE PTR [SI+2F],08
D000:0326 F6442EFF      TEST    BYTE PTR [SI+2E],FF
 
# Disable first DMA controller by setting DISABLE bit in the 
# COMMAND register at address 0x08.

D000:032A B004          MOV     AL,04
D000:032C E608          OUT     08,AL
D000:032E B249          MOV     DL,49
D000:0330 B001          MOV     AL,01
D000:0332 EE            OUT     DX,AL
D000:0333 C64428FF      MOV     BYTE PTR [SI+28],FF

#
# If W3 is clear then goto 0x370 else goto 0x425
#

D000:0337 7437          JZ      0370
D000:0339 E9E900        JMP     0425
D000:033C BB1400        MOV     BX,0014
D000:033F 8A4C09        MOV     CL,[SI+09]
D000:0342 B500          MOV     CH,00
D000:0344 8CD8          MOV     AX,DS
D000:0346 8EC0          MOV     ES,AX
D000:0348 E96503        JMP     06B0
D000:034B BB2F00        MOV     BX,002F
D000:034E B90100        MOV     CX,0001
D000:0351 8CD8          MOV     AX,DS
D000:0353 8EC0          MOV     ES,AX
D000:0355 E95803        JMP     06B0
D000:0358 BB2D00        MOV     BX,002D
D000:035B EB04          JMP     0361
D000:035D 90            NOP
D000:035E BB3000        MOV     BX,0030
D000:0361 B90100        MOV     CX,0001
D000:0364 8CD8          MOV     AX,DS
D000:0366 8EC0          MOV     ES,AX
D000:0368 E97C03        JMP     06E7
D000:036B C6442DFB      MOV     BYTE PTR [SI+2D],FB
D000:036F C3            RET

DATA_OUT: 
# Disable DMA channel one by writing SET (0x4) channel 1 mask to
# mask register 

D000:0370 B005          MOV     AL,05
D000:0372 E60A          OUT     0A,AL

# Initialize byte pointer flipflop to known state, interrupts are 
# disabled so that we can write the two consecutive bytes of the 
# pointer correctly. 
#
# Set up the DMA controller for memory to IO operation
 
D000:0374 B001          MOV     AL,01
D000:0376 0C48          OR      AL,DMA_MODE_WRITE
D000:0378 FA            CLI
# Arbitrary value can be written here
D000:037B E60B          OUT     DMA1_CLEAR_FF_REG,AL
D000:0379 E60C          OUT     DMA1_MODE_REG,AL	

# 
# Initialize NCR5380 for DMA mode

D000:037D B24A          MOV     DL,BASE + MODE_REG
D000:037F B002          MOV     AL,MR_DMA_MODE
D000:0381 0A4433        OR      AL,PARAM_PARITY
D000:0384 EE            OUT     DX,AL

# Store address high nibble in CH, low 16 bits in AX
D000:0385 8CC0          MOV     AX,ES
D000:0387 B104          MOV     CL,04
D000:0389 D3C0          ROL     AX,CL
D000:038B 8AE8          MOV     CH,AL
D000:038D 80E50F        AND     CH,0F
D000:0390 24F0          AND     AL,F0
D000:0392 03C3          ADD     AX,BX
D000:0394 50            PUSH    AX

D000:0395 7302          JNB     0399
# carry if needed 
D000:0397 FEC5          INC     CH
D000:0399 89440C        MOV     [SI+0C],AX
/* 
 * Program low byte followed by second byte of address register for channel 1
 */
D000:039C E602          OUT     DMA_ADDR_1, AL
D000:039E 8AC4          MOV     AL,AH
D000:03A0 E602          OUT     DMA_ADDR_1, AL

# 
# Program top byte of address for channel one into channel 1 page 
# register
D000:03A2 8AC5          MOV     AL,CH
D000:03A4 884435        MOV     [SI+35],AL
D000:03A7 E683          OUT     DMA_PAGE_1, AL

D000:03A9 B104          MOV     CL,04
D000:03AB D2C5          ROL     CH,CL
D000:03AD 32C9          XOR     CL,CL
D000:03AF 894C0E        MOV     [SI+0E],CX
D000:03B2 58            POP     AX
D000:03B3 F7D0          NOT     AX

# 
# Program low byte followed by high byte of count for channel one,
# total 16 bits for 64K of data in one transfer.
#

D000:03B5 E603          OUT     DMA_CNT_1,AL
D000:03B7 8AC4          MOV     AL,AH
D000:03B9 E603          OUT     DMA_CNT_1,AL

#
# Renable DMA controller 
# 

D000:03BB B000          MOV     AL,00
D000:03BD E608          OUT     DMA1_CMD_REG,AL

#
# Read status
#
D000:03BF E408          IN      AL,DMA1_STAT_REG

D000:03C1 BA4601        MOV     DX,GSI_MAGIC_PORT_1

# Read MAGIC port
D000:03C4 EC            IN      AL,DX

# 
# Clear disable mask bit for channel 1 
D000:03C5 B001          MOV     AL,01
D000:03C7 E60A          OUT     DMA1_MASK_REG,AL

# Let's do it.
D000:03C9 FB            STI

D000:03CA B90010        MOV     CX,1000
D000:03CD C6443200      MOV     BYTE PTR [SI+32],00
D000:03D1 8B542B        MOV     DX,[SI+2B]
D000:03D4 B24D          MOV     DL,BASE + START_DMA_SEND_REG 
D000:03D6 EE            OUT     DX,AL

/* 
 * Read status register, bits 0-3 reflect terminal status of 
 * a given channel, mask off channel one.
 */

D000:03D7 E408          IN      AL,DMA1_STAT_REG
D000:03D9 2402          AND     AL,02
/*
 * If terminal count was reached, skip to 03F3
 */

D000:03DB 7516          JNZ     03F3

#
# If there's a phase mismatch, skip to 3F0
# 

D000:03DD B24D          MOV     DL,BASE + BUS_AND_STATUS_REG
D000:03DF EC            IN      AL,DX
D000:03E0 A808          TEST    AL,BASR_PHASE_MATCH
D000:03E2 740C          JZ      03F0

# 
# Otherwise, if no phase mismatch decrement outer counters and 
# loop.
#

D000:03E4 FE4C32        DEC     BYTE PTR [SI+32]
D000:03E7 75EE          JNZ     03D7
D000:03E9 E2EC          LOOP    03D7

/* Loop ends here, start terminal count gunk */ 

D000:03EB C6442DF8      MOV     BYTE PTR [SI+2D],F8
D000:03EF C3            RET - return from function 

D000:03F0 E98D01        JMP     0580
D000:03F3 B24D          MOV     DL,4D
D000:03F5 EC            IN      AL,DX
D000:03F6 A808          TEST    AL,08
D000:03F8 74F6          JZ      03F0
D000:03FA B24A          MOV     DL,4A
D000:03FC B000          MOV     AL,00
D000:03FE EE            OUT     DX,AL
D000:03FF FA            CLI

/* More fun! */
D000:0400 E60C          OUT     0C,AL
D000:0402 FE4435        INC     BYTE PTR [SI+35]
D000:0405 C7440C0000    MOV     WORD PTR [SI+0C],0000
D000:040A 81440E0010    ADD     WORD PTR [SI+0E],1000
D000:040F 8A4435        MOV     AL,[SI+35]
D000:0412 E683          OUT     83,AL
D000:0414 B001          MOV     AL,01
D000:0416 E60A          OUT     0A,AL
D000:0418 E408          IN      AL,08
D000:041A FB            STI
D000:041B B24A          MOV     DL,4A
D000:041D B002          MOV     AL,02
D000:041F EE            OUT     DX,AL
D000:0420 B24D          MOV     DL,4D
D000:0422 EE            OUT     DX,AL
D000:0423 EBB2          JMP     03D7

#
# Alternate DMA for DATAOUT
#

#
# Set mask bit for channel 3
# 

D000:0425 B007          MOV     AL,07
D000:0427 E60A          OUT     DMA1_MASK_REG,AL

#
# Program channel three for MEMORY to IO
#

D000:0429 B003          MOV     AL,03
D000:042B 0C48          OR      AL,DMA_MODE_WRITE
D000:042D FA            CLI
D000:042E E60C          OUT     DMA1_CLEAR_FF_REG,AL
D000:0430 E60B          OUT     DMA1_MODE_REG,AL

D000:0432 B24A          MOV     DL,BASE + MODE_REG
D000:0434 B002          MOV     AL,MR_DMA
D000:0436 0A4433        OR      AL,PARAM_PARITY
D000:0439 EE            OUT     DX,AL

D000:043A 8CC0          MOV     AX,ES
D000:043C B104          MOV     CL,04
D000:043E D3C0          ROL     AX,CL
D000:0440 8AE8          MOV     CH,AL
D000:0442 80E50F        AND     CH,0F
D000:0445 24F0          AND     AL,F0
D000:0447 03C3          ADD     AX,BX
D000:0449 50            PUSH    AX
D000:044A 7302          JNB     044E
D000:044C FEC5          INC     CH
D000:044E 89440C        MOV     [SI+0C],AX
D000:0451 E606          OUT     06,AL
D000:0453 8AC4          MOV     AL,AH
D000:0455 E606          OUT     06,AL
D000:0457 8AC5          MOV     AL,CH
D000:0459 884435        MOV     [SI+35],AL
D000:045C E682          OUT     82,AL
D000:045E B104          MOV     CL,04
D000:0460 D2C5          ROL     CH,CL
D000:0462 32C9          XOR     CL,CL
D000:0464 894C0E        MOV     [SI+0E],CX
D000:0467 58            POP     AX
D000:0468 F7D0          NOT     AX
D000:046A E607          OUT     07,AL
D000:046C 8AC4          MOV     AL,AH
D000:046E E607          OUT     07,AL
D000:0470 B000          MOV     AL,00
D000:0472 E608          OUT     08,AL
D000:0474 E408          IN      AL,08
D000:0476 BA4601        MOV     DX,GSI_MAGIC_PORT_1
D000:0479 EC            IN      AL,DX
D000:047A B003          MOV     AL,03
D000:047C E60A          OUT     0A,AL
D000:047E FB            STI
D000:047F B90010        MOV     CX,1000
D000:0482 C6443200      MOV     BYTE PTR [SI+32],00
D000:0486 8B542B        MOV     DX,[SI+2B]
D000:0489 B24D          MOV     DL,4D
D000:048B EE            OUT     DX,AL
D000:048C E408          IN      AL,08
D000:048E 2408          AND     AL,08
D000:0490 7516          JNZ     04A8
D000:0492 B24D          MOV     DL,4D
D000:0494 EC            IN      AL,DX
D000:0495 A808          TEST    AL,08
D000:0497 740C          JZ      04A5
D000:0499 FE4C32        DEC     BYTE PTR [SI+32]
D000:049C 75EE          JNZ     048C
D000:049E E2EC          LOOP    048C
D000:04A0 C6442DF8      MOV     BYTE PTR [SI+2D],F8
D000:04A4 C3            RET
D000:04A5 E9B001        JMP     0658
D000:04A8 B24D          MOV     DL,4D
D000:04AA EC            IN      AL,DX
D000:04AB A808          TEST    AL,08
D000:04AD 74F6          JZ      04A5
D000:04AF B24A          MOV     DL,4A
D000:04B1 B000          MOV     AL,00
D000:04B3 EE            OUT     DX,AL
D000:04B4 FA            CLI
D000:04B5 E60C          OUT     0C,AL
D000:04B7 FE4435        INC     BYTE PTR [SI+35]
D000:04BA C7440C0000    MOV     WORD PTR [SI+0C],0000
D000:04BF 81440E0010    ADD     WORD PTR [SI+0E],1000
D000:04C4 8A4435        MOV     AL,[SI+35]
D000:04C7 E682          OUT     82,AL
D000:04C9 B003          MOV     AL,03
D000:04CB E60A          OUT     0A,AL
D000:04CD E408          IN      AL,08
D000:04CF FB            STI
D000:04D0 B24A          MOV     DL,4A
D000:04D2 B002          MOV     AL,02
D000:04D4 EE            OUT     DX,AL
D000:04D5 B24D          MOV     DL,4D
D000:04D7 EE            OUT     DX,AL
D000:04D8 EBB2          JMP     048C
D000:04DA 8B5C0C        MOV     BX,[SI+0C]
D000:04DD 8B440E        MOV     AX,[SI+0E]
D000:04E0 8EC0          MOV     ES,AX
D000:04E2 C6442F08      MOV     BYTE PTR [SI+2F],08
D000:04E6 F64437FF      TEST    BYTE PTR [SI+37],FF
D000:04EA 7407          JZ      04F3
D000:04EC C6443700      MOV     BYTE PTR [SI+37],00
D000:04F0 E9F401        JMP     06E7
D000:04F3 F6442EFF      TEST    BYTE PTR [SI+2E],FF
D000:04F7 B004          MOV     AL,04
D000:04F9 E608          OUT     08,AL
D000:04FB 7403          JZ      0500
D000:04FD E9D800        JMP     05D8
D000:0500 B005          MOV     AL,05
D000:0502 E60A          OUT     0A,AL
D000:0504 B001          MOV     AL,01
D000:0506 0C44          OR      AL,44
D000:0508 FA            CLI
D000:0509 E60C          OUT     0C,AL
D000:050B E60B          OUT     0B,AL
D000:050D B24A          MOV     DL,4A
D000:050F B002          MOV     AL,02
D000:0511 0A4433        OR      AL,PARAM_PARITY
D000:0514 EE            OUT     DX,AL
D000:0515 8CC0          MOV     AX,ES
D000:0517 B104          MOV     CL,04
D000:0519 D3C0          ROL     AX,CL
D000:051B 8AE8          MOV     CH,AL
D000:051D 80E50F        AND     CH,0F
D000:0520 24F0          AND     AL,F0
D000:0522 03C3          ADD     AX,BX
D000:0524 50            PUSH    AX
D000:0525 7302          JNB     0529
D000:0527 FEC5          INC     CH
D000:0529 89440C        MOV     [SI+0C],AX
D000:052C E602          OUT     02,AL
D000:052E 8AC4          MOV     AL,AH
D000:0530 E602          OUT     02,AL
D000:0532 8AC5          MOV     AL,CH
D000:0534 884435        MOV     [SI+35],AL
D000:0537 E683          OUT     83,AL
D000:0539 B104          MOV     CL,04
D000:053B D2C5          ROL     CH,CL
D000:053D 32C9          XOR     CL,CL
D000:053F 894C0E        MOV     [SI+0E],CX
D000:0542 58            POP     AX
D000:0543 F7D0          NOT     AX
D000:0545 E603          OUT     03,AL
D000:0547 8AC4          MOV     AL,AH
D000:0549 E603          OUT     03,AL
D000:054B B000          MOV     AL,00
D000:054D E608          OUT     08,AL
D000:054F E408          IN      AL,08
D000:0551 BA4601        MOV     DX,GSI_MAGIC_PORT_1
D000:0554 EC            IN      AL,DX
D000:0555 B001          MOV     AL,01
D000:0557 E60A          OUT     0A,AL
D000:0559 FB            STI
D000:055A B90010        MOV     CX,1000
D000:055D C6443200      MOV     BYTE PTR [SI+32],00
D000:0561 8B542B        MOV     DX,[SI+2B]
D000:0564 B24F          MOV     DL,4F
D000:0566 EE            OUT     DX,AL
D000:0567 E408          IN      AL,08
D000:0569 2402          AND     AL,02
D000:056B 751E          JNZ     058B
D000:056D B24D          MOV     DL,4D
D000:056F EC            IN      AL,DX
D000:0570 A808          TEST    AL,08
D000:0572 740C          JZ      0580
D000:0574 FE4C32        DEC     BYTE PTR [SI+32]
D000:0577 75EE          JNZ     0567
D000:0579 E2EC          LOOP    0567
D000:057B C6442DF8      MOV     BYTE PTR [SI+2D],F8
D000:057F C3            RET
D000:0580 BA4701        MOV     DX,GSI_MAGIC_PORT_2
D000:0583 EC            IN      AL,DX
D000:0584 B005          MOV     AL,05
D000:0586 E60A          OUT     0A,AL
D000:0588 E92AFD        JMP     02B5
D000:058B B24D          MOV     DL,4D
D000:058D EC            IN      AL,DX
D000:058E A808          TEST    AL,08
D000:0590 74EE          JZ      0580
D000:0592 B24E          MOV     DL,4E
D000:0594 EC            IN      AL,DX
D000:0595 8AD8          MOV     BL,AL
D000:0597 B24A          MOV     DL,4A
D000:0599 B000          MOV     AL,00
D000:059B EE            OUT     DX,AL
D000:059C FA            CLI
D000:059D E60C          OUT     0C,AL
D000:059F FE4435        INC     BYTE PTR [SI+35]
D000:05A2 C7440C0000    MOV     WORD PTR [SI+0C],0000
D000:05A7 81440E0010    ADD     WORD PTR [SI+0E],1000
D000:05AC 1E            PUSH    DS
D000:05AD 8B440E        MOV     AX,[SI+0E]
D000:05B0 8ED8          MOV     DS,AX
D000:05B2 8AC3          MOV     AL,BL
D000:05B4 BB0000        MOV     BX,0000
D000:05B7 8807          MOV     [BX],AL
D000:05B9 1F            POP     DS
D000:05BA B001          MOV     AL,01
D000:05BC E602          OUT     02,AL
D000:05BE B000          MOV     AL,00
D000:05C0 E602          OUT     02,AL
D000:05C2 8A4435        MOV     AL,[SI+35]
D000:05C5 E683          OUT     83,AL
D000:05C7 B001          MOV     AL,01
D000:05C9 E60A          OUT     0A,AL
D000:05CB E408          IN      AL,08
D000:05CD FB            STI
D000:05CE B24A          MOV     DL,4A
D000:05D0 B002          MOV     AL,02
D000:05D2 EE            OUT     DX,AL
D000:05D3 B24F          MOV     DL,4F
D000:05D5 EE            OUT     DX,AL
D000:05D6 EB8F          JMP     0567
D000:05D8 B007          MOV     AL,07
D000:05DA E60A          OUT     0A,AL
D000:05DC B003          MOV     AL,03
D000:05DE 0C44          OR      AL,44
D000:05E0 FA            CLI
D000:05E1 E60C          OUT     0C,AL
D000:05E3 E60B          OUT     0B,AL
D000:05E5 B24A          MOV     DL,4A
D000:05E7 B002          MOV     AL,02
D000:05E9 0A4433        OR      AL,PARAM_PARITY
D000:05EC EE            OUT     DX,AL
D000:05ED 8CC0          MOV     AX,ES
D000:05EF B104          MOV     CL,04
D000:05F1 D3C0          ROL     AX,CL
D000:05F3 8AE8          MOV     CH,AL
D000:05F5 80E50F        AND     CH,0F
D000:05F8 24F0          AND     AL,F0
D000:05FA 03C3          ADD     AX,BX
D000:05FC 50            PUSH    AX
D000:05FD 7302          JNB     0601
D000:05FF FEC5          INC     CH
D000:0601 89440C        MOV     [SI+0C],AX
D000:0604 E606          OUT     06,AL
D000:0606 8AC4          MOV     AL,AH
D000:0608 E606          OUT     06,AL
D000:060A 8AC5          MOV     AL,CH
D000:060C 884435        MOV     [SI+35],AL
D000:060F E682          OUT     82,AL
D000:0611 B104          MOV     CL,04
D000:0613 D2C5          ROL     CH,CL
D000:0615 32C9          XOR     CL,CL
D000:0617 894C0E        MOV     [SI+0E],CX
D000:061A 58            POP     AX
D000:061B F7D0          NOT     AX
D000:061D E607          OUT     07,AL
D000:061F 8AC4          MOV     AL,AH
D000:0621 E607          OUT     07,AL
D000:0623 B000          MOV     AL,00
D000:0625 E608          OUT     08,AL
D000:0627 E408          IN      AL,08
D000:0629 BA4601        MOV     DX,GSI_MAGIC_PORT_1
D000:062C EC            IN      AL,DX
D000:062D B003          MOV     AL,03
D000:062F E60A          OUT     0A,AL
D000:0631 FB            STI
D000:0632 B90010        MOV     CX,1000
D000:0635 C6443200      MOV     BYTE PTR [SI+32],00
D000:0639 8B542B        MOV     DX,[SI+2B]
D000:063C B24F          MOV     DL,4F
D000:063E EE            OUT     DX,AL
D000:063F E408          IN      AL,08
D000:0641 2408          AND     AL,08
D000:0643 751E          JNZ     0663
D000:0645 B24D          MOV     DL,4D
D000:0647 EC            IN      AL,DX
D000:0648 A808          TEST    AL,08
D000:064A 740C          JZ      0658
D000:064C FE4C32        DEC     BYTE PTR [SI+32]
D000:064F 75EE          JNZ     063F
D000:0651 E2EC          LOOP    063F
D000:0653 C6442DF8      MOV     BYTE PTR [SI+2D],F8
D000:0657 C3            RET
D000:0658 BA4701        MOV     DX,GSI_MAGIC_PORT_2
D000:065B EC            IN      AL,DX
D000:065C B007          MOV     AL,07
D000:065E E60A          OUT     0A,AL
D000:0660 E952FC        JMP     02B5
D000:0663 B24D          MOV     DL,4D
D000:0665 EC            IN      AL,DX
D000:0666 A808          TEST    AL,08
D000:0668 74EE          JZ      0658
D000:066A B24E          MOV     DL,4E
D000:066C EC            IN      AL,DX
D000:066D 8AD8          MOV     BL,AL
D000:066F B24A          MOV     DL,4A
D000:0671 B000          MOV     AL,00
D000:0673 EE            OUT     DX,AL
D000:0674 FA            CLI
D000:0675 E60C          OUT     0C,AL
D000:0677 FE4435        INC     BYTE PTR [SI+35]
D000:067A C7440C0000    MOV     WORD PTR [SI+0C],0000
D000:067F 81440E0010    ADD     WORD PTR [SI+0E],1000
D000:0684 1E            PUSH    DS
D000:0685 8B440E        MOV     AX,[SI+0E]
D000:0688 8ED8          MOV     DS,AX
D000:068A 8AC3          MOV     AL,BL
D000:068C BB0000        MOV     BX,0000
D000:068F 8807          MOV     [BX],AL
D000:0691 1F            POP     DS
D000:0692 B001          MOV     AL,01
D000:0694 E606          OUT     06,AL
D000:0696 B000          MOV     AL,00
D000:0698 E606          OUT     06,AL
D000:069A 8A4435        MOV     AL,[SI+35]
D000:069D E682          OUT     82,AL
D000:069F B003          MOV     AL,03
D000:06A1 E60A          OUT     0A,AL
D000:06A3 E408          IN      AL,08
D000:06A5 FB            STI
D000:06A6 B24A          MOV     DL,4A
D000:06A8 B002          MOV     AL,02
D000:06AA EE            OUT     DX,AL
D000:06AB B24F          MOV     DL,4F
D000:06AD EE            OUT     DX,AL
D000:06AE EB8F          JMP     063F
D000:06B0 B249          MOV     DL,49
D000:06B2 B001          MOV     AL,01
D000:06B4 EE            OUT     DX,AL
D000:06B5 B24A          MOV     DL,4A
D000:06B7 B000          MOV     AL,00
D000:06B9 EE            OUT     DX,AL
D000:06BA 51            PUSH    CX
D000:06BB B24D          MOV     DL,4D
D000:06BD EC            IN      AL,DX
D000:06BE A808          TEST    AL,08
D000:06C0 7412          JZ      06D4
D000:06C2 B248          MOV     DL,48
D000:06C4 26            ES:
D000:06C5 8A07          MOV     AL,[BX]
D000:06C7 EE            OUT     DX,AL
D000:06C8 E87200        CALL    073D
D000:06CB 43            INC     BX
D000:06CC 59            POP     CX
D000:06CD 49            DEC     CX
D000:06CE 51            PUSH    CX
D000:06CF B9F0FF        MOV     CX,FFF0
D000:06D2 7504          JNZ     06D8
D000:06D4 59            POP     CX
D000:06D5 E9DDFB        JMP     02B5
D000:06D8 B24C          MOV     DL,4C
D000:06DA EC            IN      AL,DX
D000:06DB A820          TEST    AL,20
D000:06DD 75DC          JNZ     06BB
D000:06DF E2F7          LOOP    06D8
D000:06E1 59            POP     CX
D000:06E2 C6442DF9      MOV     BYTE PTR [SI+2D],F9
D000:06E6 C3            RET
D000:06E7 C6443000      MOV     BYTE PTR [SI+30],00
D000:06EB 8A4433        MOV     AL,PARAM_PARITY
D000:06EE B24A          MOV     DL,4A
D000:06F0 EE            OUT     DX,AL
D000:06F1 51            PUSH    CX
D000:06F2 B24D          MOV     DL,4D
D000:06F4 EC            IN      AL,DX
D000:06F5 A808          TEST    AL,08
D000:06F7 7433          JZ      072C
D000:06F9 B248          MOV     DL,48
D000:06FB EC            IN      AL,DX
D000:06FC 26            ES:
D000:06FD 8807          MOV     [BX],AL
D000:06FF 43            INC     BX
D000:0700 59            POP     CX
D000:0701 49            DEC     CX
D000:0702 51            PUSH    CX
D000:0703 B9F0FF        MOV     CX,FFF0
D000:0706 740E          JZ      0716
D000:0708 E83200        CALL    073D
D000:070B B24C          MOV     DL,4C
D000:070D EC            IN      AL,DX
D000:070E A820          TEST    AL,20
D000:0710 75E0          JNZ     06F2
D000:0712 E2F7          LOOP    070B
D000:0714 EBCB          JMP     06E1
D000:0716 F6443320      TEST    PARAM_PARITY,MR_ENABLE_PAR_CHECK
D000:071A 7407          JZ      0723
D000:071C B24D          MOV     DL,4D
D000:071E EC            IN      AL,DX
D000:071F A820          TEST    AL,20
D000:0721 7506          JNZ     0729
D000:0723 E81300        CALL    0739
D000:0726 EB04          JMP     072C
D000:0728 90            NOP
D000:0729 E81600        CALL    0742
D000:072C 59            POP     CX
D000:072D 807C3002      CMP     BYTE PTR [SI+30],02
D000:0731 7503          JNZ     0736
D000:0733 FE4436        INC     BYTE PTR [SI+36]
D000:0736 E97CFB        JMP     02B5
D000:0739 C64431FE      MOV     BYTE PTR [SI+31],FE
D000:073D B400          MOV     AH,00
D000:073F EB0B          JMP     074C
D000:0741 90            NOP
D000:0742 8A6404        MOV     AH,[SI+04]
D000:0745 FE4431        INC     BYTE PTR [SI+31]
D000:0748 7502          JNZ     074C
D000:074A B400          MOV     AH,00
D000:074C B249          MOV     DL,49
D000:074E EC            IN      AL,DX
D000:074F 0C10          OR      AL,10
D000:0751 0AC4          OR      AL,AH
D000:0753 EE            OUT     DX,AL
D000:0754 807C2907      CMP     BYTE PTR [SI+29],07
D000:0758 740D          JZ      0767
D000:075A 807C2903      CMP     BYTE PTR [SI+29],03
D000:075E 751B          JNZ     077B
D000:0760 C6442F05      MOV     BYTE PTR [SI+2F],05
D000:0764 EB15          JMP     077B
D000:0766 90            NOP
D000:0767 C6442F09      MOV     BYTE PTR [SI+2F],09
D000:076B 807C3000      CMP     BYTE PTR [SI+30],00
D000:076F 7406          JZ      0777
D000:0771 807C3004      CMP     BYTE PTR [SI+30],04
D000:0775 7504          JNZ     077B
D000:0777 C6442AFF      MOV     BYTE PTR [SI+2A],FF
D000:077B B24C          MOV     DL,4C
D000:077D EC            IN      AL,DX
D000:077E A820          TEST    AL,20
D000:0780 75F9          JNZ     077B
D000:0782 B249          MOV     DL,49
D000:0784 EC            IN      AL,DX
D000:0785 3410          XOR     AL,10
D000:0787 EE            OUT     DX,AL
D000:0788 C3            RET
D000:0789 F64436FF      TEST    BYTE PTR [SI+36],FF
D000:078D 742F          JZ      07BE
D000:078F C6443600      MOV     BYTE PTR [SI+36],00
D000:0793 FA            CLI
D000:0794 E60C          OUT     0C,AL
D000:0796 F6442EFF      TEST    BYTE PTR [SI+2E],FF
D000:079A 7409          JZ      07A5
D000:079C E406          IN      AL,06
D000:079E 8AE0          MOV     AH,AL
D000:07A0 E406          IN      AL,06
D000:07A2 EB07          JMP     07AB
D000:07A4 90            NOP
D000:07A5 E402          IN      AL,02
D000:07A7 8AE0          MOV     AH,AL
D000:07A9 E402          IN      AL,02
D000:07AB 86E0          XCHG    AH,AL
D000:07AD 89440C        MOV     [SI+0C],AX
D000:07B0 FB            STI
D000:07B1 F64428FF      TEST    BYTE PTR [SI+28],FF
D000:07B5 7407          JZ      07BE
D000:07B7 C6442800      MOV     BYTE PTR [SI+28],00
D000:07BB FF4C0C        DEC     WORD PTR [SI+0C]
D000:07BE B24F          MOV     DL,4F
D000:07C0 EC            IN      AL,DX
D000:07C1 B24C          MOV     DL,4C
D000:07C3 8A4434        MOV     AL,[SI+34]
D000:07C6 EE            OUT     DX,AL        ; to select-enable
D000:07C7 B24D          MOV     DL,4D
D000:07C9 EC            IN      AL,DX
D000:07CA A810          TEST    AL,10
D000:07CC 74F9          JZ      07C7
D000:07CE B24C          MOV     DL,4C
D000:07D0 EC            IN      AL,DX
D000:07D1 A804          TEST    AL,04
D000:07D3 74E9          JZ      07BE
D000:07D5 B249          MOV     DL,49
D000:07D7 B009          MOV     AL,09
D000:07D9 EE            OUT     DX,AL
D000:07DA B24C          MOV     DL,4C
D000:07DC EC            IN      AL,DX
D000:07DD A802          TEST    AL,02
D000:07DF 75FB          JNZ     07DC
D000:07E1 32C0          XOR     AL,AL
D000:07E3 EE            OUT     DX,AL
D000:07E4 E8B3FA        CALL    029A
D000:07E7 B24F          MOV     DL,4F
D000:07E9 EC            IN      AL,DX
D000:07EA C3            RET
D000:07EB 90            NOP
