/*
 *   ultrastor.h - used by low-level scsi driver for UltraStor 14F/34F
 */
#ifndef _ULTRASTOR_H
#define _ULTRASTOR_H

int ultrastor_14f_detect(Scsi_Host_Template *);
const char *ultrastor_14f_info(void);
int ultrastor_14f_queuecommand(Scsi_Cmnd *, void (*done)(Scsi_Cmnd *));
int ultrastor_14f_abort(Scsi_Cmnd *);
int ultrastor_14f_reset(Scsi_Cmnd *);
int ultrastor_14f_biosparam(Disk *, int, int *);

#define ULTRASTOR_14F_MAX_SG 16
#define ULTRASTOR_MAX_CMDS_PER_LUN 1
#define ULTRASTOR_MAX_CMDS 7          /* One command for each scsi target */
#define ULTRASTOR_14F_SCSI_ID 7
#define ULTRASTOR_14F_VERSION "1.01.00"

#define ULTRASTOR_14F { NULL, \
   "UltraStor 14F/34F driver rev. " ULTRASTOR_14F_VERSION ".", \
   ultrastor_14f_detect, \
   NULL, \
   ultrastor_14f_info, \
   0, \
   ultrastor_14f_queuecommand, \
   ultrastor_14f_abort, \
   ultrastor_14f_reset, \
   0, \
   ultrastor_14f_biosparam, \
   ULTRASTOR_MAX_CMDS, \
   ULTRASTOR_14F_SCSI_ID, \
   ULTRASTOR_14F_MAX_SG, \
   ULTRASTOR_MAX_CMDS_PER_LUN, \
   0, \
   1, /* unchecked_isa_dma, owerwritten by the detect routine */ \
   DISABLE_CLUSTERING }
#endif
