/*
 *  linux/kernel/si_serial.h
 *
 *  Copyright (C) 1994  Simon Allen
 *
 *  SI-Host serial driver.
 *
 *  Version 0.0 - 28.5.94
 */

/*-------------------- USER CONFIG SECTION ------------------------*/
/* BASE MEMORY ADDRESS */
unsigned char *si_base = (char *) 0x0d0000;

/* Hardware IRQ. */
#define SI_IRQ 15

/* Define this if you want to use polling. Overides the above */
#undef SI_USE_POLLING

/* If the firmware in the file "si_download.c" is available - normally defined */
#define SI_DOWNLOAD_CODE

/* Number of characters left in xmit buffer before we ask for more */
#define WAKEUP_CHARS 512 /* Norm. 256 - should be between 0 and 4096 */

/* Major device number for the driver */
#define SI_TTY_MAJOR 30

/* Major aux device number for the driver */
#define SI_TTYAUX_MAJOR 31 

/* Minor device number start for the driver */
#define SI_TTY_MINOR_START 0 

/* Spread characters among all ports - Experimental */
/* #define SI_SPREAD_TX */

/* Interrupt rate and additional rx interrupt throttle */
#define INT_COUNT    25000
#define RX_INT_COUNT 1

/* Define this if you have SIO, undefine it if you have XIO */
#define HAVE_SIO_SYSTEM

/* Define this if you have EISA bus PC (this is even more alpha than the
 * rest of the driver ;-) Note. This will read the card address from the
 * card which overrides the value of si_base above.
 */
#undef HAVE_EISA

/* Hack time... Here are features that should probably be removed or at
 * least cleaned up in future.
 */
/* For kernels that use old_style request_irq() */
#define OLD_REQUEST_IRQ

/* You might want to experiment with the following but there not really meant
 * for general config use by the user. They're there to be tweaked and left!
 */

/* Simulated interrupt rate when any port is active. */
#ifdef SI_USE_POLLING
#define SI_ACTIVE_TIMER_DELAY 5     /* 5 = 20 per sec - Polling. */
#else
#define SI_ACTIVE_TIMER_DELAY 100   /* 100 = 1 per sec - IRQ     */
#endif


/* Simulated interrupt rate when all ports are inactive. */
#ifdef SI_USE_POLLING
#define SI_INACTIVE_TIMER_DELAY 10  /* 10 =  10 per sec - Polling */
#else
#define SI_INACTIVE_TIMER_DELAY 500 /* 500 = 1 every 5 secs - IRQ */
#endif



/* THE FOLLOWING SHOULD PROBABLY GO INTO THE APPROPRIATE HEADERS. 
 * Or they may disappear altogether in the future ;-)
 */

#define PORT_SI_HOST              5 /* linux/serial.h (so prob. here) */
#define SI_SERIAL_MAGIC      0x5303 /* linux/serial.h (so prob. here) */
#define TTY_DRIVER_HW_ONLCR  0x0008 /* Flag to tell ntty what we can handle */
#define SI_TIMER                 25 /* linux/timer.h */

/*--------------- END OF USER CONFIG SECTION ---------------------*/



/* Do not change anything below this line.
   (Unless you know what you're doing of course :-) */

#define TRUE 1 
#define FALSE 0

#ifdef HAVE_SIO_SYSTEM
#define SI_ID_STR "SIO"
#else
#define SI_ID_STR "XIO"
#endif

#ifdef SI_USE_POLLING
#define si_irq  0
#else
#define si_irq SI_IRQ
#endif

/* Card control structure */
struct si_card_control
{
	unsigned char   init_stat;         /* Initialization status             */
	unsigned char   mem_size;          /* Size of SI-Host RAM 32 or 64K     */
	unsigned short  int_count;         /* Interrupt throttle                */
	unsigned short  revision;          /* Firmware revision (download code) */
	unsigned char   rx_int_count;      /* Interrupt throttle                */
	unsigned char   fill;              /* Alignment                         */
	unsigned short  int_pending;       /* Indicates card has interrupted    */
	unsigned short  int_counter;       /* Used internally                   */
	unsigned char   int_scounter;      /* Used internally                   */
	unsigned char   RESERVED[0x80-13]; /* Reserved                          */
};


/* Module control structure */
struct si_module
{
	unsigned short	next;               /* Pointer to the next module          */
	unsigned char	type;               /* Type of module & Number of channels */
	unsigned char	mod_no;             /* Module number                       */
	unsigned char	dsr;                /* Private dsr copy                    */

	unsigned char	RESERVED[0x80 - 5]; /* Defined in si.h - Which is right?   */
#ifdef 0
	unsigned char	RESERVED[0xfb];     /* Reserved - Defined in manual.       */
#endif

};


/*	Channel control structure */
struct si_channel_control {
	unsigned short next_item;    /* Pointer to next channel         */
	unsigned short addr_uart;    /* Used Internally by card         */
	unsigned short module;       /* Pointer to module structure     */
	unsigned char  type;         /* Type of UART                    */
	unsigned char  fill;         /* Align on word                   */
	unsigned char  x_status;     /* Used internally by card         */
	unsigned char  c_status;     /* Used internally by card         */
	unsigned char  hi_rxipos;    /* Offset of input  in RX buffer   */
	unsigned char  hi_rxopos;    /* Offset of output in RX buffer   */
	unsigned char  hi_txopos;    /* Offset of output in TX buffer   */
	unsigned char  hi_txipos;    /* Offset of input  in TX buffer   */
	unsigned char  hi_hstat;     /* COMMAND REGISTER                */
	unsigned char  dsr_bit;      /* Used internally                 */
	unsigned char  txon;         /* TX XON  char                    */
	unsigned char  txoff;        /* TX XOFF char                    */
	unsigned char  rxon;         /* RX XON  char                    */
	unsigned char  rxoff;        /* RX XOFF char                    */
	unsigned char  hi_mr1;       /* Mode register #1                */
	unsigned char  hi_mr2;       /* Mode register #2                */
	unsigned char  hi_csr;       /* Baud rate                       */
	unsigned char  hi_op;        /* Output line status              */
	unsigned char  hi_ip;        /* Input line status               */
	unsigned char  hi_state;     /* Cause of Interrupt              */
	unsigned char  hi_prtcl;     /* Channel protocol                */
	unsigned char  hi_txon;      /* TX XON  char (Host copy)        */
	unsigned char  hi_txoff;     /* TX XOFF char (Host copy)        */
	unsigned char  hi_rxon;      /* RX XON  char (Host copy)        */
	unsigned char  hi_rxoff;     /* RX XOFF char (Host copy)        */
	unsigned char  close_prev;   /* Was channel previously closed ? */
	unsigned char  hi_break;     /* Host copy break process         */
	unsigned char  break_state;  /* Local copy break process        */
	unsigned char  hi_mask;      /* Mask for ISTRIP                 */
	unsigned char  mask_z280;    /* Used internally by card         */
	unsigned char  mod_type;     /* Module type                     */
	unsigned char  ccr_state;    /* Used internally by card         */
	unsigned char  ip_mask;      /* Used internally by card         */
	unsigned char  RESERVED  [0x60-39]; /* Reserved                 */
	unsigned char  hi_txbuf  [0x100];   /* TRANSMITTER DATA BUFFER  */
	unsigned char  hi_rxbuf  [0x100];   /* RECEIVER DATA BUFFER     */
	unsigned char  RESERVED1 [0xA0];    /* Reserved                 */
};
/* 'type' is a bit field as follows:  The bottom 5 bits are the
 * number of channels  on this module,  the top 3 bits are
 * as the module type thus:
 * 
 * 000     2698 RS232 module.
 * 001     2698 RS422 module.
 * 010     8530 based sync module.
 * 011     Centronics module.
 * 100     Network module.
 * 101-111 Reserved for expansion.
 */


#define MODULE_RS232	0x00
#define MODULE_RS422	0x20
#define MODULE_SYNC	0x40
#define MODULE_CENT	0x60
#define MODULE_NET	0x80
#define MODULE_MASK	0x1F


/* Command/Status definitions C=Command, S=Status */
#define IDLE_OPEN    0x00 /* S - Chan able to TX/RX */
#define LOPEN        0x02 /* C - Open channel */
#define MOPEN        0x04 /* C - Modem open (wait for DCD) */
#define MOPEND       0x06 /* S - Waiting for DCD */
#define CONFIG       0x08 /* C - Reconfig using settings in mr1, mr2 etc */
#define CLOSE        0x0A /* C - Close channel */
#define SBREAK       0x0C /* C - Start sending break */
#define EBREAK       0x0E /* C - Stop sending break */
#define IDLE_CLOSED  0x10 /* S - Closed channel */
#define IDLE_BREAK   0x12 /* S - In a break */
#define FORCE_CLOSED 0x14 /* C - Force chan to close - no wait for drain */
#define RESUME       0x16 /* C - Clear pending XOFF */
#define WFLUSH       0x18 /* C - Flush input buffer */
#define RFLUSH       0x1A /* C - Flush output buffer */


/* Mode register 1 */
#define MR1_5_BITS   0x00 /* 5 data bits                                    */
#define MR1_6_BITS   0x01 /* 6 data bits                                    */
#define MR1_7_BITS   0x02 /* 7 data bits                                    */
#define MR1_8_BITS   0x03 /* 8 data bits                                    */
#define MR1_ODD      0x04 /* Odd parity - Use in conjunction with MR1_WITH  */
#define MR1_EVEN     0x00 /* Even parity - Use in conjunction with MR1_WITH */
#define MR1_FORCE    0x08 /* Force parity                                   */
#define MR1_NONE     0x10 /* No parity                                      */
#define MR1_WITH     0x00 /* With parity                                    */
#define MR1_CTSCONT  0x80 /* CTS auto flow control                          */

/* Thses are from si.h 
 * I have  no idea what they mean =:-o
 */
#define MR1_CHAR     0x00
#define MR1_SPECIAL  0x18
#define MR1_BLOCK    0x20


/* Mode register 2 */
#define MR2_1_STOP   0x07 /* 1 stop bit            */
#define MR2_2_STOP   0x0F /* 2 stop bits           */
#define MR2_RTSCONT  0x10 /* RTS auto flow control */

/* Thses are from si.h as well.
 * I have  no idea what these mean either !!
 */
#define MR2_CTSCONT  0x20
#define MR2_NORMAL   0x00
#define MR2_AUTO     0x40
#define MR2_LOCAL    0x80
#define MR2_REMOTE   0xC0


/* Clock select register
 * Top 4 bits for TX, bottom 4 bits for RX
 * Baud rates are encoded in each 4 bits as follows :
 * 0000 (0) - 75
 * 0001 (1) - 110 for SI and 115200 for XIO
 * 0010 (2) - 38400
 * 0011 (3) - 150
 * 0100 (4) - 300
 * 0101 (5) - 600
 * 0110 (6) - 1200
 * 0111 (7) - 2000
 * 1000 (8) - 2400
 * 1001 (9) - 4800
 * 1010 (A) - 1800
 * 1011 (B) - 9600
 * 1100 (C) - 19200
 * 1101 (D) - 57600
 * 1110 (E) - RESERVED
 * 1111 (F) - RESERVED
 */

/* This is how Specialix have standardised the mappings */
#define U0     0x00  /* 75       baud */
#define U50    0xdd  /* 57600    baud */
#define U75    0x00  /* 75       baud */
#define U110   0x11  /* 110      baud */
#define U134   0x60  /* 1200/75  baud */
#define U150   0x33  /* 150      baud */
#define U200   0x06  /* 75/1200  baud */
#define U300   0x44  /* 300      baud */
#define U600   0x55  /* 600      baud */
#define U1200  0x66  /* 1200     baud */
#define U1800  0x77  /* 2000     baud */
#define U2400  0x88  /* 2400     baud */
#define U4800  0x99  /* 4800     baud */
#define U9600  0xbb  /* 9600     baud */
#define U19200 0xcc  /* 19200    baud */
#define U38400 0x22  /* 38400    baud */


/* Output control register (hi_op) */
#define OP_CTS       0x01 /* Raise CTS - Overridden by auto flow control */
#define OP_DSR       0x02 /* Raise DSR                                   */


/* Protocol register (hi_prtcl) */	
#define	SP_TANY		0x01 /* Tx XON any char */
#define	SP_TXEN		0x02 /* Tx XON/XOFF enabled */
#define	SP_CEN		0x04 /* Cooking enabled */
#define	SP_RXEN		0x08 /* Rx XON/XOFF enabled */
#define	SP_DCEN		0x20 /* DCD / DTR check */
#define	SP_PAEN		0x80 /* Parity checking enabled */


/* Break control register (hi_break) */
#define BR_IGN       0x01 /* Ignore all received breaks    */
#define BR_INT       0x02 /* Break causes interrupt        */
#define BR_PARMRK    0x04 /* Enable parity checking        */
#define BR_PARIGN    0x08 /* Disable input parity checking */


/* Interrupt satus (hi_state) */
#define ST_BREAK     0x01 /* Break has been received (clear with config) */
#define ST_DCD       0x02 /* DCD, DTR, RTS or RI changed                 */


/* Input Line status (hi_ip) */
#define IP_RTS       0x02 /* RTS Asserted             */
#define IP_DCD       0x04 /* DCD Asserted             */
#define IP_DTR       0x20 /* DTR Asserted             */
#define IP_RI        0x40 /* RI  Asserted (XIO only?) */


/* These come from si.h  and are concerned with interrupts and things */
#define SIPLSIG    0x7FF8			/* Start of control space */
#define SIPLCNTL   0x7FF8			/* Ditto                  */
#define SIPLRESET  SIPLCNTL		/* 0 = reset              */
#define SIPLIRQ11  SIPLCNTL+1		/* 0 = irq 11             */
#define SIPLIRQ12  SIPLCNTL+2		/* 0 = irq 12             */
#define SIPLIRQ15  SIPLCNTL+3		/* 0 = irq 15             */
#define SIPLIRQSET SIPLCNTL+4		/* 0 = interrupt host     */
#define SIPLIRQCLR SIPLCNTL+5		/* 0 = clear irq          */


/* END OF FILE */

