/**************************************************************************/
/* svgafft --  Spectrum Analyzer                                          */
/*                                                                        */ 
/* color functions                                                        */
/**************************************************************************/

/**************************************************************************

    Copyright (C) 1995 Andrew Veliath

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


***************************************************************************/

// $Id: colors.cc,v 0.4 1995/04/15 19:30:49 drewvel Exp $

/**************************************************************************/
#include "colors.h"
#include <vgagl.h>
#include <iostream.h>

/**************************************************************************/
unsigned char RGBByteColor(Color& c)
{
  return gl_rgbcolor(c.r, c.g, c.b);
}


/**************************************************************************/
int RGBLargeColor(Color& c)
{
  
  int col=c.b | (c.g << 8) | (c.r << 16);
  return col;
}


/**************************************************************************/
void FadeArray(Color C1, Color C2, 
	       unsigned char colors[], int len)
{
  if (len!=0) {
    if (len>255) len=255;
    Color Inc=(C2-C1)/len;    
    Color Mid=C1;

    for (int i=0; i<len; i++) {
      colors[i]=RGBByteColor(Mid);
      Mid=Mid+Inc;
    }    
  }
}


/**************************************************************************/
void FadeArray(Color C1, Color C2, 
	       int colors[], int len)
{
  if (len!=0) {
    if (len>255) len=255;
    Color Inc=(C2-C1)/len;
    Color Mid=C1;

    for (int i=0; i<len; i++) {
      colors[i]=RGBLargeColor(Mid);
      Mid=Mid+Inc;
    }    
  }
}


/**************************************************************************/
void FadeColorRange(Color Colors[], int numcols, 
		    unsigned char colors[], int len)
{
  numcols--;
  float divlen=(float) len/(float) numcols;
  unsigned char i; 
  for (i=0; i<numcols; i++) 
    FadeArray(Colors[i], Colors[i+1], 
	      colors+(int) ((float) i*divlen), 
	      (int) divlen);
  colors[len]=RGBByteColor(Colors[numcols]);
}


/**************************************************************************/
void FadeColorRange(Color Colors[], int numcols, 
		    int colors[], int len)
{
  numcols--;
  float divlen=(float) len/(float) numcols;
  int i; 
  for (i=0; i<numcols; i++) 
    FadeArray(Colors[i], Colors[i+1], 
	      colors+(int) ((float) i*divlen), 
	      (int) divlen);
  colors[len]=RGBByteColor(Colors[numcols]);
}

/**************************************************************************/
