// -*- C++ -*-

// Configuration file handling
// This class handles reading and writing config files
// with simple name-value pairs.

// (C) Copyright 1994 Jeremy Fitzhardinge <jeremy@sw.oz.au>
// This code is distributed under the terms of the
// GNU General Public Licence.  See COPYING for more details.

#ifndef _CONFFILE_H_
#define _CONFFILE_H_

#pragma interface

#include <String.h>
#include <unistd.h>
#include "Path.h"

class ConfFile
{
	int changed;
	
	void parse();
	void unparse();

	Path name;
	
	struct list_t
	{
		list_t *next;
		String name;
		String val;
	} *list;

	list_t *find(const String &name) const;

public:
	ConfFile(const Path &);
	~ConfFile();

	void set(const String &name, const String &val);
	int get(const String &name, String &val) const;

	void setnum(const String &name, long);
	int getnum(const String &name, long &) const;
};

#endif /* _CONFFILE_H_ */
