// -*- C++ -*-

// Pathname handling

// (C) Copyright 1994 Jeremy Fitzhardinge <jeremy@sw.oz.au>
// This code is distributed under the terms of the
// GNU General Public Licence.  See COPYING for more details.

#pragma implementation

#include "Path.h"
#include <stdlib.h>
#include <unistd.h>
#include <sys/param.h>
#include <assert.h>
#include <string.h>

Path::Path(const String &elem, const Path *parent)
     :_parent(parent)
{
	p_rep = new _PathRep(elem, parent ? parent->p_rep : (const _PathRep *)NULL);
}

Path::Path(const Path &p)
{
	memcpy(this, &p, sizeof(*this));
	p_rep->incref();
}

Path &
Path::operator = (const Path &p)
{
	if (this != &p)
	{
		p_rep->decref();
		*this = p;
		p_rep->incref();
	}
	return *this;
}

Path::~Path()
{
	p_rep->decref();
}

_PathRep::_PathRep(const String &elem, const _PathRep *p)
	 :_path(elem), _parent(p)
{
	count = 1;
	if (p)
		((_PathRep *)p)->incref();		// XXX
}

_PathRep::~_PathRep()
{
	assert(count == 0);
	if (_parent != NULL)
		((_PathRep *)_parent)->decref();	// XXX
}

String
_PathRep::path() const
{
	String p;
	
	if (_parent != NULL)
	{
		p = _parent->path();
		cat(p, "/", _path, p);
	}
	else
		p = _path;

	return p;
}
