// -*- C++ -*-

// Pathnames

// (C) Copyright 1994 Jeremy Fitzhardinge <jeremy@sw.oz.au>
// This code is distributed under the terms of the
// GNU General Public Licence.  See COPYING for more details.

#ifndef _PATH_H_
#define _PATH_H_

#pragma interface

#include <String.h>

class _PathRep
{
	friend class Path;
	
	String _path;
	const _PathRep *_parent;
	int count;

	void decref()	{ if (--count == 0) delete this; }
	void incref()	{ count++; }
	
	String path() const;
	_PathRep(const String &, const _PathRep *parent);
	~_PathRep();
};

class Path
{
	_PathRep *p_rep;
	const Path *_parent;
	
public:
	Path(const String &elem, const Path *parent=NULL);
	Path(const Path &);
	~Path();

	Path &operator =(const Path &);
	
	const String &elem() const	{ return p_rep->_path; }
	String path() const		{ return p_rep->path(); }
	const Path *parent() const	{ return _parent; }
};

#endif /* _PATH_H_ */
