// -*- C++ -*-

// Directory inodes
// This contains the basic sync mechanisms for priming from a disk
// filesystem, and for serializing access to a single inode

// (C) Copyright 1994 Jeremy Fitzhardinge <jeremy@sw.oz.au>
// This code is distributed under the terms of the
// GNU General Public Licence.  See COPYING for more details.

#ifndef _DIR_H_
#define _DIR_H_

#pragma interface

#include <DirInode.h>
#include <String.h>
#include <LWP.h>
#include "Path.h"

class ftpfs;
class ftpconn;

class dir: public DirInode
{
	int do_iput(const up_preamble &, upp_repl &, const upp_iput_s &);

	void beforeop(up_ops);
	void afterop(up_ops);

	Semaphore sem;
	
protected:
	Path name;
	
	virtual Inode *newinode(dir *, const struct stat *, const String &) = 0;
	
	ftpfs &filesys;
	dir *parent;
public:
	dir(ftpfs &fs, const String &name, dir *up);

	String path() const		{ return name.path(); }

	virtual int depth() const
	{
		if (parent && parent != this)
			return parent->depth() + 1;
		return 0;
	}
	
	int open();
	const Path &getname() const	{ return name; }
	void init();
};

#endif /* _FTPDIR_H_ */
