// -*- C++ -*-

// FTP connection class

// (C) Copyright 1994 Jeremy Fitzhardinge <jeremy@sw.oz.au>
// This code is distributed under the terms of the
// GNU General Public Licence.  See COPYING for more details.

#ifndef _FTPCONN_H_
#define _FTPCONN_H_

#pragma interface

#include <String.h>
#include <netinet/in.h>

#include "LWP.h"
#include "ConfFile.h"

enum ftpstate_t {
	Unresolved,
	Resolved,
	Connected,
	LoggedIn,
	Listening,
	Transfer,
	Bad
};

#include <sys/types.h>
#include <time.h>

enum ftp_filetype
{
	FT_Unknown,
	FT_File,
	FT_Directory,
	FT_Link
};

struct ftp_filelist
{
	String name;
	String link;
	ftp_filetype type;
	time_t time;
	size_t size;
	
	ftp_filelist *next;
};

class ftpconn
{
	// Reference count
	int ref;

	// Connection state
	ftpstate_t state;
	const String hostname;

	// Parameters
	String username;	// Username (default "anonymous")
	String passwd;		// Password
	String site_root;	// Dir to cd to
	short	need_siteroot;
	time_t	timezone;	// Seconds from GMT
	short	need_tz;
	time_t	upd_timeout;	// Time before an update times out
	time_t	fail_timeout;	// Time before retrying after failure
	void getparams();
	void setparams();

	class host *site_host;	// Site's host-specific operations
	
	// Config file
	ConfFile conf;

	// Control connection
	struct sockaddr_in addr;
	struct sockaddr_in myaddr;
	int ctlsock;

	class ifstream *inbuf;
	
	// Data connection
	struct sockaddr_in dataaddr;
	int datasock;

	void init(const struct hostent *);
	int resolve_name(const struct hostent *);
	
	// Transition functions
	ftpstate_t resolve(ftpstate_t);
	ftpstate_t connect(ftpstate_t);
	ftpstate_t close(ftpstate_t);
	ftpstate_t login(ftpstate_t);
	ftpstate_t logout(ftpstate_t);
	ftpstate_t listen(ftpstate_t);
	ftpstate_t closedata(ftpstate_t);
	ftpstate_t abort(ftpstate_t);
	
	int goto_state(ftpstate_t);

	int sendcmd(String cmd, String * = NULL);
	int getreply(String * = NULL);
	
	Semaphore sem;
	
public:
	ftpconn(const Path &conffile, const String &host);
	ftpconn(const Path &conffile, const String &host,
		const struct hostent *);
	~ftpconn();

	ftp_filelist *getfilelist(const String &path);
	int getfile(const String &path, int fd, class ftpxfer *);
	int ftpcwd(String &cwd);
	int ftpsetcwd(const String &cwd, int =0);
	int makedir(const String &dir);
	
	void incref()	{ ref++; }
	void decref()
	{
		if (--ref == 0)
			delete this;
	}

	int get_upd_timeout() const	{ return upd_timeout; }
	int get_fail_timeout() const	{ return fail_timeout; }
};

class ftpxfer
{
public:
	virtual ~ftpxfer()	{}

	virtual void notify(int) = 0;
	virtual void error(int)	{}
};

#endif /* _FTPCONN_H_ */
