// -*- C++ -*-

// (C) Copyright 1994 Jeremy Fitzhardinge <jeremy@sw.oz.au>
// This code is distributed under the terms of the
// GNU General Public Licence.  See COPYING for more details.

#ifndef _FTPDIR_H_
#define _FTPDIR_H_

#pragma interface

#include "dir.h"

#include <sys/time.h>

class ftpconn;

class ftpdir: public dir
{
	void construct();
	void init();

	void cleanup();
	
	// FTP connection
	ftpconn *conn;

	// Parent dir in ftp site
	ftpdir *ftpup;

	// Parameters about this dir
	class ConfFile *conf;
	time_t	last_upd;
	time_t	last_failure;

	// Inode creation
	Inode *newinode(dir *, const struct stat *, const String &);

	// Resync with FTP site
	int updatedir(int force = 0);
	int init_done;
	
	// Config parameters
	void getparams();
	void setparams();
	
	// Operations
	int do_readdir(const up_preamble &, upp_repl &,
		       const upp_readdir_s &, upp_readdir_r &);
	int do_multireaddir(const up_preamble &, upp_repl &,
			    const upp_multireaddir_s &, upp_multireaddir_r &);
	int do_lookup(const up_preamble &pre, upp_repl &rep,
		      const upp_lookup_s &arg, upp_lookup_r &ret);
	int do_create(const up_preamble &, upp_repl &,
		      const upp_create_s &, upp_create_r &);

public:
	ftpdir(ftpfs &fs, const String &name, dir *up,
	       ftpdir *ftpup, ftpconn *conn);
	ftpdir(ftpfs &fs, const String &name, dir *up, ftpdir *ftpup,
	       const String &cfname);
	~ftpdir();

	String ftppath() const;
};

#endif /* _FTPDIR_H_ */
