// -*- C++ -*-

// Base inode class (apart from directories)

// (C) Copyright 1994 Jeremy Fitzhardinge <jeremy@sw.oz.au>
// This code is distributed under the terms of the
// GNU General Public Licence.  See COPYING for more details.

#pragma implementation

#include "ftpfs.h"
#include "ino.h"

ino::ino(ftpfs &fs)
    :SimpleInode(fs, fs.genhand()), sem(1)
{
	uid = fs.uid;
	gid = fs.gid;
}

void
ino::beforeop(up_ops)
{
	sem.wait();
}

void
ino::afterop(up_ops)
{
	sem.signal();
}

int
ino::do_iput(const up_preamble &, upp_repl &, const upp_iput_s &)
{
	if (nlink == 0)
		delete this;
	return 0;
}

void
ino::decref()
{
	nlink--;
	if (nlink == 0)
		delete this;
}
