#!/usr/bin/perl --
#
# Cache reaper.  This script keeps the cache size at or below
# a set point, keeping files most reciently used.
#
# (C) Copyright 1994 Jeremy Fitzhardinge <jeremy@sw.oz.au>
# This code is distributed under the terms of the
# GNU General Public Licence.  See COPYING for more details.

eval 'exec /usr/bin/perl -S $0 ${1+"$@"}'
	if $running_under_some_shell;

$#ARGV == 1 || die("Usage: $0 cache-dir max-size\n");
    
require "find.pl";

# Traverse desired filesystems

&find($ARGV[0]);

$ARGV[1] =~ tr/KMG/kmg/;
$ARGV[1] =~ /^([0-9]+)([kmg]?)$/;

$scale{"k"} = 1024;
$scale{"m"} = 1024*1024;
$scale{"g"} = 1024*1024*1024;

die("$0: $ARGV[1]: Bad scale factor\n")
    if (!defined($1) || ($2 != "" && !defined($scale{$2})));

$max = $1*$scale{$2};
$total = 0;
$delsz = 0;
$delfiles = 0;

foreach $key (reverse sort keys %sizes) {
    $sz = $sizes{$key};
    $total += $sz;

    if ($total > $max) {
	($atime, $name) = split(" ", $key, 2);
	unlink($name);
	$delsz += $sz;
	$delfiles++;
    }
}

print "$delsz bytes in $delfiles deleted\n";

exit;

sub wanted {
    if ((($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$sizemm,$atime) = lstat($_)) &&
    -f _ && $_ !~ /\.ftpfs_.*/)
    {
	$key = "$atime $name";
	$sizes{$key} = $sizemm;
    }
}

