// -*- C++ -*-

#pragma implementation

#include "intfs.h"
#include "intfsFifoDir.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <errno.h>
#include <stdio.h>

#include "dbg.h"

ifsFifoDir::ifsFifoDir(intfs &fs, Handle hand, DirInode *parent)
	:DirInode(fs, hand, parent, 30)
{
	count = 0;
	
	uid = 0;
	gid = 0;
	mode = S_IFDIR | S_ISVTX | 0555;
	mtime = ctime = time(0);
}

ifsFifoDir::~ifsFifoDir()
{
}

String
ifsFifoDir::create(Inode *ino)
{
	char buf[20];

	sprintf(buf, "C%d", count++);

	String n(buf);
	
	link(n, ino);

	DB(printf("ifsFifoDir::create linked inode to %s\n", (const char *)n));
	return n;
}

int
ifsFifoDir::do_unlink(const up_preamble &, upp_repl &,
		      const upp_unlink_s &)
{
	return EPERM;
}

int
ifsFifoDir::do_link(const up_preamble &, upp_repl &,
		    const upp_link_s &)
{
	return EPERM;
}

int
ifsFifoDir::do_rename(const up_preamble &, upp_repl &,
		      const upp_rename_s &)
{
	return EPERM;
}
