// -*- C++ -*-

#ifndef _INTFSFIFOINO_H_
#define _INTFSFIFOINO_H_

#pragma interface

#include <String.h>
#include <SimpleInode.h>

#include <sys/types.h>

class intfs;
class ifsDirIno;

class ifsFifoIno: public SimpleInode
{
	String command;
	ifsDirIno *dir;
	String name;

	pid_t pid;
	int readfd;
	int named;

	int start();
	void unname();

	uid_t uid, euid;
	gid_t gid, egid;
	
protected:
	intfs &filesys;

	int do_open(const up_preamble &, upp_repl &,
		    const upp_open_s &, upp_open_r &);
	int do_iput(const up_preamble &, upp_repl &,
		    const upp_iput_s &);
	int do_read(const up_preamble &, upp_repl &,
		    const upp_read_s &, upp_read_r &);
public:
	ifsFifoIno(intfs &, String command, ifsDirIno *dir);
	~ifsFifoIno();

	String getname() const	{ return name; }
};

#endif /* _INTFSFIFOINO_H_ */
