// -*- C++ -*-

// General base class for non-directory inodes in intfs

#pragma implementation

#include "intfsIno.h"
#include "intfs.h"
#include "intfsDirIno.h"

#include "dbg.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

ifsIno::ifsIno(intfs &fs, Handle hand, ifsDirIno *dir, String name, String link)
	: SimpleInode(fs, hand),
	  filesys(fs), name(name), link(link), dir(dir)
{
	size = link.length();
	mode = S_IFLNK|0777;
}

ifsIno::~ifsIno()
{
}

int ifsIno::do_readlink(const up_preamble &, upp_repl &,
			const upp_readlink_s &, upp_readlink_r &ret)
{
	int len;
	ret.name.alloc(len = link.length());
	memcpy(ret.name.elems, (const char *)link, len);
	ret.name.nelem = len;
	
	return 0;
}

int ifsIno::do_followlink(const up_preamble &, upp_repl &,
			  const upp_followlink_s &, upp_followlink_r &ret)
{
	int len;
	ret.path.alloc(len = link.length());
	memcpy(ret.path.elems, (const char *)link, len);
	ret.path.nelem = len;
	
	return 0;
}

int ifsIno::do_write(const up_preamble &, upp_repl &,
		     const upp_write_s &arg, upp_write_r &ret)
{
	LOG("ifsIno::do_write");
	int fd = open(O_WRONLY);
	int r;
	
	if (fd < 0)
		return -fd;
	if (::lseek(fd, arg.off, SEEK_SET) == -1)
	{
		int er = errno;
		::close(fd);
		return er;
	}
	if ((r = ::write(fd, arg.data.elems, arg.data.nelem)) == -1)
	{
		int er = errno;
		::close(fd);
		return er;
	}
	ret.wrote = r;
	::close(fd);
	return 0;
}

String ifsIno::path()
{
	String n;

	cat(dir->path(), "/", name, n);

	return n;
}

void ifsIno::update()
{
	struct stat st;
	String p = path();

	if (::lstat((const char *)p, &st) == -1)
	{
		DB(printf("ifsIno::update stat of %s failed: %s\n",
			  (const char *)p, strerror(errno)));
		return;
	}
	atime = st.st_atime;
	ctime = st.st_ctime;
	mtime = st.st_mtime;
	uid = st.st_uid;
	gid = st.st_gid;
}

int ifsIno::open(int mode)
{
	String p;
	int fd;
	
	cat(dir->path(), "/", name, p);
	if ((fd = ::open((const char *)p, mode)) == -1)
		return -errno;
	return fd;
}
