// -*- C++ -*-

// Inode for symbolic links in intfs filesystem

#pragma implementation

#include "intfsLinkIno.h"
#include "intfsFifoIno.h"
#include "intfsDirIno.h"

#include "dbg.h"

ifsLinkIno::ifsLinkIno(intfs &fs, Handle hand, ifsDirIno *dir, String name, String link)
	: ifsIno(fs, hand, dir, name, link)
{
}

ifsLinkIno::~ifsLinkIno()
{
}

int
ifsLinkIno::do_followlink(const up_preamble &pre, upp_repl &rep,
			  const upp_followlink_s &arg, upp_followlink_r &ret)
{
	LOG("ifsLinkIno::do_followlink");
	
	if (link(0,2) != "#!")
		return ifsIno::do_followlink(pre, rep, arg, ret);

	ifsFifoIno *ino = new ifsFifoIno(filesys, link.after(1), dir);

	String p;

	cat(dir->toppath(), "/.fifo/", ino->getname(), p);
	int len = p.length();

	DB(printf("ifsLinkIno::do_followlink returning link to %s\n",
		  (const char *)p));
	
	ret.path.alloc(len);
	ret.path.nelem = len;
	memcpy(ret.path.elems, (const char *)p, len);
	
	return 0;
}
