#ifndef _ARCVFS_H
#define _ARCVFS_H

#include "arcfs.h"

#define ARCFMT_ZIP
#undef ARCFMT_HPACK
#undef ARCFMT_ZOO
#define ARCFMT_TGZ

#ifdef ARCFMT_ZIP
ARC_DIRENT *arc_read_zip (const char *);
#endif
#ifdef ARCFMT_HPACK
ARC_DIRENT *arc_read_hpack (const char *);
#endif
#ifdef ARCFMT_ZOO
ARC_DIRENT *arc_read_zoo (const char *);
#endif
#ifdef ARCFMT_TGZ
ARC_DIRENT *arc_read_tgz (const char *);
#endif

ARC_DIRENT *create_entry (const char *, const char *, ARC_DIRENT *);
ARC_DIRENT *create_dirent (char *, char *, ARC_DIRENT **, ARC_DIRENT *);
char *skip_field (char *);

#endif /* _ARCVFS_H */
