// -*- C++ -*-

#pragma implementation

#include "mailfile.h"
#include <unistd.h>
#include <sys/stat.h>
#include <fstream.h>

mailfile::mailfile(Filesystem &fs, Handle h, 
 ifstream *ifile, streampos start, int l, time_t t)
 : SimpleInode(fs, h), start(start), ifile(ifile)
{
 uid = getuid();
 gid = getgid();
 mode = S_IFREG | 0444;
 size = l;
 atime = ctime = mtime = t;
}

int
mailfile::do_read(const up_preamble &pre, upp_repl &repl,
		  const upp_read_s &arg, upp_read_r &ret)
{
 int sz, off; // legth of returned bunch
 // Bunch is requested by kernel. Kernel asks for bunch of
 // arg.size bytes starting from arg.off
 
 // i = arg.file;
 off = arg.off;
 sz = arg.size;
 // l = arg.ctok;
 
 if(off >= size)
 {  
  ret.data.nelem = 0; // send EOF
 }
 else
 {  
  if(off + sz > size)
   sz = size - off;
  ret.data.alloc(ret.data.nelem = sz);
  ifile->seekg(start + off);
  ifile->read(ret.data.elems, sz);
 }
 return 0;
}
