# include	<stdio.h>
# include	<stdlib.h>
# include	<ctype.h>
# include	<unistd.h>
# include	<time.h>
# include	<string.h>
# include	<dirent.h>
# include	<sys/stat.h>
# include	"fslib.h"

static filenam	*root;

static char *
chkfname (register char *fn)
{
	register char	*ptr;

	for (ptr = strchr (fn, '/'); ptr; ptr = strchr (fn, '/'))
		*ptr = '_';
	return (fn);
}

static filenam *
read_disk (filenam *prev, char *fname)
{
	FILE	*fp;
	char	grp[256];
	char	title[256];
	char	buf[256];
	int	err;
	char	*ptr, *sav;
	filenam	*fnd, *cd, *base;
	finode	*i;
	ulong	up;
	int	nr;
	int	sub;
	int	ptime, ttime;

	if (! strcmp (fname, "SamplerKR_1"))
		nr = 1;
	if (! (fp = fopen (fname, "r")))
		return (prev);
	err = fgets (grp, sizeof (grp) - 1, fp) ? 0 : 1;
	err |= fgets (buf, sizeof (buf) - 1, fp) ? 0 : 1;
	err |= fgets (title, sizeof (title) - 1, fp) ? 0 : 1;
	err |= fgets (buf, sizeof (buf) - 1, fp) ? 0 : 1;
	if (err) {
		fclose (fp);
		return (prev);
	}
	if (ptr = strchr (grp, '\n'))
		*ptr = '\0';
	if (! grp[0])
		strcpy (grp, "    Sampler");
	chkfname (grp);
	if (ptr = strchr (title, '\n'))
		*ptr = '\0';
	chkfname (title);
	for (fnd = root; fnd; fnd = fnd -> next)
		if (! strcmp (fnd -> fname, grp))
			break;
	up = 0;
	if (! fnd) {
		if (fnd = alloc_filenam (grp, 0, True, NULL)) {
			prev -> next = fnd;
			prev = fnd;
			if (fnd = alloc_filenam (".", prev -> i, True, NULL)) {
				fnd -> next = alloc_filenam ("..", root -> i, True, NULL);
				fnd = fnd -> next;
				up = prev -> i;
			} else
				exit (33);
		} else
			exit (34);
	} else if (i = get_finode (fnd -> i)) {
		up = fnd -> i;
		fnd = i -> dir;
	} else
		fnd = NULL;
	if (! fnd) {
		fclose (fp);
		return (prev);
	}
	while (fnd -> next)
		fnd = fnd -> next;
	if (cd = alloc_filenam (title, 0, True, NULL)) {
		fnd -> next = cd;
		fnd = cd;
		if (cd = alloc_filenam (".", fnd -> i, True, NULL)) {
			base = cd;
			cd -> next = alloc_filenam ("..", up, True, NULL);
			cd = cd -> next;
		} else
			exit (35);
	} else
		exit (36);
	if (! cd) {
		fclose (fp);
		return (prev);
	}
	nr = 1;
	sub = 0;
	ptime = 0;
	while (fgets (buf, sizeof (buf) - 1, fp)) {
		if (ptr = strchr (buf, '\n'))
			*ptr = '\0';
		if (ptr = strchr (buf, '|'))
			*ptr++ = '\0';
		ttime = 0;
		while (ptr && *ptr) {
			sav = ptr;
			if (ptr = strchr (ptr, '.'))
				*ptr++ = '\0';
			ttime *= 60;
			ttime += atoi (sav);
		}
		ptime += ttime;
		ptr = buf;
		if (*ptr == ' ') {
			sprintf (grp, "%3d.%-2d ", nr - 1, sub + 1);
			++sub;
		} else if (*ptr == '\t') {
			sprintf (grp, "%3d%c.  ", nr - 1, (char) (sub + 'a'));
			++sub;
		} else {
			sprintf (grp, "%3d. ", nr);
			++nr;
			sub = 0;
		}
		while (isspace (*ptr))
			++ptr;
		sprintf (title, "%s%s", grp, ptr);
		if (cd -> next = alloc_filenam (chkfname (title), 0, False, NULL)) {
			cd = cd -> next;
			if (i = get_finode (cd -> i))
				i -> ino.mtime = 
				i -> ino.atime = 
				i -> ino.ctime = (time_t) ttime;
		} else
			exit (37);
	}
	if (i = get_finode (base -> i))
		i -> ino.mtime = 
		i -> ino.atime = 
		i -> ino.ctime = (time_t) ptime;
	fclose (fp);
	return (prev);
}

static Status
read_files (filenam *prev)
{
	DIR		*dp;
	struct dirent	*ent;
	struct stat	st;

	if (! (dp = opendir (".")))
		return (Ok);
	while (ent = readdir (dp)) {
		if (ent -> d_name[0] == '.')
			continue;
		if (stat (ent -> d_name, & st) == -1)
			continue;
		if (st.st_mode & S_IFDIR) {
			if (chdir (ent -> d_name) != -1) {
				if (read_files (prev) == Fail)
					return (Fail);
				if (chdir ("..") < 0)
					return (Fail);
				while (prev -> next)
					prev = prev -> next;
			}
			continue;
		} else if (! (st.st_mode & S_IFREG))
			continue;
		prev = read_disk (prev, ent -> d_name);
	}
	closedir (dp);
	return (Ok);
}

static Status
do_init (int ac, char **av)
{
	if (ac != 1) {
		fprintf (stderr, "Need a directory to read the infos from.\n");
		return (Fail);
	}
	if (chdir (av[0]) < 0) {
		fprintf (stderr, "Can't chdir() to %s.\n", av[0]);
		return (Fail);
	}
	if (! (root = make_root ()))
		return (Fail);
	if (read_files (root -> next) == Fail)
		return (Fail);
	return (Ok);
}

static ulong
do_mount (void)
{
	return (root -> i);
}

static FS_Status *
do_statfs (void)
{
	static FS_Status	fs;
	
	fs.bsize = 1024;
	fs.blocks = 2;
	fs.bfree = 0;
	fs.bavail = 0;
	fs.files = 0;
	fs.ffree = 0;
	fs.fsid.val[0] = fs.fsid.val[1] = 0;
	fs.namelen = 128;
	return (& fs);
}

static fscalls	calls = {
	def_errorlog,		/* errorlog */
	do_init,		/* init */
	NULL,			/* deinit */
	NULL,			/* create */
	def_lookup,		/* lookup */
	NULL,			/* close */
	NULL,			/* read */
	NULL,			/* write */
	NULL,			/* truncate */
	NULL,			/* fsync */
	def_readdir,		/* readdir */
	NULL,			/* link */
	NULL,			/* unlink */
	NULL,			/* symlink */
	NULL,			/* readlink */
	NULL,			/* followlink */
	do_mount,		/* mount */
	NULL,			/* umount */
	def_iread,		/* iread */
	NULL,			/* iwrite */
	do_statfs,		/* statfs */
	NULL,			/* iput */
	NULL,			/* open */
	NULL,			/* permission */
	NULL,			/* rename */
	def_multireaddir,	/* multireadddir */
	NULL			/* notify_change */
};

void
inform_user (UserInfo ui, void *ptr)
{
}

int
main (int argc, char **argv)
{
	return (userfs (argc, argv, & calls));
}
