# include	<stdio.h>
# include	<ctype.h>
# include	<unistd.h>
# include	<fcntl.h>
# include	<string.h>
# include	<malloc.h>
# include	<sys/stat.h>
# include	<errno.h>
# include	<pwd.h>
# include	"fslib.h"

# define	MAILSPOOL	"/usr/spool/mail"

typedef struct _dmail {
	ulong	ctok;
	ulong	opened;
	filenam	*start;
	struct _dmail
		*next;
}	dmail;

static filenam	*root = NULL;
static dmail	*base = NULL;
static dmail	*last = NULL;

static filenam *
read_mail (uid_t uid)
{
	struct passwd	*pw;
	char		fname[sizeof (MAILSPOOL) + 256];
	char		*buf;
	int		n;
	char		*ptr, *sav, *cont;
	char		**mails;
	int		cnt, siz;
	filenam		*start;
	filenam		*brun;
	filenam		*tmp;
	filenam		*down;
	finode		*i;
	databuf		*db;
	int		fd;
	struct stat	st;

	setpwent ();
	pw = getpwuid (uid);
	endpwent ();
	if (! pw)
		return (NULL);
	sprintf (fname, "%s/%s", MAILSPOOL, pw -> pw_name);
	if ((fd = open (fname, O_RDONLY)) < 0)
		return (NULL);
	if ((fstat (fd, & st) < 0) || (st.st_size == 0) || (! (buf = malloc (st.st_size + 2)))) {
		close (fd);
		return (NULL);
	}
	n = read (fd, buf, st.st_size);
	close (fd);
	if (n != st.st_size) {
		free (buf);
		return (NULL);
	}
	buf[n] = '\0';
	cnt = 0;
	siz = 0;
	mails = NULL;
	ptr = buf;
	while (ptr && *ptr) {
		if (cnt >= siz) {
			siz += 16;
			if (! (mails = (char **) realloc (mails, sizeof (char *) * (siz + 2)))) {
				cnt = 0;
				siz = 0;
				break;
			}
		}
		mails[cnt++] = ptr;
		while (ptr = strchr (ptr, '\n'))
			if (! strncasecmp (ptr + 1, "from ", 5)) {
				*ptr++ = '\0';
				break;
			} else
				++ptr;
	}
	if (! mails) {
		free (buf);
		return (NULL);
	}
	mails[cnt] = NULL;
	start = NULL;
	brun = NULL;
	for (n = 0; n < cnt; ++n) {
		sprintf (fname, "%03d", n + 1);
		if (! (tmp = make_directory (fname, root -> i, NULL)))
			break;
		if (! brun) {
			start = tmp;
			brun = start;
		} else {
			brun -> next = tmp;
			brun = brun -> next;
		}
		if ((! (i = get_finode (brun -> i))) || (! (down = i -> dir)))
			break;
		i -> ino.uid = pw -> pw_uid;
		i -> ino.gid = pw -> pw_gid;
		while (down -> next)
			down = down -> next;
		for (ptr = mails[n]; ptr && *ptr; ) {
			if (! (db = (databuf *) malloc (sizeof (databuf))))
				break;
			db -> magic = DATABUF_MAGIC;
			if (*ptr == '\n') {
				++ptr;
				cont = ptr;
				ptr = NULL;
				strcpy (fname, "body");
			} else {
				do {
					sav = ptr;
					while (*ptr && (! isspace (*ptr)) && (*ptr != ':'))
						++ptr;
					if (*ptr == ':') {
						*ptr++ = '\0';
						while (isspace (*ptr))
							++ptr;
						break;
					} else if (ptr = strchr (ptr, '\n')) {
						++ptr;
						while ((*ptr != '\n') && isspace (*ptr))
							if (ptr = strchr (ptr, '\n'))
								++ptr;
							else
								break;
					}
				} while (ptr && *ptr);
				if ((! ptr) || (! *ptr)) {
					free (db);
					db = NULL;
				} else {
					strcpy (fname, sav);
					sav = fname;
					if (*sav) {
						*sav = toupper (*sav);
						++sav;
						while (*sav) {
							*sav = tolower (*sav);
							++sav;
						}
					}
					cont = ptr;
					while (ptr = strchr (ptr, '\n')) {
						if ((! *ptr) || (*(ptr + 1) == '\n') || (! isspace (*(ptr + 1))))
							break;
						++ptr;
					}
					if (ptr && *ptr)
						*ptr++ = '\0';
				}
			}
			if (db) {
				if (fname[0]) {
					for (tmp = i -> dir; tmp; )
						if (! strcmp (tmp -> fname, fname)) {
							strcat (fname, "_");
							tmp = i -> dir;
						} else
							tmp = tmp -> next;
					db -> cnt = strlen (cont) + 1;
					db -> siz = db -> cnt + 2;
					if (db -> ptr = malloc (db -> siz + 2)) {
						strcpy ((char *) db -> ptr, cont);
						strcat ((char *) db -> ptr, "\n");
					} else {
						db -> cnt = 0;
						db -> siz = 0;
					}
					down -> next = alloc_filenam (fname, 0, False, db);
					if (! (down = down -> next))
						break;
					set_filesize (down -> i, db -> cnt);
				} else
					free (db);
			}
		}
	}
	return (start);
}

static Status
do_init (int ac, char **av)
{
	if (! (root = make_root ()))
		return (Fail);
	return (Ok);
}

static ulong
do_lookup (register ulong dir, register char *fname)
{
	Bool	reset;
	ulong	ret;

	reset = False;
	if (dir == root -> i) {
		if (last) {
			root -> next -> next = last -> start;
			reset = True;
		}
	}
	ret = def_lookup (dir, fname);
	if (reset)
		root -> next -> next = NULL;
	return (ret);
}

static Directory *
do_readdir (ulong dir, off_t off, ulong ctok)
{
	register dmail	*tmp;
	Bool		reset;
	Directory	*d;

	reset = False;
	if (dir == root -> i) {
		for (tmp = base; tmp; tmp = tmp -> next)
			if (tmp -> ctok == ctok)
				break;
		if (tmp) {
			last = tmp;
			root -> next -> next = tmp -> start;
			reset = True;
		}
	}
	d = def_readdir (dir, off, ctok);
	if (reset)
		root -> next -> next = NULL;
	return (d);
}

static ulong
do_mount (void)
{
	return (root -> i);
}

static ulong
do_open (ulong handle, Permission *p)
{
	if (def_open (handle, p))
		return ((ulong) p -> euid + 100);
	return (0);
}

static Status
do_permission (ulong handle, long mask, Permission *p)
{
	register dmail	*prev, *tmp;

	if (handle == root -> i) {
		prev = NULL;
		for (tmp = base; tmp; tmp = tmp -> next)
			if (tmp -> ctok == (ulong) p -> euid + 100)
				break;
			else
				prev = tmp;
		if (! tmp) {
			if (! (tmp = (dmail *) malloc (sizeof (dmail)))) {
				errno = ENOMEM;
				return (Fail);
			}
			tmp -> ctok = (ulong) p -> euid + 100;
			tmp -> opened = 1;
			tmp -> start = read_mail (p -> euid);
			tmp -> next = NULL;
			if (prev)
				prev -> next = tmp;
			else
				base = tmp;
		}
		last = tmp;
	}
	return (Ok);
}

void
inform_user (UserInfo ui, void *ptr)
{
}

static fscalls	calls = {
	def_errorlog,		/* errorlog */
	do_init,		/* init */
	NULL,			/* deinit */
	NULL,			/* create */
	do_lookup,		/* lookup */
	def_close,		/* close */
	def_read,		/* read */
	NULL,			/* write */
	NULL,			/* truncate */
	NULL,			/* fsync */
	do_readdir,		/* readdir */
	NULL,			/* link */
	NULL,			/* unlink */
	NULL,			/* symlink */
	NULL,			/* readlink */
	NULL,			/* followlink */
	do_mount,		/* mount */
	NULL,			/* umount */
	def_iread,		/* iread */
	NULL,			/* iwrite */
	def_statfs,		/* statfs */
	def_iput,		/* iput */
	do_open,		/* open */
	do_permission,		/* permission */
	NULL,			/* rename */
	NULL,			/* multireadddir */
	NULL			/* notify_change */
};

int
main (int argc, char **argv)
{
	return (userfs (argc, argv, & calls));
}
