# include	<stdio.h>
# include	<stdlib.h>
# include	<string.h>
# include	<malloc.h>
# include	<errno.h>
# include	"fslib.h"
# include	"zipfs.h"

static filenam	*root = NULL;
static zipcalls	*zc = NULL;

static Status
alloc_zipnfo (ulong inum, char *path)
{
	finode	*i;
	zipnfo	*z;

	if (! (i = get_finode (inum)))
		return (Fail);
	if (! i -> priv) {
		if (! (z = (zipnfo *) malloc (sizeof (zipnfo))))
			return (Fail);
		if (! (z -> path = strdup (path))) {
			free (z);
			return (Fail);
		}
		z -> dirty = False;
		z -> cont = NULL;
		z -> cnt = 0;
		z -> siz = 0;
		i -> priv = z;
	}
	return (Ok);
}

static Status
get_zipnfo (char *fname)
{
	char	*ptr;
	Inode	I;
	finode	*i;
	filenam	*f;
	Bool	isdir;

	if (! (zc = setup_zipper (fname)))
		return (Fail);
	if (zc -> z_get) {
		memset (& I, 0, sizeof (I));
		while (ptr = (*zc -> z_get) (& I, & isdir))
			if ((! (f = add_fullpath (root, ptr, isdir))) || (alloc_zipnfo (f -> i, ptr) == Fail))
				return (Fail);
			else if (i = get_finode (f -> i)) {
				i -> ino.mode = I.mode;
				i -> ino.uid = I.uid;
				i -> ino.gid = I.gid;
				i -> ino.size = I.size;
				i -> ino.atime = I.atime;
				i -> ino.mtime = I.mtime;
				i -> ino.ctime = I.ctime;
				set_filesize (i -> nr, i -> ino.size);
				memset (& I, 0, sizeof (I));
			}
	}
	return (Ok);
}

static void
write_zipnfo (zipnfo *z)
{
	if (zc -> z_write)
		(*zc -> z_write) (z);
}

static void
read_zipnfo (zipnfo *z)
{
	if (zc -> z_read)
		(*zc -> z_read) (z);
}

static void
delete_zipnfo (zipnfo *z)
{
	if (zc -> z_delete)
		(*zc -> z_delete) (z);
}

static Status
do_init (int ac, char **av)
{
	if (ac != 1) {
		fprintf (stderr, "Need archive filename.\n");
		return (Fail);
	}
	if (! (root = make_root ()))
		return (Fail);
	if ((alloc_zipnfo (root -> i, ".") == Fail) || (alloc_zipnfo (root -> next -> i, "..") == Fail))
		return (Fail);
	return (get_zipnfo (av[0]));
}

static Status
do_deinit (void)
{
	return (Ok);
}

static ulong
do_create (ulong dir, long mode, long rdev, Permission *p, char *fname)
{
	finode	*base, *i;
	ulong	handle;
	zipnfo	*zb, *zh;
	char	*fn;

	if (! (base = get_finode (dir)))
		return (0);
	if (! (handle = def_create (dir, mode, rdev, p, fname)))
		return (0);
	if ((i = get_finode (handle)) && (zb = base -> priv)) {
		if (fn = malloc (strlen (zb -> path) + strlen (fname) + 4)) {
			sprintf (fn, "%s/%s", zb -> path, fname);
			alloc_zipnfo (i -> nr, fn);
			free (fn);
			zh = i -> priv;
			zh -> dirty = True;
			zb -> dirty = True;
		}
	}
	return (handle);
}

static Status
do_close (ulong handle, ulong ctok)
{
	finode	*i;
	zipnfo	*z;

	if (def_close (handle, ctok) == Fail)
		return (Fail);
	if ((i = get_finode (handle)) && (! i -> linked) && (z = i -> priv)) {
		if (z -> dirty)
			write_zipnfo (z);
		z -> dirty = False;
		if (! i -> ino.nlink) {
			if (z -> cont)
				free (z -> cont);
			free (z -> path);
			free (z);
			i -> priv = NULL;
		}
	}
	return (Ok);
}

static TBuffer *
do_read (ulong handle, off_t off, off_t size, ulong ctok)
{
	static TBuffer	tb;
	finode		*i;
	zipnfo		*z;

	if ((! (i = get_finode (handle))) || (! (z = i -> priv)))
		return (NULL);
	if (off + size > z -> cnt)
		size = z -> cnt - off;
	tb.size = (ulong) size;
	tb.ptr = z -> cont + off;
	return (& tb);
}

static off_t
do_write (ulong handle, off_t off, TBuffer *tb, ulong ctok)
{
	finode		*i;
	zipnfo		*z;

	if ((! (i = get_finode (handle))) || (! (z = i -> priv)))
		return (0);
	if (off + tb -> size >= z -> siz) {
		z -> siz = off + tb -> size + 8192;
		if (! (z -> cont = (unchar *) realloc (z -> cont, (z -> siz + 16) * sizeof (unchar)))) {
			z -> siz = 0;
			z -> cnt = 0;
			errno = ENOMEM;
			return (0);
		}
	}
	memcpy (z -> cont + off, tb -> ptr, tb -> size);
	if (off + tb -> size > z -> cnt) {
		z -> cnt = off + tb -> size;
		set_filesize (i -> nr, z -> cnt);
	}
	return (tb -> size);
}

static Status
do_truncate (ulong handle, off_t size)
{
	finode	*i;
	zipnfo	*z;

	if ((! (i = get_finode (handle))) || (! (z = i -> priv)))
		return (Fail);
	if (size >= z -> siz) {
		z -> siz = size + 8192;
		if (! (z -> cont = (unchar *) realloc (z -> cont, (z -> siz + 16) * sizeof (unchar)))) {
			z -> siz = 0;
			z -> cnt = 0;
			return (Fail);
		}
	}
	z -> cnt = size;
	return (Ok);
}

static Status
do_unlink (ulong dir, char *fname)
{
	Status	ret;
	finode	*i;
	zipnfo	*z;
	filenam	*f;

	if (! (i = get_finode (dir)))
		return (Fail);
	for (f = i -> dir; f; f = f -> next)
		if (! strcmp (f -> fname, fname))
			break;
	if (! f)
		return (Fail);
	i = get_finode (f -> i);
	ret = def_unlink (dir, fname);
	if (! i -> ino.nlink) {
		delete_zipnfo (z);
		if ((! i -> linked) && (z = i -> priv)) {
			if (z -> cont)
				free (z -> cont);
			free (z -> path);
			free (z);
			i -> priv = NULL;
		}
	}
	return (ret);
}

static ulong
do_mount (void)
{
	return (root -> i);
}

static Status
do_iwrite (ulong handle, Inode *ino)
{
	finode	*i;
	zipnfo	*z;

	if (def_iwrite (handle, ino) == Fail)
		return (Fail);
	if (i = get_finode (handle))
		if (z = i -> priv)
			z -> dirty = True;
	return (Ok);
}

static ulong
do_open (ulong handle, Permission *p)
{
	finode	*i;
	zipnfo	*z;

	if (! (i = get_finode (handle)))
		return (0);
	if ((z = i -> priv) && (! z -> cont))
		read_zipnfo (z);
	return (def_open (handle, p));
}

static fscalls	calls = {
	def_errorlog,		/* errorlog */
	do_init,		/* init */
	do_deinit,		/* deinit */
	do_create,		/* create */
	def_lookup,		/* lookup */
	do_close,		/* close */
	do_read,		/* read */
	do_write,		/* write */
	do_truncate,		/* truncate */
	def_fsync,		/* fsync */
	def_readdir,		/* readdir */
	def_link,		/* link */
	do_unlink,		/* unlink */
	def_symlink,		/* symlink */
	def_readlink,		/* readlink */
	def_followlink,		/* followlink */
	do_mount,		/* mount */
	NULL,			/* umount */
	def_iread,		/* iread */
	do_iwrite,		/* iwrite */
	def_statfs,		/* statfs */
	def_iput,		/* iput */
	do_open,		/* open */
	def_permission,		/* permission */
	def_rename,		/* rename */
	def_multireaddir,	/* multireadddir */
	def_notify_change	/* notify_change */
};

void
inform_user (UserInfo ui, void *ptr)
{
}

int
main (int argc, char **argv)
{
# if	0 
	{
		Permission	p;

		do_init (--argc, ++argv);
		do_create (2, 0100600, 0, & p, "lall");
		do_create (2, 0100600, 0, & p, "laber");
		exit (0);
	}
# endif
	return (userfs (argc, argv, & calls));
}
