# include	<unistd.h>
# include	<malloc.h>
# include	<sys/types.h>
# include	"oskfs.h"

typedef struct _dcache {
	ulong	lsn;		/* the logical sector number		*/
	ulong	*sec;		/* a single sector			*/
	struct _dcache
		*flist,		/* in freelist				*/
		*hash,		/* in current hashlist			*/
		*next,		/* in the all-over list			*/
		*prev;		/* previous in all-over list		*/
}	dcache;

typedef struct {
	ulong	hsh;		/* hashvalue				*/
	ulong	count;		/* # of all sectors in cache		*/
	dcache	**hash;		/* the hashtable			*/
	dcache	*flist;		/* the freelist				*/
	dcache	*base;		/* the all-over list anchor		*/
}	cache;

static cache	cch;		/* the sector cache			*/

int
read_cache (register ulong lsn, ulong off, unchar *ptr, register int cnt)
{
	register dcache	*tmp, *t2, *prev;
	register ulong	hashval;
	register int	got;
	register ulong	toread;

	got = 0;
	while (got < cnt)
		if (! cch.count) {
			if (lseek (dfd, lsn * secsize + off, SEEK_SET) < 0)
				return (-1);
			if ((got = read (dfd, ptr, cnt)) != cnt)
				break;
		} else {
			while (off > secsize) {
				++lsn;
				off -= secsize;
			}
			if ((toread = cnt - got) + off > secsize)
				toread = secsize - off;
			/*	Look first if we have this sector cached
			 */
			hashval = lsn % cch.hsh;
			tmp = cch.hash[hashval];
			while (tmp)
				if (tmp -> lsn == lsn)
					break;
				else
					tmp = tmp -> hash;
			if (! tmp) {
				/*	Now try to find a sector in the freelist
				 */
				if (tmp = cch.flist) {
					cch.flist = tmp -> flist;
					tmp -> flist = NULL;
				} else {
					/*	Last discard the last used sector and reuse it
					 */
					tmp = cch.base -> prev;
					prev = NULL;
					for (t2 = cch.hash[tmp -> lsn % cch.hsh]; t2; t2 = t2 -> hash)
						if (t2 == tmp)
							break;
						else
							prev = t2;
					if (! t2)
						sleep (1);
					if (prev)
						prev -> hash = t2 -> hash;
					else
						cch.hash[tmp -> lsn % cch.hsh] = t2 -> hash;
					t2 -> hash = NULL;
				}
				tmp -> lsn = lsn;
				if ((lseek (dfd, tmp -> lsn * secsize, SEEK_SET) < 0) || (read (dfd, tmp -> sec, secsize) != secsize)) {
					tmp -> lsn = 0;
					tmp -> flist = cch.flist;
					cch.flist = tmp;
					return (-1);
				}
				tmp -> hash = cch.hash[hashval];
				cch.hash[hashval] = tmp;
			}
			if (tmp != cch.base) {
				tmp -> next -> prev = tmp -> prev;
				tmp -> prev -> next = tmp -> next;
				tmp -> next = cch.base;
				tmp -> prev = cch.base -> prev;
				tmp -> next -> prev = tmp;
				tmp -> prev -> next = tmp;
				cch.base = tmp;
			}
			memcpy (ptr, tmp -> sec + off, toread);
			off = 0;
			++lsn;
			got += toread;
			ptr += toread;
		}
	return (got);
}

Status
init_cache (int tblsize)
{
	dcache	*prev, *tmp;
	int	n;

	if (tblsize) {
		cch.hsh = tblsize;
		cch.count = cch.hsh * 4;
		if (! (cch.hash = (dcache **) malloc (cch.hsh * sizeof (dcache *))))
			return (Fail);
		prev = NULL;
		for (n = 0; n < cch.count; ++n) {
			if (! (tmp = (dcache *) malloc (sizeof (dcache))))
				return (Fail);
			tmp -> lsn = 0;
			if (! (tmp -> sec = malloc (secsize)))
				return (Fail);
			tmp -> flist = NULL;
			tmp -> hash = NULL;
			tmp -> next = NULL;
			if (prev) {
				tmp -> prev = prev;
				prev -> next = tmp;
				prev -> flist = tmp;
			} else {
				tmp -> prev = NULL;
				cch.flist = tmp;
				cch.base = tmp;
			}
			prev = tmp;
		}
		cch.base -> prev = tmp;
		tmp -> next = cch.base;
	} else {
		cch.hsh = 0;
		cch.count = 0;
		cch.hash = NULL;
		cch.flist = NULL;
		cch.base = NULL;
	}
	return (Ok);
}
