// -*- C++ -*-

// Basic communications

// (C) Copyright 1993, 1994 Jeremy Fitzhardinge <jeremy@sw.oz.au>
// This code is distributed under the terms of the
// GNU General Public Licence.  See COPYING for more details.

#pragma implementation

#include <Filesystem.h>
#include <Comm.h>
#include <io.h>
#include <stdio.h>

Comm::Comm(Filesystem &fs, unsigned int to, unsigned int from)
     :CommBase(fs, to, from)
{
	req = new Comm_doreq(this, filesys);
	addDispatch(from, req);
}

Comm_doreq::Comm_doreq(const CommBase *comm, Filesystem &fs)
	   : DispToKern(comm), filesys(fs)
{
}

int
Comm_doreq::dispatch(int fd, int)
{
	up_preamble pre;
	size_t presize = sizeof_up_preamble(&pre);
	Uchar hbuf[256];
	Uchar buf[4096];
	int ret;

	ret = fullread(fd, hbuf, presize);
	if (ret == 0)
		return 0;
	
	if (ret != presize)
	{
		fprintf(stderr, "Comm_doreq::dispatch failed to get whole header (%d wanted, %d got)\n",
			presize, ret);
		return -1;
	}

	upp_repl repl;
	size_t replsize = sizeof_upp_repl(&repl);

	assert(sizeof(hbuf) > replsize);
		
	decode_up_preamble(&pre, hbuf);
		
	if (pre.size != 0 && (ret = fullread(fd, buf, pre.size)) != pre.size)
	{
		fprintf(stderr, "Comm_doreq::dispatch: failed to get whole body (%ld wanted, %d got)\n",
			pre.size, ret);
		return -1;
	}
	
	ret = filesys.DoOp(pre, repl, buf);

	if (!ret)
		return -1;

#ifdef DEBUG
	if (repl.errno != 0)
	{
		fprintf(stderr, "Request %d failing with %d %s\n",
			pre.op, repl.errno, strerror(repl.errno));
	}
#endif
		
	encode_upp_repl(&repl, hbuf);

	if (fullwrite(tokern, hbuf, replsize) != replsize)
		return -1;
		
	if (repl.size != 0 && fullwrite(tokern, buf, repl.size) != repl.size)
		return -1;

	return 1;
}
