// -*- C++ -*-
//
// Class for kernel to process communications
//
// This program is distributed under the terms of the
// Free Software Foundation General Public Licence.
// Copyright Jeremy Fitzhardinge <jeremy@sw.oz.au> 1993

#ifndef __COMMBASE_H_SEEN__
#define __COMMBASE_H_SEEN__

#include <sys/types.h>
#include <sys/time.h>

#pragma interface

class Filesystem;
class DispatchFD;
class DispToKern;

// Flags for selecting type of select
#define DISP_R	1
#define DISP_W	2
#define DISP_E	4

// Number select dispatch priorities
#define NDISP_PRI 4

// Filesystem communications
class CommBase
{
	friend Filesystem;
	friend DispToKern;

	// List of fd dispatch handers
	struct dispq_t
	{
		struct disp_fd *h, *t;
	} dispqs[NDISP_PRI];
	int dispatches;
	
	// fd to kernel
	unsigned int	tokern;

protected:
	// The filesystem we're part of.
	Filesystem &filesys;
	// Set up kernel fd dispatch handler
	DispatchFD *req;
	
public:
	CommBase(Filesystem &, unsigned int to, unsigned int from);
	virtual ~CommBase();

	struct disp_fd *addDispatch(int fd, DispatchFD *dfd, int what=DISP_R, int pri = 2);
	void delDispatch(struct disp_fd *);

	// This doesn't return until there is an IO error or EOF
	int Run();

	// Defer a reply for a child process to do
	int DeferRepl();

	// Close all fds we have open, and remove handlers
	// all==1 means even the kernel connection
	void CloseFDs(int all = 0);
};

// Dispatch class for FDs
class DispatchFD
{
public:
	virtual int dispatch(int fd, int what) = 0;
	virtual ~DispatchFD();
};

// A dispatcher which sends needs to send to the kernel
class DispToKern : public DispatchFD
{
protected:
	int tokern;
public:
	DispToKern(const CommBase *);
};

#endif /* __COMMBASE_H_SEEN__ */
