// -*- C++ -*-

/* Copyright (C) 1993 Tuomas J. Lukka, based on Jeremy Fitzhardinge's work */
// Further modified by Jeremy as a general Directory Inode.
// This program is distributed under the terms of the
// Free Software Foundation General Public Licence.
// See COPYING for details

// A directory inode

#ifndef __DIRINODE_H_SEEN__
#define __DIRINODE_H_SEEN__
	
#include <SimpleInode.h>

#include <sys/types.h>
#include <String.h>

#pragma interface

class Filesystem;
class DirInode;

class DirEntry
{
	friend	DirInode;
	String	name;
	Inode 	*ino; 		// NULL if none

	DirEntry *prev, *next;
	
public:
	DirEntry(const String, Inode *);
	DirEntry()			{ ino = NULL; }
	~DirEntry();
	
	const String getname()	const	{ return name; }
	Inode *geti() const		{ return ino; }
};

class DirInode : public SimpleInode
{
private:
	int	max_multird;
	DirEntry *entries, *end;

protected:
	Inode *parent;
	
public:
	DirInode(Filesystem &fs, Handle h, Inode *parent, int mm = 100);
	~DirInode();
	
	// Userfs operations
	int do_lookup(const up_preamble &, upp_repl &,
		      const upp_lookup_s &, upp_lookup_r &);
	int do_readdir(const up_preamble &, upp_repl &,
		       const upp_readdir_s &, upp_readdir_r &);
	int do_multireaddir(const up_preamble &, upp_repl &,
			    const upp_multireaddir_s &, upp_multireaddir_r &);
	int do_rename(const up_preamble &, upp_repl &,
			      const upp_rename_s &);
	int do_unlink(const up_preamble &, upp_repl &,
		      const upp_unlink_s &arg);
	int do_link(const up_preamble &, upp_repl &,
		    const upp_link_s &);
	int do_read(const up_preamble &, upp_repl &,
		    const upp_read_s &, upp_read_r &);
	int do_write(const up_preamble &, upp_repl &,
		     const upp_write_s &, upp_write_r &);

	// Inode operations
	int link(const String &, Inode *);
	DirEntry *lookup(const String &) const;
	int unlink(const String &);
	DirEntry *scan(int &pos) const;
	DirEntry *scan(DirEntry *&pos) const;
	int link(const char *n, int l, Inode *i)	{ return link(String(n, l), i); }
	int unlink(const char *n, int l)		{ return unlink(String(n, l)); }
};
#endif
