// -*- C++ -*-

// Simple Inode operations

#pragma implementation

#include <SimpleInode.h>
#include <sys/types.h>
#include <sys/stat.h>

#define __KERNEL__	/* XXX Hack to get definitions needed */
#include <linux/fs.h>
#undef __KERNEL__

SimpleInode::SimpleInode(Filesystem &fs, Handle h)
	:Inode(fs, h)
{
	uid = 0;;
	gid = 0;
	mode = S_IFREG;
	nlink = 0;
	size = 0;
	rdev = 0;
	atime = ctime = mtime = 0;
}

int
SimpleInode::do_iread(const up_preamble &, upp_repl &,
		      const upp_iread_s &arg, upp_iread_r &ret)
{
	update();
	ret.handle = arg.handle;
	iread(ret.ino);
	return 0;
}

void
SimpleInode::iread(up_inode &ino)
{
	ino.uid = uid;
	ino.gid = gid;
	ino.mode = mode;
	ino.nlink = nlink;
	ino.mtime = mtime;
	ino.ctime = ctime;
	ino.atime = atime;
	ino.size = size;
	ino.rdev = rdev;
	ino.blocks = size / 1024;
	ino.blksize = 1024;
}

int
SimpleInode::do_iwrite(const up_preamble &, upp_repl &,
		       const upp_iwrite_s &arg)
{
	iwrite(arg.ino);
	return 0;
}

void
SimpleInode::iwrite(const up_inode &ino)
{
	uid = ino.uid;
	gid = ino.gid;
	mode = ino.mode;
	mtime = ino.mtime;
	ctime = ino.ctime;
	atime = ino.atime;
	size = ino.size;
	rdev = ino.rdev;
}

int
SimpleInode::do_notify_change(const up_preamble &, upp_repl &,
			     const upp_notify_change_s &arg)
{
	if (arg.iattr.ia_valid & ATTR_MODE)
		mode = arg.iattr.ia_mode;
	if (arg.iattr.ia_valid & ATTR_UID)
		uid = arg.iattr.ia_uid;
	if (arg.iattr.ia_valid & ATTR_GID)
		gid = arg.iattr.ia_gid;
	if (arg.iattr.ia_valid & ATTR_SIZE)
		size = arg.iattr.ia_size;
	if (arg.iattr.ia_valid & ATTR_ATIME)
		atime = arg.iattr.ia_atime;
	if (arg.iattr.ia_valid & ATTR_CTIME)
		ctime = arg.iattr.ia_ctime;
	if (arg.iattr.ia_valid & ATTR_MTIME)
		mtime = arg.iattr.ia_mtime;
	return 0;
}

int
SimpleInode::do_open(const up_preamble &, upp_repl &,
		     const upp_open_s &, upp_open_r &)
{
	return 0;
}

int
SimpleInode::do_close(const up_preamble &, upp_repl &,
		      const upp_close_s &)
{
	return 0;
}

static int
in_group_p(const up_cred &cr, gid_t gid)
{
	if (cr.egid == gid)
		return 1;
	
	for(int i = 0; i < cr.groups.nelem; i++)
		if (gid == cr.groups.elems[i])
			return 1;
	return 0;
}

int
SimpleInode::do_permission(const up_preamble &, upp_repl &,
			   const upp_permission_s &arg)
{
	const up_cred &cr = arg.cred;
	int mode = SimpleInode::mode;
	int mask = arg.mask;
	
	if (cr.euid == uid)
		mode >>= 6;
	else if (in_group_p(cr, gid))
		mode >>= 3;
	if (((mode & mask & 0007) == mask) || cr.euid == 0)
		return 0;
	return EPERM;
}

int
SimpleInode::do_iput(const up_preamble &, upp_repl &,
		     const upp_iput_s &)
{
	return 0;
}
