/*
 * Function: time()
 *
 * Description:
 *    Interface procedure to the time function. The time function for
 *    the system takes no parameters. It simply returns the time in
 *    the function result.
 *
 *    This interface procedure will take an option argument and update
 *    the non-null argument with the time value.
 *
 *    The iBCS standard defines that the system call interface must not
 *    take a parameter. It further states that the optional storage of a
 *    parameter is the responsibility of the runtime package. So, since
 *    the original time.S function was lifted from the Linux package which
 *    took the optional parameter, this routine provides the translation
 *    phase between the system call and the C runtime package.
 *
 *    It is not difficult. It is just more difficult to do this in assembly.
 */

/* This is the system call vector. */
extern unsigned long __time (void);

unsigned long time (unsigned long *ptr)
    {
    unsigned long time_result = __time();

    if ((long) time_result >= 0 && ptr != (unsigned long *) 0)
        {
	*ptr = time_result;
        }
    return time_result;
    }


#ifdef ELF_LIBRARY
__asm__(".globl _time; _time = time");
#endif

