/*
 * Copyright (C) 1992  Board of Regents of the University of Wisconsin
 * on behalf of the Department of Electrical Engineering and Computer
 * Science, University of Wisconsin-Milwaukee, Milwaukee, WI 53201.
 *
 * No Warranty, expressed or implied, comes with this software.
 * This program is free software for private use by individuals and
 * not-for-profit organizations.  Use of of this software for commercial
 * applications or by commercial entities is prohibited.  You can 
 * redistribute it and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation and
 * and these conditions; either version 2 of the License, or 
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * The programs in this directory were developed by software engineering
 * teams as part of the course "Introduction to Software Engineering"
 * under the supervision of Professor G. Davida.
 *
 *
 * Please send all changes, enhancements, and other comments about this
 * software to
 *
 *     		soft-eng@cs.uwm.edu
 *
 *			or
 *		
 *		Software Engineering Coordinator
 *		Computer Science
 *   		Department of EECS
 *		University of Wisconsin - Milwaukee
 *		Milwaukee, WI  53201
 *		414-229-4677
 */

/**  Read in the configuration file which contains entries like
 **  source destination command
 **
 **  Convert them to lower case and save them in the convertdata list
 **/

#include <stdio.h>
#include <string.h>
#include "config.h"
#include "infostruct.h"

extern struct filedatastruct filedata;
extern struct convertdatastruct convertdata[];
extern strtolower(char *);
 
void getarg();

static int count = 1;  /* Leave position 0 blank */

void get_convert_data()
{
     FILE *fd;
     char *filename;
     int count = 0;	/** Loop for all the filenames **/
     int readone = 0;   /**  Check to see if we at least read in one config **/

     filename = filedata.configfile[count];
     for (; filename != NULL; filename = filedata.configfile[++count]){
         fd = fopen(filename, "r");
         if (fd == NULL) {
#ifdef DEBUG
	     fprintf(stderr, "%s ", filename);
	     perror("");
#endif
	     continue;
         }
         read_in(fd);
	 readone++;
         fclose(fd);
     }
     if (!readone) {
	 fprintf(stderr, "No configuration files found!!\n");
	 exit(INTERNALERROR);
     }
}

read_in(fd)
FILE *fd;
{
     char line[100], *lineptr;
     char string[80];

     while (fgets(line, sizeof(line), fd) != NULL) {
	lineptr = line;

		/**  Pull out the source part **/
	getarg(&lineptr, string);
	if (string[0] == '\0')
	    continue;

       	convertdata[count].source = (char *) malloc( strlen(string) + 2 );  
	strcpy(convertdata[count].source, string);
	strtolower(convertdata[count].source);
	
		/** Pull out the destination part **/
	getarg(&lineptr, string);
	if (string[0] == '\0') {
	    free(convertdata[count].source);
	    continue;
  	}
	convertdata[count].destination = (char *) malloc( strlen(string) + 2);
	strcpy(convertdata[count].destination, string);
	strtolower(convertdata[count].destination);

		/** Check to see if it is already in there.
		 ** Note it must match exactly, so
		 ** "*dvi*" will not match "dvi"
		 **/
	if (checkifthere(count) == TRUE) {
	    free(convertdata[count].source);
	    free(convertdata[count].destination);
	    continue;
    	}

		/** Pull out the command to run **/
	getarg(&lineptr, string);
	if ( string[0] == '\0' ) {
	    convertdata[count].command = NULL;
   	} else {
	    convertdata[count].command = (char *) malloc( strlen(string) + 2);
	    strcpy(convertdata[count].command, string);
	}


#ifdef DEBUG
/*        printf("For %s --> %s == %s\n", convertdata[count].source, 
	       convertdata[count].destination, convertdata[count].command);    
*/
#endif
	count++;
     }
     convertdata[count].source = NULL;
}

void getarg(line, string)
char *line[], *string;
{
    char *p;
    int position = 0;

    p = *line;

    if (!p || *p == '#') {
	string[0] = '\0';
	return;
    }
    
    while ( (*p == '\t') || (*p == ' ') )
	p++;

    if (*p == '"') {
	p++;
	while (*p != '"') {
	    string[position] = *p;
	    p++;
	    position++;

	    if (p[0] == '\\' && p[1] == '"') {
		/* next char is start of an escaped quote char */
		string[position++] = '"';
		p += 2;
	    }
 	}
	p++;  /* Move past the " */
    } else {
	while ( (*p != ' ') && (*p != '\t') ){
	    string[position] = *p;
	    p++;
	    position++;
	}
    }
    string[position] = '\0';
    *line = p;
}

int checkifthere(position)
int position;
{
    int count;

    for (count = 1; count < position; count++) {
	if ( !strcmp(convertdata[count].source, 
		     convertdata[position].source) 
	     &&
             !strcmp(convertdata[count].destination, 
		     convertdata[position].destination) ) {
  	   
	   return(TRUE);
	}

    }
    return(FALSE);
}

