/*
 * Copyright (C) 1992  Board of Regents of the University of Wisconsin
 * on behalf of the Department of Electrical Engineering and Computer
 * Science, University of Wisconsin-Milwaukee, Milwaukee, WI 53201.
 *
 * No Warranty, expressed or implied, comes with this software.
 * This program is free software for private use by individuals and
 * not-for-profit organizations.  Use of of this software for commercial
 * applications or by commercial entities is prohibited.  You can 
 * redistribute it and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation and
 * and these conditions; either version 2 of the License, or 
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * The programs in this directory were developed by software engineering
 * teams as part of the course "Introduction to Software Engineering"
 * under the supervision of Professor G. Davida.
 *
 *
 * Please send all changes, enhancements, and other comments about this
 * software to
 *
 *     		soft-eng@cs.uwm.edu
 *
 *			or
 *		
 *		Software Engineering Coordinator
 *		Computer Science
 *   		Department of EECS
 *		University of Wisconsin - Milwaukee
 *		Milwaukee, WI  53201
 *		414-229-4677
 */

/*  Error codes, which are returned  */

#define NOOUTTYPE       1
#define RWERROR         2
#define NOWAYTOCONVERT  3
#define CONVERSIONERROR 4
#define INTERNALERROR   5

#define TRUE     1
#define FALSE    0

/*
 * Tokens used in the config file which hold where the input and
 * and output filenames are to be substituted
 */
#define INTOK  "$IN"
#define OUTTOK "$OUT"

/*  Number of conversions we will do to get the answer  */
#define MAXCONV    20

/*  Number of spots which can hold configuration source->dest info  */
#define MAXCONVTABLE 300

struct filedatastruct 
{
    char  *real_in_file;
    char  *in_file;
    char  *in_type;
    char  *real_out_file;
    char  *out_file;
    char  *out_type;
    char  *configfile[20];
    int   convert_list[MAXCONV];
};

struct convertdatastruct
{
    char *source;
    char *destination;
    char *command;
};

extern int debug;
