/*
 * Copyright (C) 1992  Board of Regents of the University of Wisconsin
 * on behalf of the Department of Electrical Engineering and Computer
 * Science, University of Wisconsin-Milwaukee, Milwaukee, WI 53201.
 *
 * No Warranty, expressed or implied, comes with this software.
 * This program is free software for private use by individuals and
 * not-for-profit organizations.  Use of of this software for commercial
 * applications or by commercial entities is prohibited.  You can 
 * redistribute it and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation and
 * and these conditions; either version 2 of the License, or 
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * The programs in this directory were developed by software engineering
 * teams as part of the course "Introduction to Software Engineering"
 * under the supervision of Professor G. Davida.
 *
 *
 * Please send all changes, enhancements, and other comments about this
 * software to
 *
 *     		soft-eng@cs.uwm.edu
 *
 *			or
 *		
 *		Software Engineering Coordinator
 *		Computer Science
 *   		Department of EECS
 *		University of Wisconsin - Milwaukee
 *		Milwaukee, WI  53201
 *		414-229-4677
 */

#include <stdio.h>
#include <sys/types.h>
#include <pwd.h>
#include <string.h>
#include <limits.h>
#include <unistd.h>
#include <signal.h>

#include "config.h"
#include "infostruct.h"
#include "version.h"

	/* Hold's filename and conversion wanted */
struct filedatastruct   filedata;   

	/* The different ways to get from src->dst*/
struct convertdatastruct convertdata[MAXCONVTABLE];

extern char * matchintype();
void cleanup();

int debug = 0;

main(argc,argv)
int argc;
char *argv[];
{
        char *tmpstring;
	int ch;
	FILE *fdin, *fdout;
	int option;
	extern int optind, opterr;
	extern char *optarg;
	int configpos = 0;
	int useglobalconfig = 1; /** Initially as true  **/
	int useusersconfig  = 1; /** Initially set as true **/

	initfiledata();

	while ((option = getopt(argc, argv, "i:I:o:O:c:sud")) != EOF)
	      switch(option) {

	/**  Copy the input filename and type if given  **/
		  case 'i':
			  filedata.real_in_file = optarg;
			  break;
		  case 'I':
			  filedata.in_type = optarg;
			  break;

	/**  Copy the output filename and type if given **/
 		  case 'o':
			  filedata.real_out_file = optarg;
			  break;
		  case 'O':
			  filedata.out_type = optarg;
			  break;

	/**  Config files to use **/
		  case 'c':
			  filedata.configfile[configpos++] = optarg;
			  break;

	/**  -s means dont' use the global config file **/
		  case 's':
			  useglobalconfig--;	
			  break;
	/**  -u means don't use the users config file **/
		  case 'u':
			  useusersconfig--;
			  break;

		  case 'd':
			  debug = 1;
			  break;
	      } /* switch */
	/* while */

	/*  Use any supplied config files, then use global one,
	 *  Then use the one in users home directory
	 */
	if (useglobalconfig) {
	   filedata.configfile[configpos] = (char *) malloc (sizeof(FCONFIG)+2);
   	   strcpy(filedata.configfile[configpos++], FCONFIG);
	}

	/*  Also read the users config file in their home directory */

	if (useusersconfig) {
	   struct passwd *pw;
	   pw = getpwuid( getuid() );
	   filedata.configfile[configpos] = (char *) 
			malloc( strlen(pw->pw_dir) + sizeof(USERCONFIG) + 3 );
	   strcpy(filedata.configfile[configpos], pw->pw_dir);
	   strcat(filedata.configfile[configpos++], USERCONFIG);
	}

	filedata.configfile[configpos] = NULL;

	/**  Catch any control c signals from the user
	 **  So that we can remove any scratch/junk files
	 **/

	signal(SIGINT, cleanup);

	    /*  check to make sure we have an output type,
	     *  I suppose we could check the suffix on the name... 
	     */

	if (outtype() == FALSE) {
	   print_help();
	   fprintf(stderr, "\nSorry, unknown output type-%s.\n",
	  	 filedata.out_type == NULL ? "" : filedata.out_type);
	   exit(NOOUTTYPE);
	}

		/* Figure out what the input type is. */

	       /*  Take the input file and save it in a spot where
		*  We can keep looking at it..
		*/
	if (filedata.real_in_file != NULL) {

	       /*  If user supplied input file, then we can read that */
	   if ((fdin = fopen(filedata.real_in_file, "r")) == NULL) {
		fprintf(stderr, "Couldn't open input file\n");
		perror("");
		exit(RWERROR);
	   }
        } else 
	   fdin = stdin;

		/* Create a unique filename in /tmp which we can
		 * use for the programs */
        tmpstring = tmpnam(NULL);
        filedata.in_file = (char *) malloc( strlen(tmpstring) + 5);
        strcpy(filedata.in_file, tmpstring);

		/*  Copy the stdin or file, to the /tmp file */
        if ((fdout = fopen(filedata.in_file, "w")) == NULL) {
	      fprintf(stderr, "Couldn't open temp file\n");
	      exit(RWERROR);
        }
        while((ch = getc(fdin)) != EOF)
	      fputc( (char) ch, fdout);

	fclose(fdout);

        /**  Now that we have the input file as a temp file
 	  *  Figure out what type the input is 
 	  *  Calling fident/file if necessary
	 **/
	intype();

/*  Load in the conversions from the config file */

	get_convert_data();

	filedata.in_type = matchintype(filedata.in_type);

	if (debug)
	    printfiledata();

	   /* Now that we have the correct input type and output,
	    * then do the conversion.
	    */
	if( !figure_convert(filedata.in_type, filedata.out_type, 0) ) {
	    fprintf(stderr, "Sorry I don't know how to convert %s --> %s\n",
		  filedata.in_type, filedata.out_type);
	    exit(NOWAYTOCONVERT);
 	}

	if ( convert(debug) != TRUE ) {
	    exit(CONVERSIONERROR);
	}

        if ( out2file() ) {
	    exit(RWERROR);
 	}

	exit(0);	/*  Everything went ok */
}

/*  If the output is stdout then send to stdout, if
 *  output was a file, then save data to that file 
 */
int out2file()
{
    char string[300];
    int retval;

    if (filedata.real_out_file != NULL) {
	/*  If the user supplied a filename, move the last
	 *  output file name.
	 *  The last output file is actualy the input file */
	strcpy(string, "mv -f ");
	strcat(string, filedata.in_file);
	strcat(string, " ");
	strcat(string, filedata.real_out_file);
	retval = system(string);
    } else {
	/*  If the user wanted it as stdout */
	strcpy(string, "cat ");
	strcat(string, filedata.in_file);
	retval = system(string);
    }
    /* Remove the temp file */
    unlink(filedata.in_file);

    return(retval);
}

/** Initiaze the structure which holds data about the input and output
 ** filenames and types.  **/

initfiledata()
{
	int loop;

	filedata.real_in_file = NULL;
	filedata.in_file = NULL;
	filedata.in_type = NULL;
	filedata.real_out_file = NULL;
	filedata.out_file = NULL;
	filedata.out_type = NULL;
	for(loop = 0; loop < MAXCONV; loop++) 
	   filedata.convert_list[loop] = NULL;

   	convertdata[0].source = NULL; /*  Not used */
   	convertdata[1].source = NULL; /*  End of array */

}

void cleanup()
{
    if (filedata.in_file != NULL) 
       unlink(filedata.in_file);

    if (filedata.out_file != NULL) 
       unlink(filedata.out_file);
    
    fprintf(stderr, "Program aborted by user\n");
    exit(INTERNALERROR);
}

/**  Print out some info about what we know about the conversion **/

printfiledata()
{
	fprintf(stderr, "real in name %s\n", 
		filedata.real_in_file ? filedata.real_in_file : "stdin");
	fprintf(stderr, "in name %s\n",      
		filedata.in_file ? filedata.in_file : "stdin");

	fprintf(stderr, "in type %s\n",      filedata.in_type);
	fprintf(stderr, "\n");

	fprintf(stderr, "real out name %s\n",
		filedata.real_out_file ? filedata.real_out_file : "stdout");
	fprintf(stderr, "out name %s\n",    
		filedata.out_file ? filedata.out_file : "stdout");

	fprintf(stderr, "out type %s\n",     filedata.out_type);
	fprintf(stderr, "\n");
}

print_help()
{
   fprintf(stderr, "\n");
   fprintf(stderr, "%s\n", VERSION);
   fprintf(stderr, "Options:\n");

   fprintf(stderr, "\t [-I in_format ] [-i in_file ] : If no -i stdin used\n");
   fprintf(stderr, "\t [-O out_format] [-o out_file] : If no -O format guessed from filename\n");
   fprintf(stderr, "\t [-c configfile] [-c configfile] ....\n");
   fprintf(stderr, "\t [-s] [-u] : -s no global config file : -u no user config file\n");
   fprintf(stderr, "\n");
   fprintf(stderr, "     Some of the valid input formats are\n");
   fprintf(stderr, "\t ascii     ps          pascal       fortran    dvi\n");
   fprintf(stderr, "\t pcl, gif, pnm, pbm, pgm, ppm, xwd : graphic formats\n");

   fprintf(stderr, "\n");

   fprintf(stderr, "     Some of the valid output formats\n");
   fprintf(stderr, "\t ascii     ps          lj           ppm        pgm         pbm\n");
   fprintf(stderr, "\t X11       cdeskjet    cdjcolor     cdjmono    deskjet     dfaxhigh\n");
   fprintf(stderr, "\t dfaxlow   djet500     djet500c     epson      epson9high  epsonc\n");
   fprintf(stderr, "\t laserjet  la50        la75         lbp8       ln03        lj250\n");
   fprintf(stderr, "\t ljet2p    ljet3       ljetplus     necp6      paintjet    pjetx1\n");
   fprintf(stderr, "\t r4081     tek4696     bit          gifmono    gif8        pcxmono\n");
   fprintf(stderr, "\t pcx16     pcx256      pbmraw       pgmraw     ppmraw\n");

}
