.ig
$Header: 04.t,v 1.1 88/05/21 18:39:37 papowell Locked $
$log$
..
.LG
.NH 1
Printcap and PLP Operations
.SM
.PP
The entries in the printcap file or files are used to define and control
the actions of PLP.
Each host machine must have at least one printcap file that is used to specify
the spool queues that are available on the host, and it (or they) must be
readable by all users to be used by PLP.
Permissions to use a particular spool queue are determined by the
printer permissions file.
The following section discusses the structure of the printcap file,
and the purpose of entries therein.
.NH 2
Printcap Format
.PP
The printcap file format is analogous to that of the
.IR termcap (5)
data base.
Each spool queue has a corresponding printcap entry.
Each entry for a spool queue with multiple servers also has a printcap entry.
Figure 4.1 is an example of a typical printcap entry.
.KF
.DT
.in +1i
.L
.SM
.nf
#	Default line printer is first in printcap entry
#   Clunker Printer in Lind 23
clunker_lind23|clunker:\e
	:lp=/dev/lp:\e
	:st=\et\er\e015:\e
	:mx#20:\e
	:wt:fl@:
.LG
.in -1i
.R
.ce
Figure 4.1  Sample Printcap Entry
.KE
.IP 1). 3
Blank lines and lines which start with a
.L #
are treated as comments and can be used to separate entries.
.IP 2). 3
Each entry starts in column 1,
and is continued across multiple lines by escaping the end of line with a
backslash (\c
.BR \e ).
Fields of the entry are separated by colons (\c
.BR : ).
.IP 3). 3
The first field of an entry is the entry name followed by a
an optional list of aliases.
The entry name and aliases are separated by a bars (\c
.BR | ).
.IP 4). 3
Parameter fields start with a two letter parameter name,
followed by a flag indicating the parameter type.
Parameters can be strings,
integers,
or flags.
String parameters have the form
.L xx=ssss 
(\c
.L ssss
is the string assigned to the parameter),
integer parameters have the form
.L xx#nnnn ,
and flag or boolean parameters use
.L xx
to set and
.L xx@
to clear the flag.
.IP 5). 3
Non-printing characters can be represented in a string by using
the character escape sequences of the C programming language, e.g.
.L \en ,
.L \e015 .
.IP 6). 3
See the
.IR printcap \|(5)
man page for a complete list of printcap variables and their default values.
.PP
Each entry in the printcap file specifies either a remote spool queue,
a local spool queue with a single printer,
a local spool queue with multiple printers,
or a printer for a spool queue with multiple printers.
The information in the printcap entry determines the type of entry and
how the entries in the spool queue are to be handled.

PLP can also include files, in the same way as a preprocessor such as
the C preprocessor; use the
.B include
directive to do this, as follows:
.KF
.DT
.in +1i
.L
.SM
.nf
include /share/spool/plp/pcap/deskjet.remote
.LG
.in -1i
.R
.ce
.KE
You may also use relative paths, in which case the files will be
searched for along a path. This path can be set in the
.L plp.conf file; see the
.IR plp.conf (5)
manual page for more details.
.PP
PLP the printcap format supports the
.B tc
directive, which has the same effect as it does in the termcap
database format. This allows you to inherit the fields from
another printcap entry.
.PP
PLP searches the printcap files for a printcap entry with
a matching printer name or alias. A useful enhancement is that
PLP will first search for the printer name, qualified by the
non-fully-qualified version of the hostname, (ie.
.I printername/hostname ;
for example,
.I hp4m-ps/class ).
This allows you to use a single printcap file for an entire
network of machines, with one special entry for the printer server,
and a general
.I rm
entry for the client machines. See figure 4.2.

.KF
.nf
.in +1i
.DT
.L
.SM
hp4m-ps:cm=HP LaserJet 4Mplus, postscript:\e
	:sd=/var/spool/print/hp-ps:lf=/share/logs/lpd/hp4m/ps:\e
	:rp=hp4m-ps:rm=class.iona.ie:

hp4m-ps/class:cm=HP LaserJet 4Mplus, postscript:\e
	:sd=/var/spool/print/hp-ps:lf=/share/logs/lpd/hp4m/ps:\e
	:lp=|tcp-lp exception 9100:rs:pl#66:pw#80:sh:rw:mx#0:
.LG
.R
.in -1i
.ce
Figure 4.2  Client and Server Remote Printer Printcap Entries
.KE

By convention,
if a user does not specify a printer,
either by using a command line option or by setting the
.B PRINTER
environment variable,
the printer named
.L lp
is used as the default printer. If there is no printer named
.L lp ,
the first printer in the printcap file is used instead.
.NH 2
Spool Queue Directory
.PP
The
.B sd
(spool directory) field specifies the path name of the directory
which will hold spool queue entries or jobs.
The
.B sd
parameter
.I must
be present for all printcap entries which are
used for spooling, even if they only spool files before transferring
them to a remote host. Also, only one printer can use each
spool directory, except in the case of
.B ss
(multiple server) queues.
.PP
Figure 4.3 is a typical printcap entry for
a remote printer spool queue,
whose spool directory is specified as
.L /var/spool/lpd/lind33_decwriter .
.KF
.nf
.in +1i
.DT
.L
.SM
# Decwriter III in Lind 33
# Modified 11 Feb. 1988 Patrick Powell - added fx=n for ditroff
# queue printer permissions file
# maximum job size 2000K bytes, no copies
remote\||\|lind33_decwriter:\e
	:fx=ilpn:\e
	:sd=/var/spool/lpd/lind33_decwriter:\e
	:rm=umn-cs.cs.umn.edu:rp=lind33_decrwriter:\e
	:xu=perms:\e
	:ex=n:ne=/usr/local/lib/ddumb:\e
	:mx#2000:sc:
.LG
.R
.in -1i
.ce
Figure 4.3  Remote Printer Printcap Entry
.KE
.NH 2
Job Submission Controls
.PP
The following fields are used to control job submission.
.NH 3
Job Formats
.PP
Each job in a spool queue has an associated format,
which is represented by a lower case letter\**.
.FS
Actually,
each file in the job can have a different format,
but the current version of
.I lpr
does not support this.
.FE
There are several
.I lpr
options such as 
.B -n,
.B -d,
etc. which can be used to specify a limited set of formats,
or the
.B \-Fx
option can be used to specify any format.
For example,
the
.B \-Fn
options specifies printing using the
.B n
format,
as below.
.ti +.5i
.L "ditroff -Tdumb -ms myfile | lpr -Fn -Premote"
.PP
The format supported by a spool queue can be restricted by the
.B fx
printcap field,
which specifies the formats supported by the spool queue.
In Figure 4.3,
the
.B fx=ilpn
field restricts formats to
.L i,
.L l,
.L p,
and
.L n .
Some formats require that files be printable
(i.e.- contain characters in the ASCII characters set,
or other restrictions).
By default,
only the
.L f
and
.L p
formats are checked by
.I lpr
for printable files.
The
.B xt
field is used to specify additional formats to be checked for printable files.
.NH 3
Permissions Files
.PP
Each host has a
printer permissions file which is checked by the
PLP software to determine if actions requested by users or other hosts
are permitted.
In addition,
the
.B xu
(check user) printcap
field is used to specify an additional printer permission
file which is checked for jobs in the spool queue.
For example,
the
.B xu=perms
field causes the
.L perms
file in the spool directory to be checked by
.I lpr
when  the job is submitted.
Similarly,
the unspooling server process will also check this file
when the job is finally printed.
.NH 3
Prefilters
.PP
It may be desirable to process or filter a job at the time that it is
spooled.
The program used to filter a job is specified by a field of the form
.BR X e=filtername ,
or
.BR X e=filtername,y ,
where
.BR X
is the original format,
filtername is the pathname of a program,
and
.L y
is the result format.
The default result format is
.L f .
In addition,
the
.I lpr
.B -p
option specifies filtering with the
.I pr
program;
.I lpr
invokes the program specified by the
.BR pr= filtername
(default is
.L /bin/pr ).
.NH 3
Job Size and Number of Copies
.PP
The
.B mx
(maximum size)
field is used to specify a maximum file size (in 1 Kbyte blocks)
that can be spooled by
.I lpr.
Jobs whose total size (including duplicates) exceeds this limit are
not spooled.
For example,
the
.B mx#2000
entry restricts jobs to a maximum of 2000 Kbytes.
Also, if the
.B mi
field has a value greater than zero, it specifies the
minimum free space (in 1 Kbyte blocks)
to be left free in the spool directory's filesystem.
If a job is received that would push free space below this value,
it is refused.
.PP
The
.B mc
(maximum copies) value specifies the maximum number of copies allowed
and the
.B sc
(suppress copies) flag which suppresses multiple copies.
.PP
Using the
.B li (file
size limit) field, it is possible to set up multiple
queues with different file size limits for each printer, so a fast printer
can be used to print long files, while a slower printer is used
to print shorter files. Again, this value is specified in 1 Kbyte
blocks. See section 12 for more details.

.NH 2
Remote Printer Spool Queues
.PP
Remote spool queues specify the remote host using the
.B rm
field and the remote printer using the
.B rp
field.
The remote host addressing information is obtained using the
.IR gethostbyname (3N)
facility.
The remote printer must appear in the remote host's
printcap data base. Unlike most lpd implementations, PLP
supports the use of an
.B if
filter on files being sent to a remote printer; a filter
is run independently on each file being transmitted, in
the same way as an
.B if
filter for a local printer.
See section 7 for more details on the use of filters.
Also, multiple remote printers are supported, where one
remote printer can feed to another remote printer,
.I ad
.I infinitum .
.PP
Figure 4.3 is an example of an entry for a remote spool queue
that will be sent to host
.L umn-cs.cs.umn.edu ,
and printed on the
.L lind33_decwriter
printer.
.PP
.IP "Remote Jobs Failing on non-PLP Hosts" 3
If PLP is sending jobs to a remote host that is not running
PLP, jobs may fail. This often happens with Sun's default
lpd. In this case, turn on the
.B bk
parameter, which will re-order the control file's fields
into an order which these lpd implementations will accept.
.NH 2
Local Printer Queues
.PP
Unspooling from a local printer queue can be done in two manners:
using the unspooling capabilities of the PLP server created for the
queue by the lpd,
or by having the server process invoke a special
.I "queue handler"
process.
The latter method is discussed later in this section.
.PP
Associated with each local queue is an output device.
These can be categorized as serial line,
a specialized device with a non-serial interface,
or a pipe.
If a device is attached to a serial line,
the printcap can be used to specify how the serial line
is to be conditioned in order to communicate with the printer.
Figure 4.3 is a sample printcap entry for a DecWriter III printer connected
over a 1200 baud serial line.
.KF
.DT
.in +1i
.L
.nf
.SM
# Local Printer Entry
# Decwriter III in Lind 33
# Modified 11 Feb. 1988 Patrick Powell - added fx=n for ditroff, max 2 retries
lind33_decwriter\||\|clunker\||\|Decwriter Model 3:\e
	:fx=ilpn:\e
	:sd=/var/spool/lpd/lind33_decwriter:\e
	:xu=/usr/adm/perms/lind33_decwriter:\e
	:rt=2:\e
	:ne=/usr/local/lib/ddumb:\e
	:lp=/dev/ttyh8:rw:\e
	:br#1200:fs#06320:ty=-nl odd even -tabs tandem new:\e
	:lf=error:
.LG
.in -1i
.R
.ce
Figure 4.3 Printcap Entry for Serial Line Device
.LG
.KE
.NH 3
Output Device Pathname
.PP
The
.B lp
(line printer) parameter specifies a path name of the device, or
an LP-pipe command, that is to be opened and output sent to.
See section 4.5.4.
The device is opened for writing only (default),
or reading and writing if the
.B rw
flag is  present.
Note that there is no default value for the
.B lp
field.
If there is no physical device corresponding to the printer,
then
.L "lp=/dev/null"
should be used to specify a null device.
.NH 3
Retry Limits
.PP
The server will attempt to unspool and print a job for a limited number
of times.
The number of attempts is set by the
.B rt
(retry) parameter;
the default value is 3,
and a \-1 value specifies unlimited retries.
.NH 3
Serial Line Characteristics
.PP
Printers connected via a serial communication line
must have the proper baud rate and line characteristics set.
.IP "Setting Bit (Baud) Rates" 3
The
.B br
parameter sets the bit (baud) rate for the tty line.
For example,
300 means 300 BPI,
9600 means 9600 BPI.
.IP "Setting Line Characteristics" 3
The
.B fs
(set bits) and
.B fc
(clear bits) parameter is used to set the serial line characteristics with the
TIOCSETP
.IR ioctl \|(2)
operation.
The
.B fs
and
.B fc
set and clear bits in the line control status word returned by the
TIOGSETP ioctl operation,
which is then restored with the ioctl TIOCSETP.
In the above example,
.B fs
sets CRMOD,
no parity,
and XTABS (see
.IR tty \|(4)
for details).
The
.B xs
and
.B xc
are be used to set and clear local control  information
using the TIOCCLGET and TIOCCLSET ioctl calls.
.IP "Alternate Method" 3
In case you find the
.B fs ,
.B fc ,
etc.,
method of setting line characteristics embarassingly user-hostile,
you can use the
.B ty
(stty) parameter,
which uses (almost) the same keywords and options as the
.I stty (1)
command.
For example,
.L "ty=nl -odd -even -tabs" 
can be used instead of the above
.B fs
values.
If you need tandem line control you
may have to open the output device for reading and writing using the
.B rw
field;
this appears to be implementation dependent.
Use of the
.B ty
parameter is endorsed, as it is both more portable and more
comprehensible than the rather opaque
.B fs ,
.B fc ,
.B xs ,
and
.B xc 
parameters.
See the
.I printcap (5)
manual page for details of which
.I stty
options
.I lpd
recognises. The
.I stty (1)
manual page will provide an explanation of the different options.

.NH 3
LP Pipes
.PP
To connect to a printer using anything other than a serial line,
the 
.B lp
parameter must contain an entry of the following style:
.B "| lp-pipe-cmd [ args ]"
If this is found in the printcap, the lpd will attempt to run
the command, and use it as the output device.
.PP
The
.B rw
entry is not used with LP-pipes.
.NH 2
Job, Log, Lock, and Status Files
.PP
The pathnames for all files associated with a spool queue are
relative to the spool queue directory or are absolute paths.
The following sections discuss the various files that are used
for logging and status reporting.
.NH 3
Job Files
.PP
A job consists of a control file and a set of data files.
Lines in the control file provide information about the user,
the originating hosts,
and the names of the data files,
and the data file unspooling formats.
A job control file name has the form:
.ti +5n
.B cf
.L "[Priority \- A-Z]"
.L "[Job Number \- 000-999]"
.L "[Host Name]"
.br
.ti +5n
.nf
Example:   cfA002attila.cs.umn.edu
.fi
.PP
The first two letters identify the file as a control file,
the next letter is the job's priority level,
the next 3 digits are the job number,
and the trailing characters are the host name.
.PP
The priority level is set by the LPR process at the time that the job is
submitted;
the
.I lpc
program can be used to upgrade a job's priority.
The sequence number is obtained from a sequence file,
which is locked when in use by
.I lpr
in order to avoid duplicate sequence file names.
Each host has a unique sequence file,
and the combination of host and sequence number should be unique.
This is true as long as there are less than 1000 jobs outstanding in
a queue.
.PP
The data files associated with a job have files names with a similar form,
as follows:
.ti +5n
.B df
.I [Sequence]
.I [Job Number]
.I [Host]
.br
.ti +5n
.nf
Example:  dfA002attila, dfB002attila
.fi
.PP
The PLP software checks to ensure that control file and data file
names have the same corresponding form.
.NH 3
Control File
.PP
A control file contains the information neccessary to print a job.
Figure 4.4 is a typical control file for a job.
.KF
.DT
.L
.SM
.nf
.in +1i
Hattila.cs.umn.edu
LPatrick Powell,L136
Ppapowell
N(stdin)
J(stdin)
CZ
fdfA001attila
UdfA001attila
.in -1i
.LG
.R
.ce
Figure 4.4. Job Control File Example
.KE
.PP
The first character on each line is a flag character
used to decode the remainder of the line.
Upper case flags provide information or pass options for the
printing actions.
Lower  case characters are format indicators for specified data files.
Note that there is a maximum limit on the size of each line of a
control file.
Table 4.1 lists the various control flags that are used
in the control file.
.KS
.L
.SM
.TS
tab(:) box center;
l |l |l.
Flag:Parameter:Meaning
_
C:class name:banner page
H:host name:originating host
I:indent:amount to indent output
J:job name:banner page
L:user name:name to print on banner
M:mail:mail to user when done printing
N:name:name of file in job
P:Person:user's login name
S:flag:no header request
R:account:accounting information
U:file name:remove file after we print it
W:width:page width for PR
X:header:header title for PR
Z:extra options:options for filters from lpr
f:file name:ordinary file
l:file name:text file with control chars
p:file name:text file to print with pr(1)
t:file name:troff(1) file
n:file name:ditroff(1) file
d:file name:dvi file
g:file name:plot(1G) file
v:file name:plain raster file
c:file name:cifplot file
.TE
.LG
.R
.ce
Table 4.1. Control File Flags
.KE
.NH 3
Log File
.PP
The spool queue server process writes error and informational messages to 
the server log file,
which is specified by the
.B lf
field;
the default log file is the file
.IR log
in the spool directory.
If the log file does not exist,
then no logging is done.
Serious error messages (those with a priority higher than
.L notice )
are written both to the log file and
logged using the
.IR syslog (3)
facility if it is available,
or to
.L /dev/console
if it is not.
.PP
If the error in question results in the failure of a job to print,
mail will be sent to the user (and to the
.L daemon
user), detailing the error that caused this failure.
It is possible to change the address that error mail is sent to
(and ostensibly from), using the
.L plp.conf
directive,
.I mail-from-address .
.NH 3
Lock File
.PP
The spool queue lock file
is used to control spooling and unspooling  operations.
The lock file name is specified using the
.B lo
(lock file)
field,
and the default lock file name is
.IR lock .
.NH 3
Status Files
.PP
The server status file
(default file is
.IR status )
contains status information reflecting the operations of the unspooling
server processes.
The
.B st
(status) field can be used to specify an explicity name for the status file.
An additional printer status file can be specified with the
.B ps
field.
This file can be used by filter programs that generate additional status
information that should be available for display.
.NH 2
Multiple Servers
.PP
If a spool queue has multiple printers or servers,
the server names are specified by the 
.B sv
(servers) parameter,
which contains a comma separated list of server names.
Each server name has a printcap entry,
and each server entry has a corresponding
.B ss
(serves) field
which contains the name of the spool queue served by the printer.
Each printer will use the spool queue directory specified by the
.B sd
field of the spool queue that it serves.
Note that this name corresponds to the name of the queue,
not the spool directory pathname.
.KF
.in +1i
.DT
.L
.SM
.nf
# Multiple servers
fast:\e
	:sd=/var/spool/lpd/fast:\e
	:sv=fast.a,fast.b:
fast.a:\e
	:ss=fast:\e
	:lo=lp1:lf=fast.a:st=status.a:lp=/dev/ttya:
fast.b:\e
	:ss=fast:\e
	:lo=lp2:lf=fast.b:st=status.b:lp=/dev/ttyb:
.LG
.R
.in -1i
.ce
Figure 4.5  Multiple Server Printcap Entry
.KE
.PP
In the example in Figure 4.5,
the
.L lp1
and
.L lp2
printers are used to serve the
.L fast
spool queue.
Note that each of them explicitly specify the name of their lock and
log files; as they will use the same queue directory the names of the lock,
log, and status files must be different. We suggest you use ``.a'',
``.b'', and so on as a suffix to distinguish the printers and their
control files; this is supported by the 
.B limits
functionality as a way of imposing different limits
on different printers. See the file ``PLP-with-limits'' in the doc
subdirectory of the distribution for more details.

.NH 2
Multiple Queues for a Single Output Device
.PP
You will probably want to use multiple queues for a single output device,
such as one postscript queue, one plain-text queue, and one plain-text
with formatting. What you should do here is set up all these queues,
with the lowest common denominator being the local-printer queue,
and all the other queues feeding into this one as remote-printer
queues. The queue that they feed into is called a
.IR "funnel queue" .
.PP
For example, let's say you have an HP Laserjet 4M+ in PostScript mode,
set up as the queue
.IR hp4m-ps ,
and you want a plain-text queue (
.IR hp4m-mp )
and a plain-text-2-up queue (
.IR hp4m-mp-2up )
that print to the same device.
The
.IR hp4m-mp
and
.IR hp4m-mp-2up
queues should forward their jobs directly to the
. IR hp4m-ps
funnel queue after filtering them.
The printcap entries in figure 4.6 illustrate how to do this.
.KF
.in +1i
.DT
.L
.SM
.nf
# Multiple queues for one device
#
hp4m-ps:\e
	:cm=HP LaserJet 4Mplus, postscript:\e
	:sd=/var/spool/lpd/hp4m-ps:\e
	:lf=/share/logs/lpd/hp4m/ps:\e
	:lp=9100@exception.iona.ie:rs:mx#0:

hp4m-mp|hp4m-mp-1up:\e
	:cm=HP LaserJet 4Mplus, with "mp" filter:\e
	:sd=/var/spool/lpd/hp4m-mp:lf=/share/logs/lpd/hp4m/mp:\e
	:if=/usr/local/etc/printer/run-mp:\e
	:rm=localhost:rp=hp4m-ps:

hp4m-mp-2up:\e
	:cm=HP LaserJet 4Mplus, with 2-up "mp" filter:\e
	:sd=/var/spool/print/hp-mp-2up:lf=/share/logs/lpd/hp4m/mp-2up:\e
	:if=/usr/local/etc/printer/run-mp-2up:\e
	:rm=localhost:rp=hp4m-ps:
.LG
.R
.in -1i
.ce
Figure 4.6  Multiple Queue Printcap Entry
.KE

.PP
Using a funnel queue will avoid the following difficulties:
.NH 3
Device Locking Difficulties
.PP
Occasionally, you may run into problems with device locking, where
by some bug in your operating system's kernel, two queues could output
jobs (or parts of jobs)
to the same device at once. This should not happen, but Murphy's Law
dictates that it may; using a funnel queue would prevent this.
.NH 3
Queues Hogging the Output Device
.PP
If two queues,
.IR qa
and
.IR qb
share the same output device, the following could happen.
User
.IR Ann
sends a large job to 
.IR qa ,
and user
.IR Bill
sends a job to 
.IR qb
shortly after 
.IR qa ,
commences printing Ann's job. Bill's job should be printed
next, but if Ann submits another job to 
.IR qa
before the first job is finished, 
.IR qa
will move straight on to Ann's second
job, without allowing 
.IR qb
to print Bill's job, even though
Bill's job was lpr'ed first. This entirely defeats
the queueing functionality.
.NH 3
Forwarding Jobs to Single-Threaded LPDs
.PP
Recently, some LPD implementations have appeared,
such as the HP JetDirect embedded LPD, that
can only cope with one job at a time and do not perform
any spooling. If another LPD implementation, such as PLP,
tries to open a connection to these LPDs, the connection
is refused, and PLP must sleep and retry.
Unfortunately, If two queues are trying to send
jobs to the same printer at once while a job is printing,
they must sleep and retry; even if one queue has been
waiting longer, it can still be beaten to the printer
by the other queue, depending on who wakes up soonest
after the printing job finishes. Again, this entirely defeats
the queueing functionality.
