.ig
$Header: 11.t,v 1.1 88/05/21 18:39:52 papowell Locked $
$log$
..
.bp
.LG
.NH 1
Installation and Testing
.SM
.PP
The following is a summary of the
test procedures for the PLP software.
See the file "INSTALL" in the PLP base directory for installation
instructions.
.NH 2
Test Version
.PP
A test version of the spooling software can be generated
by compiling with the CONFIG_FILE definition set to
a non-standard location, such as
.L /tmp/plp.test.cf .
This allows you to use
.L /tmp/printcap.%h,
.L /tmp/printer_perms.%h,
and a non-priviledged INET port,
rather than
.L /etc/printcap,
.L /etc/printer_perms,
and the priviledged TCP/IP printer server port.
If you compile PLP with the SUID_CFLAGS definition
uncommented in the Makefile, you can
test PLP without using any form
of specially-privileged user, be it root or daemon;
ie. using your own userid.
The following diagram depicts a sample test
.I plp.conf
file, and is also available in the file
.L test/plp.conf .
See the manual page
.I plp.conf (5)
for more details.
.DS
.DT
.ta 12m +4n +4n
.L
.SM
user	yourname

logfile	/tmp/lpd.log.%H
lockfile	/tmp/lpd.lock.%H
printcap-path	/tmp/printcap.%H
printer_perms-path	/tmp/printer_perms.%H

lpd-port	45321
allow-non-priv-ports	allow quiet
.DE
.PP
The PLP distribution
.B test
directory contains prototype or debugging versions of printcap,
printer_perms, plp.conf, and other files;
.B test/Makefile
will generate and install the necessary directories and filters.
The test devices have their spool directories in /tmp,
and should be trivial to install. You need to edit the Makefile
so a few of things are set properly for your local site
(eg, hostname and paths).
Run the tests listed below to ensure that the various programs are working.
.PP
In summary,
to make the test verions,
do the following.
.IP 1).
Run the
.L configure
script, edit the Makefile, and run
.L make ,
as detailed in INSTALL.
.IP 2).
Set up your shell $path or $PATH to use the
directory where you compiled the PLP executables ahead of /usr/ucb and /usr/bin,
otherwise you will use the existing LPD programs.
.IP 3).
Go to the
.L test
directory,
read the
.L test/README
file,
edit the
.L test/Makefile
according to the directions,
and do
.L "make bin" .
This generates some executables and places them in the /tmp
directory,
as well as installing a test version of the printer permissions and
plp.conf files.
.IP 4).
Now you should take a nap,
play nethack,
or whatever you do to relax.
The next part is not fun.
.NH 3
Test 1\- LPC, LPR, LPQ
.PP
To run the first tests,
change to the
.L test
directory and do
.L "make test1" .
This installs the printcap file of Figure 11.2 in /tmp/printcap:
.KF
.in +1i
.nf
.DT
.L
.SM
.vs -2
.ta 4n +4n +4n +4n +4n +4n +4n +4n +4n +4n +4n 8i
#
# TEST VERSION OF PRINTCAP FILE:
# Test 1: simple lpr functions
#
test:\e
	:fx=flpdnt:ex:\e
	:pw#75:pl#66:rw:\e
	:br#9600:fs#040:fc#011:\e
	:ty=new 19200 even -tabs tandem:\e
	:lp=output:\e
	:if=/tmp/filter -delay30:\e
	:of=/tmp/lpf -D5:\e
	:sd=/tmp/test:
.vs +2
.sp .5v
.R
.LG
.in -1i
.ce
Figure 11.2  Test 1 Printcap File
.KE
.PP
You should look at the code for the
.L filter
and the
.L lpf
programs which were created by the
.L "make bin" .
The
.L filter
program is a handy dandy debugging filter.
The
.L lpf
filter simply copies stdin to stdout,
and suspends itself when it detects the stop string.
The
.L lpf
filter source is the skeleton for any new filters that are needed.
.PP
You can test the functionality of the
lpq,
and lpr
programs by using the illustrated commands.
Sample output has been provided.
.nf
.vs -2
.DT
.SM
.L
.ta 12n +4n +4n +4n +4n +4n +4n +4n
%>lpq -D5	#should display queue (empty)
lpq: pid=4233, LOG_DEBUG, First_printer: simple at Fri May 20 17:02:08 1988
lpq: simple- pid=4233, LOG_DEBUG, Get_Printer: First_printer 'simple' at Fri May 20 17:02:08 1988
lpq: simple- pid=4233, LOG_DEBUG, Get_printer: using Printer simple at Fri May 20 17:02:08 1988
lpq: simple- pid=4233, LOG_DEBUG, Readlockfile: lockfile 'lock' at Fri May 20 17:02:08 1988
lpq: simple- pid=4233, LOG_DEBUG, Readlockfile: lock, perms 0100644 at Fri May 20 17:02:08 1988
lpq: simple- pid=4233, LOG_DEBUG, Readlockfile: 'lock' pid 0 len 0 at Fri May 20 17:02:08 1988
lpq: simple- pid=4233, LOG_DEBUG, Checklockfile: lock server 0 at Fri May 20 17:02:08 1988
lpq: simple- pid=4233, LOG_DEBUG, printstatus: ST status at Fri May 20 17:02:08 1988
Printer 'simple' (attila.cs.umn.edu):
  work done at Wed May 18 09:38:59 1988

%>lpr xx	#place job in queue
lpr: Warning- File 'xx' not printed: cannot access it
lpr: Fatal error- nothing to print

%>echo hi | lpr	#place job in queue
lpr: simple- Startserver: host 'attila.cs.umn.edu' server for 'simple'
	not started - Connection refused at Fri May 20 17:08:51 1988

%>lpq	#should display queue one entry
Printer 'simple' (attila.cs.umn.edu):
Warning: no server present
  Rank Owner       Pr Job Host        Files                Size
   1st papowell    Z  13  attila      (stdin)              3

%>lpc	#play with lpc
>status
Queue          Jobs    Queueing     Printing
simple            1    enabled      enabled (no server)

>disable simple
simple: queueing disabled
>status
Queue          Jobs    Queueing     Printing
simple            1    disabled     enabled (no server)
>quit
.R
.LP
.NH 3
Test 2\- LPD Functionality
.PP
Use the commands:
.ti +.5i
.L "echo >/tmp/error"
.ti +.5i
.L "lpd  -D5 -L /tmp/error; tail -f /tmp/error"
.br
to create the error log file and to start up lpd.
It is best to do this at one terminal/window,
and then do the remaining tests at another terminal/window.
You will be amused to watch the lpd spring into action,
trying to create servers,
etc.
The
.L simple
server will log into the
.L /tmp/simple/log
file.
.PP
You can remove /tmp/test/log,
and see the interaction of the lpd daemon and the printer server
little clearer.
To kill the lpd daemon,
do the following:
.DS
.DT
.L
.SM
lpc lpd		##- prints the lpd daemon id
kill <pid>	# kill off the daemon
rm /tmp/test/log	# remove the log file
echo >/tmp/error
lpd -D5 -L /tmp/error
tail -f /tmp/error
.R
.DE
.PP
If you are curious,
try starting multiple
.L "lpd"
programs;
when
.L lpd
is started,
it checks for a running daemon,
print a message,
and then exits.
.PP
You can examine the conditions of the servers and other
activites by using
.I lpq .
Note that the lpq status report includes a chatty informational piece about
the job progress.
.PP
The OF filter has been carefully created to print out
various pieces of information.
You can see what this is if you look at /tmp/test/output,
where the output is going.
You will notice that the IF filter is a shell script,
and will sleep for a while.
You can now test out the various lpq,
lpr,
and lpc functions.
.PP
.NH 3
Test 3 \- LPD Functionality from inetd (optional)
.PP
If you want to run lpd from inetd,
now's the time to test it out; add the following line to the
.L /etc/services
file (this assumes that you're using the ``plp.conf'' file from
figure 11.1):
.DS
.DT
.L
.SM
nprinter    44444/tcp
.R
.DE
.PP
and the following to the
.L /etc/inetd.conf
file, changing $(PLP_BIN) as appropriate:
.DS
.DT
.L
.SM
nprinter  stream  tcp  nowait  root  $(PLP_BIN)/lpd  lpd -i
.R
.DE
.PP
Now, kill off the current lpd process; type
.L "lpc lpd"
and
.L "kill -3"
.I <lpdpid> ,
where lpdpid is the process ID output by lpc.
Restart the inetd process\**.
.FS
Send the inetd process a SIGHUP signal by finding out its pid using
.L "ps -ef"
or
.L "ps aux"
and typing
.L "kill -1"
.I <pid> .
.FE
This will cause the inetd process to reread the
.L /etc/inetd.conf
file, and start listening for requests on the nprinter port. When
one comes in, it will fork an LPD process to handle it.
.PP
Test this out using the lpq, lpr and other commands, as in step 2.
Make sure the ``plp.conf'' file is set up with an
.L lpd-port
entry, so the client commands don't end up talking to
the system lpd instead of PLP.
.NH 3
Test 4 \- Remote Servers
.PP
These tests check out the functionality of inter-host spooling functions.
They have been written so that they will use the local host intitially,
but can be extended to the remote host.
.PP
In the
.L test
direcotory, do
.L "make test2"
to install the second form of the printcap file.
You will not have to kill the lpd to do this.
Now try
.ti +.5i
.L "lpq -Premote"
.br
and examine the output.
The lpq program will print out the local queue,
and then send a message to the remote host (which is the local host).
This will check out the functionality of the network communication.
You can play with lpr, lpc, etc. and check this out.
Try the
.I remote
functions of the
.I lpc
program.
.PP
If you have two hosts available,
install the PLP software on both of them.
Edit the printcap files so that one of them has the local test,
and the other the remote test entry.
Don't forget to install and modify the printer_perms file so that the
remote host can access the test spool queue.
Try the communications out.
.NH 3
Test 5 \- Multiple Servers
.PP
This will demonstrate how to have multiple servers for a single spool
queue.
Install the printcap file by doing
make test3.
Use lpq to check the status of the spool queue.
Now use lpr to send a slog (10 or more) jobs to the multi queue.
You can use
.ti +.5i
.L "lpq +10 -a"
.br
to monitor what happens.
.NH 3
Test 6 \- Serial Line Control
.PP
If you have a printer,
attach it to a suitable serial line,
and modify the test printcap entry so that it is set up
for the printer.
I have found that the following procedure works pretty good.
.PP
Set the
.B sh
(suppress headers or banners)
in the printcap entry,
and remove the
.B of
entry.
Set up a new entry for if,
.B "if=/tmp/serial -d30"
and edit the filter program to print out the stty settings.
You can now run lpr to try and send things out to the printer.
You will either have lots of problems or no problems in communicating
with the printer.
.PP
Watch out for parity;
you may have to fool around with the printer parity settings.
I strongly suggest a NO parity setting.
Tandem flow control is another tricky area.
You may have to open the printer read/write using
.B rw
to get tandem flow control.
This has been a problem with several installations.

.NH 2
Checking Out Existing Printcaps and Filters
.PP
If you have an existing printcap file,
you can check it out by using a test form
of PLP before you commit to the actual form.
.IP 1). 3
First, edit the Makefile and change CONFIG_PATH to
.L /tmp/plp.test.cf ,
the ``plp.conf'' file from figure 11.1,
then compile up PLP.
.IP 2). 3
Copy the original
.L /etc/printcap
file to
.L /tmp/printcap.<host> .
.IP 3). 3
Modify the 
.L /tmp/printcap.<host>
file so that the
.L /var/spool
directories in it are modified to be
.L /tmp
directories.
.IP 4). 3
Set your 
.L $path or
.L PATH
environment variable
to use the test version,
and run
.L "checkpc -f"
to create the spool directories needed by the
.L /tmp/printcap.<host>
version.
.IP 5). 3
You can now run a parallel version of the PLP software,
and check out the behaviour of devices and filters.

.NH 2
Installing a Working Version
.PP
Before you install a the PLP software,
you should make a copy of the existing print spooler software.
There is a set of programs in the
.L backup
directory of the PLP distribution that have proven to be very useful.
Here's how to make an installable version.
.IP 1).
Edit the Makefile and change the CONFIG_PATH directive to
point to a non-test version, such as
.L /etc/plp.conf ,
and comment out the SUID_CFLAGS definition so setuid mode is
re-enabled.
.IP 2).
Do a
.L "make clean; make all"
to regenerate the working version.
.IP 3).
Create a printer permissions file.
You can base this on the version in the
.L test
directory.
The version
in Figure 11.3 is useful for initial installations,
and can be found in
.L test/printer_perms.all .
.KF
.nf
.SM
.L
.vs -2
# Printer permissions data base
# host user printerqueue maxpriority maxpages currentpages
# * is a wildcard
#host   user      printer     perms  pr maxpages pages
*       root      *           *      *  0        0  #root on any system
*       *         *           R      G  0        0 #anybody can do remote
.vs +2
.LG
.R
.sp .5v
.ce
Figure 11.3  Sample Printer Permissions File
.KE
.PP
.IP 4).
Do a
.L "make install"
and check that permissions have been set correctly.
.IP 5).
Using the same tests as outlined above,
make sure that lpr,
lpc,
and lpq
are functional.
.IP 6).
Start lpd
and check that files are unspooled and transferred correctly.

.NH 2
Improving PLP's Performance
.PP
PLP's in-built defaults state that it should
not cache printcap and printer_perms information, but instead should
read the file every time an entry is requested.
This is noticeably detrimental to the speed of the lpd,
but is very useful for testing.
.PP
Once you are satisfied that your PLP configuration
files will be reasonably static for a while, turn on
caching by putting the following lines in the
.L plp.conf
file:
.DS
.DT
.L
.SM
use-printcap-cache	yes
use-perms-cache	yes
.R
.DE
.PP
These will enable caching, and should speed things up
significantly. You can cause the lpd to
reread all its configuration files at any time by
sending it a SIGHUP (kill -1).
