
NAME:
	plp.conf - configuration file for the PLP line printer spooler system

DESCRIPTION:
	The file 'plp.conf' is used to provide configuration information for
	the Public Line Printer spooler system. Blank lines and lines
	starting with a hash sign (``#'') are ignored. All other lines
	specify parameters that may be used, and should be of the following
	form:

		keyword [ value ... ]

	Trailing comments will be ignored; if a hash sign is desired in the
	configuration information, it should be escaped with a backslash
	(``\\\'').

	Some of the configuration parameters refer to files, and may include
	certain special character sequences; at present, these sequences
	are:
.TP
	'%h'
		expands to the current host name, in short
		(non-fully-qualified) format, ie. "class".
.TP
	'%H'
		expands to the current host name, in long
		(fully-qualified) format, ie. "class.iona.ie".
.TP
	'%a'
		expands to the abbreviated architecture name,
		"sun4", "sol2", "hpux", "aix", "irix5", etc.
		This value can be set using the 'architecture'
		keyword in the configuration file and is set to a
		default value at compile-time.
.PP
	Some of the parameters can only be used if parts of the
	PLP functionality have been enabled at compile-time, by editing
	the 'config.h' file.

	The current set of parameters is as follows:

GENERAL CONFIGURATION PARAMETERS:

.TP
	'include' (no default)
		This can be used to include files into
		the 'plp.conf' file; see the "INCLUDE PARAMETERS"
		section, below, for more details.

.TP
	'logfile' (default: /var/spool/lpd/lpd.log.%h)
		The file that 'lpd' initially logs debugging and
		informational messages to. Individual 'printcap'
		entries can also specify log files for each
		printer.

.TP
	'lockfile' (default: /var/spool/lpd/lpd.lock.%h)
		The file used to indicate the presence of an 'lpd'
		server running on the host.

.TP
	'user' (default: daemon)
		The user that 'lpd' and its filters runs as,
		and the owner of the spool directories and
		other lpd-writable files.
	
.TP
	'printcap-order' (default: files hesiod nis)
		This is the order in which the different types
		of databases (printcap, printer_perms, Z-options
		and cost-codes, if active) are searched, going
		from left to right.
		If 'files' is specified, and LOCAL was defined in
		config.h at compile-time, then
		the 'printcap-path' and other file-based
		searching methods are used to find information.
		If 'hesiod' is specified, and HESIOD was defined in
		config.h at compile-time, then
		Hesiod lookups are attempted in the zones specified
		by the 'hesiod-domains' parameter.
		If 'nis' is specified, and NIS was defined in
		config.h at compile-time, then NIS lookups are
		attempted in the domains specified by the
		'nis-domains' parameter.

.TP
	'default-printcap-params' (default: "")
		The set of default printcap parameters. This
		will be prepended to each printcap entry, and
		is useful for setting such parameters as
		'sh' and 'mx'. The individual printcap entries
		can override these if necessary. See the
		'printcap' man page for more details.
		Numeric entries use hash signs (``#''), which
		need to be escaped, as they are also the configuration
		file's comment character. This string must begin
		with the ':' character, otherwise the first parameter
		in the list will be ignored.

.TP
	'eucs-banner-format' (default: yes *)
		If this is active, the Edinburgh U. of C.S. banner
		format will be used.
.TP
	'check-for-nonprintable' (default: no)
		If this is set, files printed using 'lpr' will first
		be checked for non-printable characters, unless the
		'-b' command-line option is supplied. Note that
		files containing HPGL or other printer control
		languages would often be classed as ``non-printable''
		by this routine.
.TP
	'show-empty-queues' (default: yes)
		If this is set, lpq will always report queues
		in a multiple-queue remote-printer sequence,
		whether they have jobs queued or not.
.TP
	'domain-name' (default: "")
		This parameter is optional, and is appended to
		the hostname to make it into a fully-qualified
		domain name, ie. "class.iona.ie". It will only
		be used if PLP cannot work out the domain name
		using other means, such as 'gethostbyname(3n)'.
.TP
	'architecture' (defaults: "sun4", "sol2", etc.)
		This parameter is optional, and is used when
		expanding the special sequence '%a' in 
		pathname and filename strings in this config
		file. It is set to a default value at compile-
		time. If you use this keyword, make sure it
		comes before any lines where '%a' is used.
.TP
	'use-printcap-cache' (default: no)
		If this is set to "yes", any printcap lookups
		will be cached for later use. You can force
		the 'lpd' to reread its configuration files
		by sending it a SIGHUP.
.TP
	'use-perms-cache' (default: no)
		If this is set to "yes", printer_perms
		lookups will be cached for later use.
		Only lookups in the main file will be cached,
		not lookups in the per-printer perms files
		("xu" printcap parameter). You can force
		the 'lpd' to flush its cache and reread the
		permissions file by sending it a SIGHUP.

INCLUDE PARAMETERS:
	These parameters are used to control inclusion of files
	into the PLP configuration files, in the same manner as
	preprocessors such as cpp (as used in the C compiler).
	They can contain the usual expansions: '%a', '%h', etc.

.TP	
	'config-include-path' (default: special)
		The include-path for plp.conf file; this can
		contain expansions, but make sure these have
		been set to the desired values before they
		are used! The default value for this is set
		to the directory that CONFIG_FILE is in; eg.
		if CONFIG_FILE is set to "/etc/plp.conf",
		then 'config-include-path' is set to "/etc".

.TP
	'printcap-include-path' (default: /etc:/var/spool/lpd)
		The include-path for the printcap file.

.TP
	'printer_perms-include-path' (default: /etc:/var/spool/lpd)
		The include-path for the printer_perms file.

SECURITY-RELATED PARAMETERS:
	In addition to the actions of the following two parameters,
	environment variables are sanitized by 'lpd' and the other
	PLP executables, in that the variables "IFS", "LD_PRELOAD"
	and "LD_PROFILE" are all deleted from the environment passed
	to filters and any other sub-processes. For more reliability,
	I'd suggest that script filters set their own
	PATH and LD_LIBRARY_PATH variables.

.TP
	'filter-path'
		(default: PATH=/bin:/usr/bin:/usr/ucb:/usr/sbin:/usr/etc:/etc)
		The environment variable PATH, both used to find filters
		and passed on to filters run by 'lpd' and 'lpr'.

.TP
	'filter-ld-path'
		(default: LD_LIBRARY_PATH=/lib:/usr/lib:/usr/5lib:/usr/ucblib)
		The environment variable LD_LIBRARY_PATH, 
		both used when executing, and passed on to filters
		run by 'lpd' and 'lpr'.
		This variable is used to find shared libraries on
		SunOS, Solaris and Linux.

.TP
	'restrict-symlinks' (default: no)
		If this is set, use of the 'lpr' '-s' and '-r' options
		is restricted to users in the group named by the
		'printcap' 'ln' parameter. If this is unset, these
		options can "still" be restricted to the 'ln' users,
		but only if the 'ln' parameter exists.
		PLP is immune to all the lpr security
		holes I have heard of, but there are probably more,
		and most of them revolve around creative misuse of
		these options. If you are paranoid, set this.
.TP
	'allow-non-priv-ports' (default: no log)
		This accepts a number of arguments, which are
		processed from left to right. 
		If the argument 'deny' is used, incoming connections
		to the 'lpd' daemon will only be permitted if they
		arrive on a port less than 1024. These ports are
		only available only to processes running as the
		'root' user; however, on non-UNIX machines, these
		ports may be available to non-root users as well.
		Use 'allow' to allow these connections to be processed.
		Turning this on may compromise security to
		a certain extent. Only turn this on if your network
		includes valid 'lpr' clients that use ports over 1024.
		Other valid arguments are 'log', which causes the
		'lpd' to log any such requests, and 'quiet', which
		disables this logging.
.TP
	'log-requests' (default: lpc lprm lpr)
		This accepts a number of arguments, which are
		processed from left to right.
		If the argument 'lpc' is used, all control operations
		will be logged to the syslog, along with the originating
		user and the host s/he is using.
		'lpq' does the same for queue display requests, and
		'lprm' and 'lpr' do the same for job-removal and
		job-submit requests, along with details of the queue
		in question, file size, job number, and job name.
		If the argument 'private' is used, file names will
		not be output to the syslog.

MAIL-RELATED PARAMETERS:
	
.TP
	'sendmail' (default: yes /usr/lib/sendmail -oi -t)
		If the first argument is "yes", then mail-related
		features is used; otherwise, all mail-related
		functionality is disabled.
		All subsequent arguments are the command to run
		when mail is to be sent. If these arguments are
		not present, mail will be sent using the default
		command.  The command used needs to be able to
		accept the message on stdin, with "no" arguments.
		The message will contain the 'To:', 'From:',
		'Cc:' and 'Subject:' headers.

.TP
	'mail-on-error' (default: yes)
		If an errors occurs during printing of a job
		and this flag is set to 'yes', the 'lpd' will
		attempt to notify the job submitter of the
		error.

.TP
	'mail-format' (default: '%u@%H')
		The formatting string used to construct mail addresses; 
		if the '-m' flag is used with 'lpr', the specified mail
		address will be used for errors or printing confirmation.
		If no argument is provided with the '-m' flag, this
		formatting string will be used in an effort to generate a
		valid mail address for the job submitter.
		Alternatively, if a job fails,
		no mail address was provided, and 'mail-on-error'
		is set to 'yes', 'lpd' will attempt to construct
		a mail address for the job submitter using this
		formatting string.
		This string accepts a non-standard
		``%'' character sequence: '%u', the username
		of the job submitter. '%h' and the others are
		also valid, but refer to the host from which
		the job was submitted.

.TP
	'mail-from-address' (default: "daemon (PLP printer daemon)")
		The From: address used in mail sent to users, as
		detailed in the 'mail-format' description, above.
		If a failure mail is being sent, it will be Cc'ed
		to this user.

.TP
	'errors' (default: yes errors)
		If the first argument is "yes", and the parameter
		'mail-on-error' is set, then this functionality
		is used; otherwise, it is disabled.
		The (optional) second argument is the name of a file
		which, if it exists, should be appended to error
		mails (ones sent when a job fails to print). This
		allows filters and output pipes to include printer
		error messages, so the user can receive some useful
		feedback when jobs fail. If the path given is not
		fully qualified, it is assumed to be relative to
		the printer's spool directory.

SPOOL DIRECTORY FILES:

	Like the 'errors' parameter above, these detail files that are
	(usually) in the spool directory and are used as (possibly
	changing) extensions to the printcap mechanism.  Unless you
	intend to hack these files yourself, you do not need to change
	these parameters. Note that some of these files may be replaced
	by printcap parameters in a future release of PLP.

	If the path given is not fully qualified, it is assumed to be relative to
	the printer's spool directory.

.TP
	'forms' (default: yes options)
		The (optional) second argument is the name of a file
		which contains the valid forms that can be printed
		on this printer. 
	
LOCAL CONFIGURATION FILES:

	These are ignored if 'files' is not used in the 'order' parameter,
	or if LOCAL is not defined in config.h.
	Entries in these paths should be separated by colons (``:'').

.TP
	'printcap-path'
		(default: /etc/printcap:/var/spool/lpd/printcap.%h)
		When a printcap entry is being looked up,
		the files listed here will be searched. If a file
		does not exist, it is skipped. All valid entries in
		these files will be used.
.TP
	'printer_perms-path'
		(default: /etc/printer_perms:/var/spool/lpd/printer_perms.%h)
		If a printer_perms lookup is desired, the listed files will
		be searched. The first file that exists and is readable
		will be used.
.TP
	'zoptions-path'
		(default: /etc/eucs_zoptions:/var/spool/lpd/eucs_zoptions.%h)
		Search path for Z-options, an EUCS feature providing forms
		support. The first file that exists and is readable will be used. 
		Only used if LOCAL is defined.
.TP
	'cost-codes-path'
		(default: /etc/eucs_code:/var/spool/lpd/eucs_code.%h)
		Search path for the cost-code file, another EUCS feature.
		The first file that exists and is readable will be used.
		Only used if LOCAL is defined.

HESIOD CONFIGURATION PARAMETERS:

	These are ignored if 'hesiod' is not used in the 'order' parameter,
	or if HESIOD is not defined in config.h.

.TP
	'hesiod-domains' (default: none)
		The list of domains to search for Hesiod lookups. This list
		should contain all the domains, separated by white space.
		If none are specified, then the local domain will
		be searched.

.TP
	'hesiod-printcap-key' (default: pcap)
		The key used in Hesiod queries to retrieve 'printcap' entries.

.TP
	'hesiod-cost-code-key' (default: eucs_code)
		The key used in Hesiod queries to retrieve EUCS cost
		code entries, an EUCS feature. Only used if HESIOD is
		defined.

NIS CONFIGURATION PARAMETERS:

	These are ignored if 'nis' is not used in the 'order' parameter,
	or if NIS is not defined in config.h.

.TP
	'nis-domains' (default: none)
		The NIS domain(s) to bind to when searching for printcap
		entries and (optionally) cost codes. This list should
		contain all the domains, separated by white space.
		If none are specified, then the local domain will
		be searched.
	
.TP
	'nis-printcap-map' (default: printcap.bykey printcap.byname)
		The two maps that correspond to the printcap database.
		Two arguments must be used here.

.TP
	'nis-cost-code-map'
		(default: eucs_code.bykey eucs_code.byname)
		The two maps that correspond to the EUCS cost code
		database. Two arguments must be used here.
		Only used if NIS is defined.

DEBUGGING PARAMETERS:

.TP
	'lpd-port' (default: "printer")
		The port that 'lpd' binds to, and that 'lpr' and
		the other client programs send their requests to.
		If this is numeric and within the valid IP port
		range, that port number is used; otherwise, a
		service lookup is performed and the corresponding
		service port is used; see services(5).
		This parameter is useful for debugging a new
		installation of PLP, in that running PLP on
		a different port from the default will not
		interfere with a previous installation of
		LPD or PLP.

.TP
	'controlfile-log-dir' (default: no)
		If the first argument is "no", then this functionality
		is used; otherwise, it is disabled.
		The (optional) second argument is the name of a directory
		where control files can be copied, providing a trace
		of both incoming and outgoing traffic.

EXAMPLE:
.nf
# PLP configuration file

user	daemon
architecture	sun4

logfile			/var/spool/lpd/lpd.log.%h
lockfile		/var/spool/lpd/lpd.lock.%h

printcap-path		/etc/printcap:/var/spool/lpd/printcap.%h
printer_perms-path	/etc/printer_perms:/var/spool/lpd/printer_perms.%h

filter-path /bin:/usr/bin:/usr/local/bin:/usr/ucb:/usr/local/bin.%a
filter-ld-path /lib:/usr/lib:/usr/ucblib:/usr/5lib:/usr/ccs/lib:/usr/openwin/lib

restrict-symlinks	no
eucs-banner-format	no
lpd-port		printer

mail-format		%u@iona.ie
log-requests		lpc lpr lprm

default-printcap-params	:mx\#0:sh:bk:

errors			yes	errors
minfree			yes	minfree
forms			yes	forms
.fi

HISTORY:
	Written by Justin Mason <jmason@iona.ie> for PLP v3.4.
	This is revision 1.0, dated 25 July 1994.

SEE ALSO:
	lpr(1), lprm(1), lpq(1), printcap(5), lpd(8), lpc(8)
