#include "lp.h"
#include "library/errormsg.h"
#include "library/filecache.h"

#define CACHE_ALLOC_STEP	4	/* alloc in steps of 4 lines */

void
chkandrealloc_cache (struct file_cache **c) {
    if ((*c)->size == 0) {
	(*c)->size = CACHE_ALLOC_STEP;
	(*c)->entries = (char **) malloc ((unsigned) sizeof (char *) * (*c)->size);
	if ((*c)->entries == NULL) {
	    logerr_die (XLOG_NOTICE, Malloc_failed_msg);
	}
    } else {
	chkandrealloc_list ((*c)->entries, (*c)->ind, (*c)->size, CACHE_ALLOC_STEP);
    }
}

/* This must be followed by a build_x_cache() call. */

void flush_cache (struct file_cache *c) {
    rewind_cache (c);
    c->entries[0] = NULL;
}

void rewind_cache (struct file_cache *c) {
    c->ind = 0;
}

void cache_addline (struct file_cache *c, const char *buf) {
    c->entries[c->ind] = (char *) strdup (buf);
    c->ind++;
}

void cache_addeof (struct file_cache *c) {
    c->entries[c->ind] = NULL;
}
