/* Prospection.c 
   Copyright 1993 Tristan Gingold
		  Written August 1993 Tristan Gingold

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.

   The author may be reached (Email) at the address marc@david.saclay.cea.fr,
   or (US/French mail) as Tristan Gingold 
   			  8 rue Parmentier
   			  F91120 PALAISEAU
   			  FRANCE */

#include <stdio.h>

#if defined(cplusplus) || (defined(__STDC__) && __STDC__)
typedef void *ptr_t;
#else
typedef char *ptr_t;
#endif

void stack_grows();
void pc_grows();
void page_size();

int main(int argc, char *argv[])
{
 /*determine how the stack grows */
 printf("Search how the stack grows...\n");
 stack_grows();
 printf("Search how PC grows...\n");
 pc_grows();
 printf("Search the page size...\n");
 page_size();
 return 0;
}

int stack1_grows(char *a)
{
 char b=*a;	/* silly */
 return (int)&b-(int)&a;
}

void stack_grows()
{
 char d=' ';
 int dir;
 
 dir = stack1_grows(&d);
 if( dir == 0)
 {
   printf(" The stack doesn't grow!!!!");
   return;
 }
 if( dir > 0)
   printf(" The stack grows upward.\n");
 else
   printf(" The stack grows downward.\n");
}

void pc_grows()
{
 int dir;
 
 dir = (ptr_t)(pc_grows) - (ptr_t)(stack_grows);
 if( dir == 0)
 {
   printf(" The PC doesn't grow!!!!");
   return;
 }
 if( dir > 0)
   printf(" The PC grows upward.\n");
 else
   printf(" The PC grows downward.\n");
}

void page_size()
{
  int a,b;
  int estimation=1;
  
  a = sbrk(0);	/* current top of data segment */
  while (a&1 == 0)
  {
    a >>= 1;
    estimation <<= 1;
  }
  if ( sbrk(1) != a)
    printf(" Strange behaviour of sbrk()...\n");
  b = sbrk(0);
  if ( sbrk(0) != b)
    printf(" Strange behaviour of sbrk()...\n");
  a = b-a;
  if ( a<0 || a > estimation)
    printf(" I don't understand anything...\n");
  printf(" Page size seems to be %d\n",a);
}
  